/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.utils.updates;

import de.codingair.tradesystem.lib.gson.JsonArray;
import de.codingair.tradesystem.lib.gson.JsonElement;
import de.codingair.tradesystem.lib.gson.JsonObject;
import de.codingair.tradesystem.lib.gson.JsonParser;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpdateNotifier {
    private static final String URL_DOWNLOAD = "https://www.spigotmc.org/resources/%s/update?update=%s";
    private static final String GITHUB_URL = "https://api.github.com/repos/erikzimmermann/%s/releases";
    private final String pluginVersion;
    private final String repository;
    private final int spigotId;
    private String version = null;
    private String downloadLink = null;
    private String updateInfo = null;
    private String releasesBehind = null;

    public UpdateNotifier(@NotNull String pluginVersion, @NotNull String repository, int spigotId) {
        this.pluginVersion = pluginVersion;
        this.repository = repository;
        this.spigotId = spigotId;
    }

    public boolean read() {
        String body = this.readBody();
        if (body == null) {
            return false;
        }
        try {
            JsonArray json = new JsonParser().parse(body).getAsJsonArray();
            int firstStable = 0;
            boolean matched = false;
            for (int i = 0; i < json.size(); ++i) {
                String version;
                JsonElement jsonElement = json.get(i);
                JsonObject release = jsonElement.getAsJsonObject();
                if (firstStable == i && !this.extractLatest(release)) {
                    ++firstStable;
                }
                if ((version = release.get("tag_name").getAsString()).contains("v")) {
                    version = version.substring(1);
                }
                if (!this.pluginEqualsVersion(version)) continue;
                matched = true;
                if (i - firstStable <= 0) break;
                this.releasesBehind = String.valueOf(i - firstStable);
                break;
            }
            if (!matched) {
                this.releasesBehind = json.size() - 1 + "+";
            }
            return this.releasesBehind != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean pluginEqualsVersion(@NotNull String version) {
        return this.pluginVersion.startsWith(version);
    }

    private boolean extractLatest(JsonObject release) {
        String version = release.get("tag_name").getAsString();
        String name = release.get("name").getAsString();
        if (!name.startsWith(version)) {
            return true;
        }
        name = name.replace(version + " - ", "");
        if (version.contains("v")) {
            version = version.substring(1);
        }
        String content = release.get("body").getAsString();
        Pattern pattern = Pattern.compile("Download: \\d*");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return false;
        }
        this.downloadLink = String.format(URL_DOWNLOAD, this.spigotId, matcher.group().replaceAll("\\D*", ""));
        this.version = version;
        this.updateInfo = name;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String readBody() {
        String url = String.format(GITHUB_URL, this.repository);
        try (InputStream inputStream = new URL(url).openStream();
             Scanner scanner = new Scanner(inputStream);){
            StringBuilder builder = new StringBuilder();
            while (scanner.hasNextLine()) {
                builder.append(scanner.nextLine());
            }
            String s = builder.toString();
            if (s.isEmpty()) return null;
            String string = s;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public String getDownloadLink() {
        if (this.downloadLink == null) {
            throw new NullPointerException("UpdateNotifier#read() has to be called first!");
        }
        return this.downloadLink;
    }

    @NotNull
    public String getVersion() {
        if (this.version == null) {
            throw new NullPointerException("UpdateNotifier#read() has to be called first!");
        }
        return this.version;
    }

    @NotNull
    public String getUpdateInfo() {
        if (this.updateInfo == null) {
            throw new NullPointerException("UpdateNotifier#read() has to be called first!");
        }
        return this.updateInfo;
    }

    @Nullable
    public String getReleasesBehind() {
        if (this.version == null) {
            throw new NullPointerException("UpdateNotifier#read() has to be called first!");
        }
        return this.releasesBehind;
    }
}

