/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.utils;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.spigot.TradeSystem;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Permissions {
    public static final String PERMISSION_NOTIFY = "TradeSystem.Notify";
    public static final String PERMISSION_MODIFY = "TradeSystem.Modify";
    public static final String PERMISSION_LOG = "TradeSystem.Log";
    public static String PERMISSION = "TradeSystem.Trade";
    public static String PERMISSION_INITIATE = "TradeSystem.Trade.Initiate";
    private static final String[] PLUGINS = new String[]{"LuckPerms", "PermissionsEx", "GroupManager", "Vault", "bPermissions", "PermissionsBukkit", "zPermissions", "UltraPermissions", "PermissionsManager", "Permissions", "PermissionsPlus"};

    public static void checkPermissions(boolean firstSetup) {
        Runnable runnable = () -> {
            if (!Permissions.arePermissionsEnabled()) {
                PERMISSION = null;
                PERMISSION_INITIATE = null;
            }
        };
        if (firstSetup) {
            Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> {
                if (!Permissions.findPermissionsPlugin()) {
                    Permissions.disableInConfig();
                }
                runnable.run();
            });
        } else {
            runnable.run();
        }
    }

    private static boolean findPermissionsPlugin() {
        for (String plugin : PLUGINS) {
            if (!Bukkit.getPluginManager().isPluginEnabled(plugin)) continue;
            return true;
        }
        return false;
    }

    private static void disableInConfig() {
        ConfigFile configFile = TradeSystem.getInstance().getFileManager().getFile("Config");
        configFile.getConfig().set("TradeSystem.Permissions", (Object)false);
        configFile.saveConfig();
    }

    public static boolean arePermissionsEnabled() {
        return TradeSystem.getInstance().getFileManager().getFile("Config").getConfig().getBoolean("TradeSystem.Permissions", true);
    }
}

