/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.utils;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.files.FileManager;
import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.extras.external.placeholderapi.PlaceholderDependency;
import de.codingair.tradesystem.spigot.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Lang {
    private static final String[] LANGUAGES = new String[]{"BR", "CHI", "CS", "ENG", "ES", "FR", "GER", "IT", "POL", "RUS", "TR", "UA", "VI"};
    private static final String DEFAULT_LANG = "ENG";
    private static final Map<String, JavaPlugin> PLUGINS = new HashMap<String, JavaPlugin>();
    private static final Map<String, FileManager> MANAGERS = new HashMap<String, FileManager>();
    private static final Map<String, String> CACHED_PATHS = new HashMap<String, String>();

    private static void deleteEmptyFiles(JavaPlugin plugin) {
        File folder = new File(plugin.getDataFolder(), "/Languages/");
        if (folder.exists()) {
            File[] children = folder.listFiles();
            if (children == null) {
                throw new NullPointerException("Could not create language files!");
            }
            for (File file : children) {
                if (file.length() != 0L) continue;
                file.delete();
            }
        }
    }

    public static void init(@NotNull JavaPlugin plugin, @NotNull FileManager fileManager) {
        String path = plugin.getClass().getPackage().getName().toLowerCase();
        PLUGINS.put(path, plugin);
        MANAGERS.put(path, fileManager);
        Lang.initPreDefinedLanguages(plugin);
        Lang.checkLanguageKeys(plugin);
    }

    @NotNull
    private static String getAccessingPath() {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        for (int i = 2; i < elements.length; ++i) {
            StackTraceElement e = elements[i];
            String c = e.getClassName();
            if (Lang.class.getName().equals(c)) continue;
            int idx = c.lastIndexOf(".");
            if (idx > 0) {
                return c.substring(0, idx);
            }
            return "";
        }
        throw new IllegalStateException("Could not find accessing path!");
    }

    @NotNull
    private static String getIdentityPath() {
        String path = Lang.getAccessingPath();
        String identity = CACHED_PATHS.get(path);
        if (identity != null) {
            return identity;
        }
        for (String key : PLUGINS.keySet()) {
            if (!path.startsWith(key)) continue;
            CACHED_PATHS.put(path, key);
            return key;
        }
        throw new IllegalStateException("Could not find identity path!");
    }

    @NotNull
    private static FileManager getManager() {
        String path = Lang.getIdentityPath();
        return MANAGERS.get(path);
    }

    @NotNull
    private static JavaPlugin getPlugin() {
        String path = Lang.getIdentityPath();
        return PLUGINS.get(path);
    }

    private static void initPreDefinedLanguages(@NotNull JavaPlugin plugin) {
        Lang.deleteEmptyFiles(plugin);
        File folder = new File(plugin.getDataFolder(), "/Languages/");
        if (!folder.exists()) {
            Lang.mkDir(folder);
        }
        for (String language : LANGUAGES) {
            try {
                FileUtils.createFile(plugin, "languages/", "/Languages/", language + ".yml", false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkLanguageKeys(@NotNull JavaPlugin plugin) {
        FileManager manager = Lang.getManager();
        FileConfiguration def = Lang.getLanguageFile(plugin, manager, DEFAULT_LANG);
        for (String language : LANGUAGES) {
            File languageFile = new File(plugin.getDataFolder(), "/Languages/" + language + ".yml");
            if (!languageFile.exists()) continue;
            FileConfiguration file = Lang.getLanguageFile(plugin, manager, language);
            for (String key : def.getKeys(true)) {
                if (file.contains(key)) continue;
                plugin.getLogger().warning("Missing language key \"" + key + "\" in " + language + ".yml. Using default value.");
                file.set(key, def.get(key));
            }
        }
    }

    public static void send(@NotNull CommandSender sender, @NotNull String key, P ... placeholders) {
        Lang.send(sender, "", key, placeholders);
    }

    public static void send(@NotNull CommandSender sender, @NotNull String prefix, @NotNull String key, P ... placeholders) {
        Lang.send(sender, prefix, key, CommandSender::sendMessage, placeholders);
    }

    public static void send(@Nullable CommandSender sender, @NotNull String prefix, @NotNull String key, @NotNull BiConsumer<CommandSender, String> send, P ... placeholders) {
        String message = sender instanceof Player ? Lang.get(key, (Player)sender, placeholders) : Lang.get(key, placeholders);
        if (message.isEmpty()) {
            return;
        }
        send.accept(sender, Lang.getPrefix() + prefix + message);
    }

    @NotNull
    public static String getPrefix() {
        String prefix = Lang.getConfig().getString("TradeSystem.Prefix", "&8\u00bb &r");
        return Lang.prepare(null, prefix);
    }

    @NotNull
    public static String getLanguageKey() {
        String key = Lang.getConfig().getString("TradeSystem.Language");
        if (key == null) {
            return DEFAULT_LANG;
        }
        return key;
    }

    @NotNull
    private static FileConfiguration getLanguageFile(@Nullable JavaPlugin plugin, @Nullable FileManager fileManager, @NotNull String langTag) {
        ConfigFile configFile;
        if (plugin == null) {
            plugin = TradeSystem.getInstance();
        }
        if (fileManager == null) {
            fileManager = TradeSystem.getInstance().getFileManager();
        }
        if ((configFile = fileManager.getFile(langTag)) == null) {
            File file = new File(plugin.getDataFolder() + "/Languages/", langTag + ".yml");
            if (!file.exists()) {
                langTag = DEFAULT_LANG;
            }
            fileManager.loadFile(langTag, "/Languages/", "languages/");
            configFile = fileManager.getFile(langTag);
        }
        return configFile.getConfig();
    }

    @NotNull
    public static String get(@NotNull String key, P ... placeholders) {
        return Lang.get(key, null, placeholders);
    }

    @NotNull
    public static String get(@NotNull String key, @Nullable Player p, P ... placeholders) {
        try {
            return Lang.get(Lang.getPlugin(), Lang.getManager(), key, p, placeholders);
        }
        catch (NullPointerException e) {
            return Lang.get(null, null, key, p, placeholders);
        }
    }

    @NotNull
    private static String get(@Nullable JavaPlugin plugin, @Nullable FileManager fileManager, @NotNull String key, @Nullable Player p, P ... placeholders) {
        String s = Lang.getLanguageFile(plugin, fileManager, Lang.getLanguageKey()).getString(key, null);
        if (s == null) {
            throw new NullPointerException("Message \"" + key + "\" cannot be found in " + Lang.getLanguageKey());
        }
        for (P placeholder : placeholders) {
            s = placeholder.apply(s);
        }
        return Lang.prepare(p, s);
    }

    private static String prepare(@Nullable Player player, @NotNull String s) {
        s = s.replace("\\n", "\n");
        s = ChatColor.translateAll('&', s);
        if (player != null) {
            s = PlaceholderDependency.convert(s, player);
        }
        return s;
    }

    private static FileConfiguration getConfig() {
        return TradeSystem.getInstance().getFileManager().getFile("Config").getConfig();
    }

    private static void mkDir(File file) {
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException ex) {
                throw new IllegalArgumentException("Plugin is not permitted to create a folder!");
            }
        }
    }

    public static class P {
        private final String placeholder;
        private final String replacement;

        public P(@NotNull String placeholder, @NotNull String replacement) {
            this.placeholder = placeholder;
            this.replacement = replacement;
        }

        @NotNull
        public String apply(@NotNull String s) {
            return s.replace("%" + this.placeholder + "%", this.replacement);
        }
    }
}

