/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.utils;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.bukkit.plugin.java.JavaPlugin;

public class FileUtils {
    public static void createFile(@NotNull JavaPlugin plugin, @NotNull String internalPath, @NotNull String externalPath, String fileName, boolean overwrite) throws IOException {
        File file;
        boolean exists;
        InputStream is = plugin.getResource(internalPath + fileName);
        if (is == null) {
            return;
        }
        File folder = new File(plugin.getDataFolder(), externalPath);
        if (!folder.exists() && !folder.mkdirs()) {
            plugin.getLogger().warning("Could not create folder: " + externalPath);
        }
        if (!(exists = (file = new File(folder, fileName)).exists()) || overwrite) {
            if (!exists && !file.createNewFile()) {
                plugin.getLogger().warning("Could not create file: " + externalPath + fileName);
            }
            FileUtils.copy(is, Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
    }

    public static void copy(@Nullable InputStream from, @NotNull OutputStream to) throws IOException {
        if (from == null) {
            return;
        }
        byte[] buf = new byte[4096];
        int r;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
        return;
    }
}

