/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.utils;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.spigot.TradeSystem;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class BackwardSupport {
    private final YamlConfiguration old = TradeSystem.getInstance().getOldConfig();
    private final ConfigFile current = TradeSystem.getInstance().getFileManager().getFile("Config");
    private boolean changed = false;

    public BackwardSupport() {
        this.moveShiftRightClick();
        this.moveRequestCooldownInSek();
        this.moveCommandAliases();
        this.moveEasyMoneySelection();
        this.moveTradeLog();
        this.moveMySQLSettings();
        this.outsourceDbFromTradeLog();
        if (this.changed) {
            this.current.saveConfig();
        }
    }

    private void moveShiftRightClick() {
        if (this.old.get("TradeSystem.Action_To_Request.Rightclick", null) != null) {
            this.current.getConfig().set("TradeSystem.Action_To_Request.Shift_Rightclick", (Object)(this.old.getBoolean("TradeSystem.Action_To_Request.Rightclick") && this.old.getBoolean("TradeSystem.Action_To_Request.Shiftclick") ? 1 : 0));
            this.changed = true;
        }
    }

    private void moveRequestCooldownInSek() {
        if (this.old.get("TradeSystem.Request_Cooldown_In_Sek", null) != null) {
            this.current.getConfig().set("TradeSystem.Trade_Request_Expiration_Time", (Object)this.old.getInt("TradeSystem.Request_Cooldown_In_Sek"));
            this.changed = true;
        }
    }

    private void moveCommandAliases() {
        if (this.old.get("TradeSystem.Trade_Aliases", null) != null) {
            this.current.getConfig().set("TradeSystem.Commands.Trade", (Object)this.old.getList("TradeSystem.Trade_Aliases"));
            this.changed = true;
        }
    }

    private void moveEasyMoneySelection() {
        if (this.old.get("TradeSystem.Easy_Money_Selection", null) != null) {
            this.current.getConfig().set("TradeSystem.Money.Easy_Selection", this.old.get("TradeSystem.Easy_Money_Selection"));
            this.changed = true;
        }
    }

    private void moveTradeLog() {
        boolean oldCaseSensitive;
        ConfigurationSection sec = this.old.getConfigurationSection("TradeSystem.Tradelog");
        if (sec != null && (oldCaseSensitive = sec.getKeys(false).contains("Tradelog"))) {
            this.current.getConfig().set("TradeSystem.TradeLog", (Object)this.old.getConfigurationSection("TradeSystem.Tradelog"));
            this.changed = true;
        }
    }

    private void moveMySQLSettings() {
        if (this.old.contains("TradeSystem.TradeLog.Database.Db_host")) {
            String url = "jdbc:mysql://%s:%s/%s?autoReconnect=true&useSSL=false";
            url = String.format(url, this.old.getString("TradeSystem.TradeLog.Database.Db_host"), this.old.getInt("TradeSystem.TradeLog.Database.Db_port") + "", this.old.getString("TradeSystem.TradeLog.Database.Db_name"));
            this.current.getConfig().set("TradeSystem.TradeLog.Database.MySQL.Connection_URL", (Object)url);
            this.current.getConfig().set("TradeSystem.TradeLog.Database.MySQL.User", (Object)this.old.getString("TradeSystem.TradeLog.Database.Db_user"));
            this.current.getConfig().set("TradeSystem.TradeLog.Database.MySQL.Password", (Object)this.old.getString("TradeSystem.TradeLog.Database.Db_password"));
            this.changed = true;
        }
    }

    private void outsourceDbFromTradeLog() {
        if (this.old.contains("TradeSystem.TradeLog.Database")) {
            String type = this.old.getString("TradeSystem.TradeLog.Database.Type");
            boolean bukkit = "bukkit".equalsIgnoreCase(type);
            this.current.getConfig().set("TradeSystem.TradeLog.Bukkit_logger", (Object)bukkit);
            this.current.getConfig().set("TradeSystem.Database.Type", (Object)(bukkit ? "SQLite" : type));
            this.current.getConfig().set("TradeSystem.Database.MySQL.Connection_URL", (Object)this.old.getString("TradeSystem.TradeLog.Database.MySQL.Connection_URL"));
            this.current.getConfig().set("TradeSystem.Database.MySQL.User", (Object)this.old.getString("TradeSystem.TradeLog.Database.MySQL.User"));
            this.current.getConfig().set("TradeSystem.Database.MySQL.Password", (Object)this.old.getString("TradeSystem.TradeLog.Database.MySQL.Password"));
            this.changed = true;
        }
    }
}

