/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.transfer.utils;

import de.codingair.tradesystem.lib.jetbrains.annotations.Contract;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStackUtils {
    private static final int MAX_TRANSFER_LIMIT = 30000;

    public static boolean isCompatible(@NotNull ItemStack item) {
        try {
            byte[] data = ItemStackUtils.serialize(item);
            if (data.length >= 30000) {
                return false;
            }
            ItemStack itemCopy = ItemStackUtils.deserialize(data);
            return item.equals((Object)itemCopy);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Contract(value="null -> null")
    public static byte[] serialize(@Nullable ItemStack item) {
        byte[] byArray;
        if (item == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            BukkitObjectOutputStream boos = new BukkitObjectOutputStream((OutputStream)bos);
            boos.writeObject((Object)item);
            byte[] data = bos.toByteArray();
            bos.close();
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bos.close();
        return byArray;
    }

    @Contract(value="null -> null")
    public static ItemStack deserialize(byte @Nullable [] data) {
        ItemStack itemStack;
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            BukkitObjectInputStream bois = new BukkitObjectInputStream((InputStream)bais);
            itemStack = (ItemStack)bois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        bais.close();
        return itemStack;
    }
}

