/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.transfer.handlers;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.handlers.PacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import de.codingair.tradesystem.proxy.packets.TradeInitializedPacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.ProxyTrade;
import de.codingair.tradesystem.spigot.trade.Trade;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TradeInitializedPacketHandler
implements PacketHandler<TradeInitializedPacket> {
    private static final long MAX_WAITING_TIME = 1000L;

    @Override
    public void process(@NotNull TradeInitializedPacket packet, @NotNull Proxy proxy, @Nullable Object connection, @NotNull Direction direction) {
        if (this.markAsReceived(packet)) {
            return;
        }
        long start = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskTimer((Plugin)TradeSystem.getInstance(), runner -> {
            if (this.markAsReceived(packet)) {
                runner.cancel();
                return;
            }
            if (System.currentTimeMillis() - start > 1000L) {
                runner.cancel();
                TradeSystem.getInstance().getLogger().severe("The trade initialization packet from " + packet.getPlayer() + " was not received by the server!");
            }
        }, 1L, 1L);
    }

    private boolean markAsReceived(@NotNull TradeInitializedPacket packet) {
        Trade trade = TradeSystem.handler().getTrade(packet.getPlayer());
        if (trade != null) {
            if (trade instanceof ProxyTrade) {
                ((ProxyTrade)trade).receiveFirstPacket();
            }
            return true;
        }
        return false;
    }
}

