/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.transfer.handlers;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.handlers.ResponsiblePacketHandler;
import de.codingair.tradesystem.lib.packetmanagement.utils.Direction;
import de.codingair.tradesystem.lib.packetmanagement.utils.Proxy;
import de.codingair.tradesystem.proxy.packets.InviteResponsePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeRequestPreResponseEvent;
import de.codingair.tradesystem.spigot.events.TradeRequestResponseEvent;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class InviteResponsePacketHandler
implements ResponsiblePacketHandler<InviteResponsePacket, InviteResponsePacket.ResultPacket> {
    @Override
    public void process(@NotNull InviteResponsePacket packet, @NotNull Proxy proxy, @Nullable Object connection, @NotNull Direction direction) {
        this.response(packet, proxy, connection, direction);
    }

    @Override
    @NotNull
    public CompletableFuture<InviteResponsePacket.ResultPacket> response(@NotNull InviteResponsePacket packet, @NotNull Proxy proxy, @Nullable Object o, @NotNull Direction direction) {
        Player player = Bukkit.getPlayerExact((String)packet.getInviter());
        if (player == null) {
            return CompletableFuture.completedFuture(new InviteResponsePacket.ResultPacket(InviteResponsePacket.Result.NOT_ONLINE, null));
        }
        TradeRequestPreResponseEvent e = new TradeRequestPreResponseEvent(player.getName(), player.getUniqueId(), player, packet.getResponding(), packet.getRespondingId(), null, packet.isAccept());
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return CompletableFuture.completedFuture(null);
        }
        TradeRequestResponseEvent e2 = new TradeRequestResponseEvent(player.getName(), player.getUniqueId(), player, packet.getResponding(), packet.getRespondingId(), null, packet.isAccept());
        Bukkit.getPluginManager().callEvent((Event)e2);
        TradeSystem.invitations().invalidate(player, packet.getResponding());
        if (packet.isAccept()) {
            TradeSystem.handler().startTrade(player, packet.getResponding(), packet.getRespondingId(), packet.getRespondingWorld(), packet.getRespondingServer(), true);
            return CompletableFuture.completedFuture(new InviteResponsePacket.ResultPacket(InviteResponsePacket.Result.SUCCESS, player.getWorld().getName()));
        }
        Lang.send((CommandSender)player, "Request_Was_Denied", new Lang.P("player", packet.getResponding()));
        return CompletableFuture.completedFuture(null);
    }
}

