/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.transfer;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.packetmanagement.variants.bytestream.OneWayStreamDataHandler;
import de.codingair.tradesystem.proxy.packets.InviteResponsePacket;
import de.codingair.tradesystem.proxy.packets.PacketType;
import de.codingair.tradesystem.proxy.packets.PlayerInventoryPacket;
import de.codingair.tradesystem.proxy.packets.PlayerJoinPacket;
import de.codingair.tradesystem.proxy.packets.PlayerQuitPacket;
import de.codingair.tradesystem.proxy.packets.PlayerStatePacket;
import de.codingair.tradesystem.proxy.packets.PublishSkinPacket;
import de.codingair.tradesystem.proxy.packets.SynchronizePlayersPacket;
import de.codingair.tradesystem.proxy.packets.TradeCheckFinishPacket;
import de.codingair.tradesystem.proxy.packets.TradeIconUpdatePacket;
import de.codingair.tradesystem.proxy.packets.TradeInitializedPacket;
import de.codingair.tradesystem.proxy.packets.TradeInvitePacket;
import de.codingair.tradesystem.proxy.packets.TradeItemUpdatePacket;
import de.codingair.tradesystem.proxy.packets.TradeStateUpdatePacket;
import de.codingair.tradesystem.proxy.packets.VersionPacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.transfer.handlers.InviteResponsePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.PlayerInventoryPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.PlayerJoinPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.PlayerQuitPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.PlayerStatePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.PublishSkinPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.SynchronizePlayersPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeCheckFinishPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeIconUpdatePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeInitializedPacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeInvitePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeItemUpdatePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.TradeStateUpdatePacketHandler;
import de.codingair.tradesystem.spigot.transfer.handlers.VersionPacketHandler;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SpigotHandler
extends OneWayStreamDataHandler<Player>
implements PluginMessageListener {
    public SpigotHandler(TradeSystem plugin) {
        super("tradesystem", plugin);
    }

    @Override
    public void registering() {
        for (PacketType value : PacketType.values()) {
            this.registerPacket(value.getPacketClass());
        }
        this.registerHandler(PlayerJoinPacket.class, new PlayerJoinPacketHandler());
        this.registerHandler(PlayerQuitPacket.class, new PlayerQuitPacketHandler());
        this.registerHandler(PlayerStatePacket.class, new PlayerStatePacketHandler());
        this.registerHandler(PublishSkinPacket.class, new PublishSkinPacketHandler());
        this.registerHandler(VersionPacket.class, new VersionPacketHandler());
        if (TradeSystem.handler().tradeProxy()) {
            this.registerHandler(TradeInvitePacket.class, new TradeInvitePacketHandler());
            this.registerHandler(TradeInitializedPacket.class, new TradeInitializedPacketHandler());
            this.registerHandler(PlayerInventoryPacket.class, new PlayerInventoryPacketHandler());
            this.registerHandler(TradeItemUpdatePacket.class, new TradeItemUpdatePacketHandler());
            this.registerHandler(TradeStateUpdatePacket.class, new TradeStateUpdatePacketHandler());
            this.registerHandler(InviteResponsePacket.class, new InviteResponsePacketHandler());
            this.registerHandler(TradeCheckFinishPacket.class, new TradeCheckFinishPacketHandler());
            this.registerHandler(SynchronizePlayersPacket.class, new SynchronizePlayersPacketHandler());
            this.registerHandler(TradeIconUpdatePacket.class, new TradeIconUpdatePacketHandler());
        }
    }

    public void onEnable() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)((TradeSystem)this.proxy), this.channelProxy);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)((TradeSystem)this.proxy), this.channelBackend, (PluginMessageListener)this);
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            this.send(new SynchronizePlayersPacket(), null);
        }
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)((TradeSystem)this.proxy), this.channelProxy);
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)((TradeSystem)this.proxy), this.channelBackend, (PluginMessageListener)this);
    }

    @Override
    protected void send(byte[] data, Player p) {
        if (p == null) {
            p = this.getAny();
        }
        if (p == null) {
            return;
        }
        p.sendPluginMessage((Plugin)this.getProxy(), this.channelProxy, data);
    }

    public void onPluginMessageReceived(@NotNull String tag, @NotNull Player player, byte[] bytes) {
        if (tag.equals(this.getChannelBackend())) {
            this.receive(bytes, player);
        }
    }

    private Player getAny() {
        Optional opt = Bukkit.getOnlinePlayers().stream().findFirst();
        return opt.orElse(null);
    }
}

