/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.transfer;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.extras.blacklist.BlockedItem;
import de.codingair.tradesystem.spigot.trade.ProxyTrade;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ProxyDataHandler
implements PluginMessageListener {
    private final Map<String, String> cache = new HashMap<String, String>();
    private final HashMap<String, String> players = new HashMap();
    private final HashMap<String, UUID> uuids = new HashMap();
    private final HashMap<String, String> skins = new HashMap();
    private String tradeProxyVersion = null;
    private String serverName = null;
    private boolean noticedAboutTradeProxy = false;

    public void onEnable() {
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)TradeSystem.getInstance(), "BungeeCord", (PluginMessageListener)this);
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)TradeSystem.getInstance(), "BungeeCord");
        this.checkForServerName();
    }

    public void onDisable() {
        Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)TradeSystem.getInstance(), "BungeeCord", (PluginMessageListener)this);
        Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)TradeSystem.getInstance(), "BungeeCord");
        this.players.clear();
    }

    private void sendTradeProxyNote() {
        if (TradeSystem.handler().tradeProxy()) {
            return;
        }
        if (this.noticedAboutTradeProxy) {
            return;
        }
        TradeSystem.getInstance().getLogger().warning("========================================");
        TradeSystem.getInstance().getLogger().warning("The 'TradeProxy' option is disabled but TradeProxy has been detected. If you are sure that TradeProxy is installed, you can activate the 'TradeProxy' option in your config.yml file or by running 'tradesystem activateTradeProxy confirm'. This check prevents custom payload attacks.");
        TradeSystem.getInstance().getLogger().warning("========================================");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("TradeSystem.Modify")) continue;
            player.sendMessage(Lang.getPrefix() + "\u00a7cWarning! \u00a77The 'TradeProxy' option is \u00a7cdisabled \u00a77but \u00a7eTradeProxy \u00a77has been detected. If you are sure that \u00a7eTradeProxy \u00a77is installed, you can activate the 'TradeProxy' option in your config.yml file or by running \u00a7e/tradesystem activateTradeProxy confirm\u00a77. This check prevents \u00a7ccustom payload attacks\u00a77.");
        }
        this.noticedAboutTradeProxy = true;
    }

    public void join(@NotNull String player, @NotNull UUID playerId) {
        this.sendTradeProxyNote();
        this.players.put(player.toLowerCase(), player);
        this.uuids.put(player.toLowerCase(), playerId);
        this.cache.clear();
    }

    public void addSkin(@NotNull String player, @NotNull String skinId) {
        this.skins.put(player.toLowerCase(), skinId);
    }

    @Nullable
    public String getSkin(@NotNull String player) {
        return this.skins.get(player.toLowerCase());
    }

    public void quit(@NotNull String player) {
        this.players.remove(player.toLowerCase());
        this.uuids.remove(player.toLowerCase());
        this.skins.remove(player.toLowerCase());
        this.cache.clear();
    }

    public void clearPlayers() {
        this.cache.clear();
        this.players.clear();
    }

    public int getTradeHash() {
        Pattern pattern = TradeSystem.getInstance().getLayoutManager().getActive();
        int patternHash = pattern.hashCode();
        int cooldown = TradeSystem.handler().getCountdownRepetitions() * TradeSystem.handler().getCountdownInterval();
        int blacklist = 0;
        for (BlockedItem blockedItem : TradeSystem.handler().getBlacklist()) {
            blacklist = Objects.hash(blacklist, blockedItem.hashCode());
        }
        return Objects.hash(new Object[]{Version.get(), patternHash, cooldown, TradeSystem.handler().isRevokeReadyOnChange(), blacklist, TradeSystem.getInstance().getDescription().getVersion(), TradeSystem.handler().isDropItems()});
    }

    public Stream<String> getPlayers(@Nullable CommandSender sender) {
        if (sender == null) {
            return this.players.values().stream();
        }
        return this.players.values().stream().filter(n -> !n.equals(sender.getName()));
    }

    @NotNull
    public String getCaseSensitive(@NotNull String player) {
        String name = this.getPlayerName(player);
        return name == null ? player : name;
    }

    @NotNull
    public UUID getUniqueId(@NotNull String player) {
        return this.uuids.get(player.toLowerCase());
    }

    public boolean isOnline(String player) {
        return this.getPlayerName(player) != null;
    }

    @Nullable
    private String getPlayerName(@NotNull String name) {
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        String found = this.players.get(lowerName);
        if (found != null) {
            return found;
        }
        found = this.cache.get(lowerName);
        if (found != null) {
            return found;
        }
        for (String player : this.players.values()) {
            if (!player.equalsIgnoreCase(name)) continue;
            found = player;
            break;
        }
        if (found != null) {
            this.cache.put(lowerName, found);
        }
        return found;
    }

    @Nullable
    public ProxyTrade getTrade(@NotNull String name, @NotNull String other) {
        Trade trade = TradeSystem.handler().getTrade(name);
        if (trade instanceof ProxyTrade && other.equals(trade.getOther(name))) {
            return (ProxyTrade)trade;
        }
        return null;
    }

    @Nullable
    public String getTradeProxyVersion() {
        return this.tradeProxyVersion;
    }

    public void setTradeProxyVersion(@NotNull String tradeProxyVersion) {
        this.tradeProxyVersion = tradeProxyVersion;
    }

    public void checkForServerName() {
        if (this.serverName != null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> {
            if (this.serverName != null) {
                return;
            }
            Player player = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
            if (player == null) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeUTF("GetServer");
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write plugin message", e);
            }
            player.sendPluginMessage((Plugin)TradeSystem.getInstance(), "BungeeCord", baos.toByteArray());
        }, 20L);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        DataInputStream dis = new DataInputStream(bais);
        try {
            String subChannel = dis.readUTF();
            if (!subChannel.equals("GetServer")) {
                return;
            }
            this.serverName = dis.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read plugin message", e);
        }
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }
}

