/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.managers;

import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButton;
import de.codingair.tradesystem.lib.codingapi.player.chat.SimpleMessage;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.proxy.packets.TradeInvitePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.managers.InvitationManager;
import de.codingair.tradesystem.spigot.utils.Lang;
import de.codingair.tradesystem.spigot.utils.Permissions;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class RuleManager {
    public static boolean isViolatingRules(Player p) {
        if (Permissions.PERMISSION != null && !p.hasPermission(Permissions.PERMISSION)) {
            Lang.send((CommandSender)p, "\u00a7c", "Not_Able_To_Trade", new Lang.P[0]);
            return true;
        }
        if (TradeSystem.getInstance().getTradeManager().isOffline(p)) {
            RuleManager.notifyOfflinePlayer(p);
            return true;
        }
        if (TradeSystem.getInstance().getTradeManager().isBlockedWorld(p.getWorld())) {
            Lang.send((CommandSender)p, "\u00a7c", "Cannot_trade_in_world", new Lang.P[0]);
            return true;
        }
        if (!TradeSystem.getInstance().getTradeManager().getAllowedGameModes().contains(p.getGameMode().name())) {
            Lang.send((CommandSender)p, "Cannot_trade_in_that_GameMode", new Lang.P[0]);
            return true;
        }
        if (p.isSleeping()) {
            Lang.send((CommandSender)p, "Cannot_trade_in_bed", new Lang.P[0]);
            return true;
        }
        return false;
    }

    public static void handle(@NotNull Player player, @NotNull String other, @NotNull TradeInvitePacket.ResultPacket result) {
        if (result.getResult() == TradeInvitePacket.Result.INVITED) {
            InvitationManager.registerInvitation(player, player.getName(), result.getRecipientId(), null, other);
        }
        RuleManager.message(player, other, result.getResult(), result.getServerOpt().orElse(null));
    }

    public static TradeInvitePacket.Result isOtherViolatingRules(@NotNull Player other) {
        if (Permissions.PERMISSION != null && !other.hasPermission(Permissions.PERMISSION)) {
            return TradeInvitePacket.Result.NO_PERMISSION;
        }
        if (TradeSystem.getInstance().getTradeManager().isOffline(other)) {
            return TradeInvitePacket.Result.MARKED_AS_OFFLINE;
        }
        if (TradeSystem.getInstance().getTradeManager().isBlockedWorld(other.getWorld())) {
            return TradeInvitePacket.Result.BLOCKED_WORLD;
        }
        if (!TradeSystem.getInstance().getTradeManager().getAllowedGameModes().contains(other.getGameMode().name())) {
            return TradeInvitePacket.Result.GAME_MODE;
        }
        if (other.isSleeping()) {
            return TradeInvitePacket.Result.SLEEPING;
        }
        if (TradeSystem.handler().isTrading(other)) {
            return TradeInvitePacket.Result.IS_ALREADY_TRADING;
        }
        return TradeInvitePacket.Result.INVITED;
    }

    public static boolean isViolatingRules(Player player, Player other, String otherName) {
        if (RuleManager.isViolatingRules(player)) {
            return true;
        }
        if (other == null || !player.canSee(other)) {
            Lang.send((CommandSender)player, "Player_Not_Online", new Lang.P("player", otherName));
            return true;
        }
        if (other.equals((Object)player)) {
            Lang.send((CommandSender)player, "Cannot_Trade_With_Yourself", new Lang.P[0]);
            return true;
        }
        if (Permissions.PERMISSION != null && !other.hasPermission(Permissions.PERMISSION)) {
            RuleManager.message(player, other.getName(), TradeInvitePacket.Result.NO_PERMISSION, null);
            return true;
        }
        if (TradeSystem.getInstance().getTradeManager().isOffline(other)) {
            RuleManager.message(player, other.getName(), TradeInvitePacket.Result.MARKED_AS_OFFLINE, null);
            return true;
        }
        if (TradeSystem.getInstance().getTradeManager().isBlockedWorld(other.getWorld())) {
            RuleManager.message(player, other.getName(), TradeInvitePacket.Result.BLOCKED_WORLD, null);
            return true;
        }
        if (!TradeSystem.getInstance().getTradeManager().getAllowedGameModes().contains(other.getGameMode().name())) {
            RuleManager.message(player, other.getName(), TradeInvitePacket.Result.GAME_MODE, null);
            return true;
        }
        if (other.isSleeping()) {
            RuleManager.message(player, other.getName(), TradeInvitePacket.Result.SLEEPING, null);
            return true;
        }
        if (!other.canSee(player)) {
            Lang.send((CommandSender)player, "Cannot_trade_while_invisible", new Lang.P[0]);
            return true;
        }
        if (TradeSystem.getInstance().getTradeManager().getDistance() > 0 && (!player.getWorld().equals((Object)other.getWorld()) || player.getLocation().distance(other.getLocation()) > (double)TradeSystem.getInstance().getTradeManager().getDistance())) {
            Lang.send((CommandSender)player, "\u00a7c", "Player_is_not_in_range", new Lang.P("player", other.getName()));
            return true;
        }
        return false;
    }

    public static void message(Player player, String other, TradeInvitePacket.Result result, @Nullable String server) {
        switch (result) {
            case NO_PERMISSION: {
                Lang.send((CommandSender)player, "\u00a7c", "Player_Is_Not_Able_Trade", new Lang.P[0]);
                break;
            }
            case NOT_ONLINE: 
            case MARKED_AS_OFFLINE: 
            case SLEEPING: {
                Lang.send((CommandSender)player, "Trade_Partner_is_Offline", new Lang.P[0]);
                break;
            }
            case OTHER_GROUP: 
            case INCOMPATIBLE: {
                assert (server != null);
                TradeSystem.getInstance().getLogger().log(Level.WARNING, "\"" + player.getName() + "\" tried to trade with \"" + other + "\" on server \"" + server + "\" but the server versions, trade configurations or plugin versions from both servers are incompatible.\n\nYou have two options to solve this:\n1. Use the group function in the trade-configuration file on your proxy to separate both servers from each other or\n2. Copy the Config.yml from one server to the other server and make sure both server/plugin versions are the same.");
                Lang.send((CommandSender)player, "Trade_Partner_is_Offline", new Lang.P[0]);
                break;
            }
            case BLOCKED_WORLD: {
                Lang.send((CommandSender)player, "\u00a7c", "Other_cannot_trade_in_world", new Lang.P[0]);
                break;
            }
            case GAME_MODE: {
                Lang.send((CommandSender)player, "Other_cannot_trade_in_that_GameMode", new Lang.P[0]);
                break;
            }
            case INVITED: {
                Lang.send((CommandSender)player, "Player_Is_Invited", new Lang.P("player", other));
                break;
            }
            case IS_ALREADY_TRADING: {
                Lang.send((CommandSender)player, "Other_is_already_trading", new Lang.P[0]);
            }
        }
    }

    private static void notifyOfflinePlayer(final Player p) {
        String text = Lang.get("Trade_You_are_Offline", p, new Lang.P[0]);
        if (text.isEmpty()) {
            return;
        }
        String[] a = text.split("%command%", -1);
        if (a.length != 3) {
            p.sendMessage(Lang.getPrefix() + text);
            return;
        }
        String s0 = a[0];
        String s = a[1];
        String s1 = a[2];
        final SimpleMessage message = new SimpleMessage(Lang.getPrefix() + s0, (JavaPlugin)TradeSystem.getInstance());
        message.add(new ChatButton(s, Lang.get("Want_To_Trade_Hover", p, new Lang.P[0])){

            @Override
            public void onClick(Player player) {
                p.performCommand("trade toggle");
                message.destroy();
            }
        }.setType("TRADE_TOGGLE"));
        message.setTimeOut(10);
        message.add(new TextComponent(s1));
        message.send(p);
    }
}

