/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.managers;

import de.codingair.tradesystem.lib.codingapi.player.chat.SimpleMessage;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.proxy.packets.TradeInvitePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeRequestEvent;
import de.codingair.tradesystem.spigot.trade.managers.InvitationManager;
import de.codingair.tradesystem.spigot.trade.managers.RuleManager;
import de.codingair.tradesystem.spigot.utils.FloodgateUtils;
import de.codingair.tradesystem.spigot.utils.Lang;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class RequestManager {
    public static void request(@NotNull Player sender, @NotNull String receiver) {
        boolean proxy;
        Player other = Bukkit.getPlayerExact((String)receiver);
        boolean bl = proxy = other == null && TradeSystem.proxy().isOnline(receiver);
        if (proxy) {
            if (RuleManager.isViolatingRules(sender)) {
                return;
            }
            String invited = TradeSystem.proxy().getCaseSensitive(receiver);
            TradeRequestEvent event = new TradeRequestEvent(sender, receiver, TradeSystem.proxy().getUniqueId(receiver), TradeSystem.handler().getRequestExpirationTime());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (InvitationManager.processInvitation(sender, null, invited)) {
                return;
            }
            RequestManager.sendRequest(sender, invited);
        } else {
            RequestManager.request(sender, other, receiver);
        }
    }

    private static void sendRequest(@NotNull Player sender, @NotNull String invited) {
        TradeSystem.proxyHandler().send(new TradeInvitePacket(sender.getName(), sender.getUniqueId(), invited, TradeSystem.proxy().getTradeHash(), sender.getWorld().getName()), sender).whenComplete((result, t) -> {
            if (t != null) {
                throw new RuntimeException((Throwable)t);
            }
            RuleManager.handle(sender, invited, result);
        });
    }

    public static void request(@NotNull Player sender, @Nullable Player other, String otherName) {
        if (other != null && !other.isOnline()) {
            return;
        }
        if (RuleManager.isViolatingRules(sender, other, otherName)) {
            return;
        }
        assert (other != null);
        TradeRequestEvent event = new TradeRequestEvent(sender, other, TradeSystem.handler().getRequestExpirationTime());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        RequestManager.requestFinalTrade(sender, other);
    }

    private static void requestFinalTrade(@NotNull Player player, @NotNull Player recipient) {
        if (InvitationManager.processInvitation(player, recipient, recipient.getName())) {
            return;
        }
        RequestManager.sendRequest(player.getName(), recipient);
    }

    public static void sendRequest(String player, Player recipient) {
        if (FloodgateUtils.isBedrockPlayer(recipient)) {
            Lang.send((CommandSender)recipient, "Want_To_Trade_Bedrock", new Lang.P("player", player));
            return;
        }
        TextComponent base = new TextComponent(TextComponent.fromLegacyText((String)(Lang.getPrefix() + Lang.get("Want_To_Trade", recipient, new Lang.P("player", player)))));
        base.setColor(ChatColor.GRAY);
        String commandTrade = TradeSystem.getInstance().getCommandManager().getTradeAliases()[0];
        String commandAccept = "/" + commandTrade + " " + TradeSystem.getInstance().getCommandManager().getAcceptAliases()[0];
        String commandDeny = "/" + commandTrade + " " + TradeSystem.getInstance().getCommandManager().getDenyAliases()[0];
        SimpleMessage message = new SimpleMessage(recipient, base, (JavaPlugin)TradeSystem.getInstance());
        TextComponent accept = new TextComponent(Lang.get("Want_To_Trade_Accept", recipient, new Lang.P("player", player)));
        accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, commandAccept + " " + player));
        accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(Lang.get("Want_To_Trade_Hover", recipient, new Lang.P[0]))}));
        TextComponent deny = new TextComponent(Lang.get("Want_To_Trade_Deny", recipient, new Lang.P("player", player)));
        deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, commandDeny + " " + player));
        deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(Lang.get("Want_To_Trade_Hover", recipient, new Lang.P[0]))}));
        message.replace("%accept%", accept);
        message.replace("%deny%", deny);
        message.send();
        TradeSystem.getInstance().getTradeManager().playRequestSound(recipient);
    }
}

