/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.managers;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.exceptions.TimeOutException;
import de.codingair.tradesystem.proxy.packets.InviteResponsePacket;
import de.codingair.tradesystem.proxy.packets.TradeInvitePacket;
import de.codingair.tradesystem.proxy.packets.TradeStateUpdatePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeRequestExpireEvent;
import de.codingair.tradesystem.spigot.events.TradeRequestPreResponseEvent;
import de.codingair.tradesystem.spigot.events.TradeRequestResponseEvent;
import de.codingair.tradesystem.spigot.trade.managers.RuleManager;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class InvitationManager {
    private final Map<String, Map<String, Invitation>> invitations = new HashMap<String, Map<String, Invitation>>();
    private int expirationHandler = -1;

    public void startExpirationHandler() {
        long expiration = (long)TradeSystem.handler().getRequestExpirationTime() * 1000L;
        this.expirationHandler = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)TradeSystem.getInstance(), () -> this.invitations.entrySet().removeIf(e -> {
            ((Map)e.getValue()).values().removeIf(inv -> {
                boolean valid = inv.valid(expiration);
                if (valid) {
                    return false;
                }
                this.notifyExpiration((String)e.getKey(), (Invitation)inv);
                return true;
            });
            return ((Map)e.getValue()).isEmpty();
        }), 20L, 10L);
    }

    public void stopExpirationHandler() {
        if (this.expirationHandler == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.expirationHandler);
        this.expirationHandler = -1;
    }

    private void notifyExpiration(@NotNull String nameReceiver, @NotNull Invitation inv) {
        UUID idReceiver;
        UUID idInviter;
        String nameInviter = inv.getName();
        Player inviter = Bukkit.getPlayerExact((String)nameInviter);
        Player receiver = Bukkit.getPlayerExact((String)nameReceiver);
        if (inviter != null) {
            nameInviter = inviter.getName();
            idInviter = inviter.getUniqueId();
        } else {
            nameInviter = TradeSystem.proxy().getCaseSensitive(nameInviter);
            idInviter = TradeSystem.proxy().getUniqueId(nameInviter);
        }
        if (receiver != null) {
            nameReceiver = receiver.getName();
            idReceiver = receiver.getUniqueId();
        } else {
            nameReceiver = TradeSystem.proxy().getCaseSensitive(nameReceiver);
            idReceiver = TradeSystem.proxy().getUniqueId(nameReceiver);
        }
        String nameInviterCase = nameInviter;
        UUID finalIdInviter = idInviter;
        String nameReceiverCase = nameReceiver;
        UUID finalIdReceiver = idReceiver;
        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> {
            TradeRequestExpireEvent event = new TradeRequestExpireEvent(nameInviterCase, finalIdInviter, inviter, nameReceiverCase, finalIdReceiver, receiver);
            Bukkit.getPluginManager().callEvent((Event)event);
        });
        if (inviter != null) {
            Lang.send((CommandSender)inviter, "Your_request_expired", new Lang.P("player", nameReceiverCase));
        }
        if (receiver != null) {
            Lang.send((CommandSender)receiver, "Request_expired", new Lang.P("player", nameInviterCase));
        }
    }

    private static InvitationManager instance() {
        return TradeSystem.invitations();
    }

    public static boolean processInvitation(@NotNull Player inviter, @Nullable Player receiver, @NotNull String receiverName) {
        boolean proxyTrade;
        boolean alreadyRequested;
        boolean invited;
        Map<String, Invitation> map = InvitationManager.instance().getInvitations(inviter.getName());
        boolean bl = invited = map != null && map.remove(receiverName.toLowerCase()) != null;
        if (invited) {
            if (map.isEmpty()) {
                InvitationManager.instance().clear(inviter.getName());
            }
            InvitationManager.acceptInvitation(inviter, receiver, receiverName);
            return true;
        }
        map = InvitationManager.instance().getInvitations(receiverName);
        boolean bl2 = alreadyRequested = map != null && map.containsKey(inviter.getName().toLowerCase());
        if (alreadyRequested) {
            Lang.send((CommandSender)inviter, "\u00a7c", "Trade_Spam", new Lang.P[0]);
            return true;
        }
        boolean bl3 = proxyTrade = receiver == null;
        if (!proxyTrade) {
            InvitationManager.registerInvitation(inviter, inviter.getName(), inviter.getUniqueId(), receiver, receiverName);
            Lang.send((CommandSender)inviter, "Player_Is_Invited", new Lang.P("player", receiverName));
        }
        return false;
    }

    public static void registerInvitation(@Nullable Player inviter, @NotNull String nameInviter, @NotNull UUID idInviter, @Nullable Player receiver, @NotNull String nameReceiver) {
        boolean proxy = inviter == null || receiver == null;
        Invitation invitation = new Invitation(nameInviter, idInviter, proxy);
        InvitationManager.instance().invitations.computeIfAbsent(nameReceiver.toLowerCase(), $ -> new HashMap()).put(nameInviter.toLowerCase(), invitation);
    }

    private static void acceptInvitation(@NotNull Player player, @Nullable Player other, @NotNull String name) {
        Lang.send((CommandSender)player, "Request_Accepted", new Lang.P[0]);
        if (other != null) {
            Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(name, other.getUniqueId(), other, player.getName(), player.getUniqueId(), player, true));
            Lang.send((CommandSender)other, "Request_Was_Accepted", new Lang.P("player", player.getName()));
            TradeSystem.getInstance().getTradeManager().startTrade(other, player);
        } else {
            TradeSystem.proxyHandler().send(new TradeInvitePacket(player.getName(), player.getUniqueId(), name, TradeSystem.proxy().getTradeHash(), player.getWorld().getName()), player).whenComplete((suc, t) -> {
                if (t != null) {
                    throw new RuntimeException((Throwable)t);
                }
                if (suc.getResult() == TradeInvitePacket.Result.START_TRADING) {
                    Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(name, suc.getRecipientId(), null, player.getName(), player.getUniqueId(), player, true)));
                    TradeSystem.getInstance().getTradeManager().startTrade(player, name, suc.getRecipientId(), suc.getWorld(), suc.getServer(), false);
                } else {
                    RuleManager.message(player, name, suc.getResult(), suc.getServerOpt().orElse(null));
                }
            });
        }
    }

    @Nullable
    private Map<String, Invitation> getInvitations(String name) {
        return this.invitations.get(name.toLowerCase());
    }

    @NotNull
    public Set<String> getInvitationNames(@NotNull String name) {
        Map<String, Invitation> map = this.getInvitations(name);
        return map == null ? new HashSet() : map.keySet();
    }

    public void clear(String name) {
        this.invitations.remove(name.toLowerCase());
    }

    public void invalidate(@NotNull Player player, @NotNull Invitation invitation) {
        Map<String, Invitation> l = this.getInvitations(player.getName());
        if (l != null) {
            l.remove(invitation.getName().toLowerCase());
            this.invalidateIfEmpty(player.getName(), l);
        }
    }

    public void invalidate(@NotNull Player inviter, @NotNull String other) {
        Map<String, Invitation> l = this.getInvitations(other);
        if (l != null) {
            l.remove(inviter.getName().toLowerCase());
            this.invalidateIfEmpty(other, l);
        }
    }

    public void clear() {
        this.invitations.clear();
    }

    private void invalidateIfEmpty(@NotNull String name, @Nullable Map<String, Invitation> map) {
        if (map == null) {
            map = this.getInvitations(name);
        }
        if (map != null && map.isEmpty()) {
            this.clear(name);
        }
    }

    public void cancelAll(@NotNull String name) {
        this.clear(name);
        this.invitations.entrySet().removeIf(e -> {
            Map invitations = (Map)e.getValue();
            invitations.remove(name.toLowerCase());
            return invitations.isEmpty();
        });
    }

    private void cancel(@Nullable Player player, @NotNull String sender, @NotNull String receiver) {
        TradeStateUpdatePacket packet = new TradeStateUpdatePacket(sender, receiver, TradeStateUpdatePacket.State.CANCELLED, null);
        TradeSystem.proxyHandler().send(packet, player);
    }

    @Nullable
    private Invitation getInvitationOrMessagePlayer(@NotNull Player player, @Nullable String argument) {
        Map<String, Invitation> invitations = this.getInvitations(player.getName());
        if (invitations == null || invitations.isEmpty()) {
            Lang.send((CommandSender)player, "No_Requests_Found", new Lang.P[0]);
            return null;
        }
        if (argument == null) {
            if (invitations.size() <= 1) {
                return invitations.values().stream().findAny().get();
            }
            Lang.send((CommandSender)player, "Too_many_requests", new Lang.P[0]);
            return null;
        }
        Invitation inv = invitations.get(argument.toLowerCase());
        if (inv == null) {
            Lang.send((CommandSender)player, "No_Request_Found", new Lang.P[0]);
        }
        return inv;
    }

    public void handleInvitation(@NotNull Player sender, @Nullable String argument, boolean accept) {
        Invitation invitation = this.getInvitationOrMessagePlayer(sender, argument);
        if (invitation == null) {
            return;
        }
        TradeRequestPreResponseEvent e = new TradeRequestPreResponseEvent(invitation.getCaseSensitiveName(), invitation.getId(), invitation.getPlayer(), sender.getName(), sender.getUniqueId(), sender, accept);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        if (accept) {
            this.accept(sender, invitation);
        } else {
            this.deny(sender, invitation);
        }
    }

    private void deny(@NotNull Player sender, @NotNull Invitation invitation) {
        Player other = invitation.getPlayer();
        this.invalidate(sender, invitation);
        if (other == null) {
            if (TradeSystem.proxy().isOnline(invitation.getName())) {
                Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(sender.getName(), sender.getUniqueId(), sender, TradeSystem.proxy().getCaseSensitive(invitation.getName()), invitation.getId(), null, false));
                TradeSystem.proxyHandler().send(new InviteResponsePacket(invitation.getName(), sender.getName(), sender.getUniqueId(), sender.getWorld().getName(), false, false).noFuture(), sender);
                Lang.send((CommandSender)sender, "Request_Denied", new Lang.P("player", invitation.getName()));
            } else {
                Lang.send((CommandSender)sender, "Player_Of_Request_Not_Online", new Lang.P[0]);
            }
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(sender.getName(), sender.getUniqueId(), sender, other.getName(), other.getUniqueId(), other, false));
        Lang.send((CommandSender)sender, "Request_Denied", new Lang.P("player", other.getName()));
        Lang.send((CommandSender)other, "Request_Was_Denied", new Lang.P("player", sender.getName()));
    }

    private void accept(@NotNull Player sender, @NotNull Invitation invitation) {
        Player other = invitation.getPlayer();
        if (other == null) {
            if (TradeSystem.proxy().isOnline(invitation.getName())) {
                String name = TradeSystem.proxy().getCaseSensitive(invitation.getName());
                if (RuleManager.isViolatingRules(sender)) {
                    return;
                }
                TradeSystem.proxyHandler().send(new InviteResponsePacket(name, sender.getName(), sender.getUniqueId(), sender.getWorld().getName(), true, false), sender, 1000L).whenComplete((suc, t) -> {
                    if (t != null) {
                        if (t instanceof TimeOutException) {
                            return;
                        }
                        t.printStackTrace();
                    } else if (suc.getResult() == InviteResponsePacket.Result.SUCCESS) {
                        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(sender.getName(), sender.getUniqueId(), sender, name, invitation.getId(), null, true)));
                        this.invalidate(sender, invitation);
                        Lang.send((CommandSender)sender, "Request_Accepted", new Lang.P[0]);
                        TradeSystem.getInstance().getTradeManager().startTrade(sender, name, invitation.getId(), suc.getWorld(), suc.getServer(), false);
                    } else if (suc.getResult() == InviteResponsePacket.Result.NOT_ONLINE) {
                        Lang.send((CommandSender)sender, "Player_Of_Request_Not_Online", new Lang.P[0]);
                    } else if (suc.getResult() == InviteResponsePacket.Result.OTHER_GROUP) {
                        Lang.send((CommandSender)sender, "Player_Of_Request_Not_Online", new Lang.P[0]);
                    }
                });
            } else {
                Lang.send((CommandSender)sender, "Player_Of_Request_Not_Online", new Lang.P[0]);
            }
            return;
        }
        if (RuleManager.isViolatingRules(sender, other, invitation.getName())) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new TradeRequestResponseEvent(sender.getName(), sender.getUniqueId(), sender, other.getName(), other.getUniqueId(), other, true)));
        this.invalidate(sender, invitation);
        Lang.send((CommandSender)sender, "Request_Accepted", new Lang.P[0]);
        Lang.send((CommandSender)other, "Request_Was_Accepted", new Lang.P("player", sender.getName()));
        TradeSystem.getInstance().getTradeManager().startTrade(other, sender);
    }

    public boolean isInvited(@NotNull Player inviter, @NotNull String receiver) {
        Map<String, Invitation> invitations = this.getInvitations(receiver);
        if (invitations == null) {
            return false;
        }
        return invitations.containsKey(inviter.getName().toLowerCase());
    }

    public static class Invitation {
        private final String name;
        private final UUID id;
        private final boolean proxyInvite;
        private final long birth;

        public Invitation(String name, UUID id, boolean proxyInvite) {
            this(name, id, proxyInvite, System.currentTimeMillis());
        }

        public Invitation(String name, UUID id, boolean proxyInvite, long birth) {
            this.name = name;
            this.id = id;
            this.proxyInvite = proxyInvite;
            this.birth = birth;
        }

        public String getName() {
            return this.name;
        }

        public UUID getId() {
            return this.id;
        }

        @Nullable
        public Player getPlayer() {
            return Bukkit.getPlayerExact((String)this.name);
        }

        @NotNull
        public String getCaseSensitiveName() {
            Player player = this.getPlayer();
            if (player != null) {
                return player.getName();
            }
            return TradeSystem.proxy().getCaseSensitive(this.name);
        }

        public boolean isProxyInvite() {
            return this.proxyInvite;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof String) && this.getClass() != o.getClass()) {
                return false;
            }
            if (o instanceof String) {
                String invite = (String)o;
                return this.name.equalsIgnoreCase(invite);
            }
            Invitation invitation = (Invitation)o;
            return this.name.equalsIgnoreCase(invitation.getName());
        }

        public int hashCode() {
            return Objects.hash(this.name.toLowerCase());
        }

        public boolean valid(long expirationTime) {
            return System.currentTimeMillis() - this.birth < expirationTime;
        }
    }
}

