/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.managers;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;

public class CommandManager {
    private final ConfigFile configFile;

    public CommandManager(ConfigFile configFile) {
        this.configFile = configFile;
    }

    @NotNull
    public String[] getTradeAliases() {
        return this.getAliases("Trade");
    }

    @NotNull
    public String[] getAcceptAliases() {
        return this.getAliases("Accept");
    }

    @NotNull
    public String[] getDenyAliases() {
        return this.getAliases("Deny");
    }

    @NotNull
    public String[] getToggleAliases() {
        return this.getAliases("Toggle");
    }

    @NotNull
    private String[] getAliases(String configTag) {
        ArrayList<String> aliases = new ArrayList<String>();
        String path = "TradeSystem.Commands." + configTag;
        List l = this.configFile.getConfig().getList(path);
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof String)) continue;
                aliases.add((String)o);
            }
        }
        if (aliases.isEmpty()) {
            String def = configTag.toLowerCase();
            aliases.add(def);
            this.configFile.getConfig().set(path, aliases);
            this.configFile.saveConfig();
        }
        return aliases.toArray(new String[0]);
    }
}

