/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.listeners;

import de.codingair.tradesystem.lib.codingapi.player.chat.ChatButtonListener;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.trade.managers.RequestManager;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class TradeListener
implements Listener,
ChatButtonListener {
    private static final long BUFFER_TIME = 1000L;
    private static final long BUFFER_TIME_OFFLINE = 600000L;
    private final Map<String, Long> invitationBuffer = new HashMap<String, Long>();

    @Override
    public boolean onAsyncClick(Player player, UUID id, String type) {
        if (type != null && type.equals("TRADE_TOGGLE")) {
            player.performCommand("trade toggle");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        TradeSystem.handler().quit(e.getPlayer());
    }

    private boolean isBuffered(@NotNull Player player) {
        return this.isBuffered(player, 1000L);
    }

    private boolean isBuffered(@NotNull Player player, long bufferTime) {
        long time = System.currentTimeMillis();
        Long last = this.invitationBuffer.get(player.getName());
        return last != null && time - last <= bufferTime;
    }

    private void applyBuffer(@NotNull Player player) {
        this.invitationBuffer.put(player.getName(), System.currentTimeMillis());
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        if (!TradeSystem.getInstance().getTradeManager().isRequestOnShiftRightClick() || !e.getPlayer().isSneaking()) {
            return;
        }
        if (e.getRightClicked() instanceof Player) {
            if (this.isBuffered(e.getPlayer())) {
                return;
            }
            Player p = e.getPlayer();
            Player other = (Player)e.getRightClicked();
            if (!other.isOnline()) {
                return;
            }
            if (!p.canSee(other)) {
                return;
            }
            if (TradeSystem.handler().isOffline(p) && this.isBuffered(e.getPlayer(), 600000L)) {
                return;
            }
            RequestManager.request(p, other, other.getName());
            this.applyBuffer(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDeath(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            Player player = (Player)e.getEntity();
            Trade trade = TradeSystem.getInstance().getTradeManager().getTrade(player);
            if (trade != null) {
                double finalDamage = e.getFinalDamage();
                if (TradeSystem.getInstance().getTradeManager().isCancelOnDamage() && finalDamage > 0.0 || player.getHealth() - e.getFinalDamage() <= 0.0) {
                    trade.cancel(Lang.getPrefix() + Lang.get("Trade_cancelled_by_attack", player, new Lang.P[0]));
                }
            }
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent e) {
        Player p = e.getPlayer();
        Trade t = TradeSystem.handler().getTrade(p);
        if (t != null) {
            Perspective perspective = t.getPerspective(p);
            if (!TradeSystem.handler().isDropItems() && t.doesNotFit(perspective, e.getItem().getItemStack())) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Trade trade = TradeSystem.handler().getTrade(player);
        if (trade == null) {
            return;
        }
        event.setCancelled(true);
    }
}

