/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.listeners;

import de.codingair.tradesystem.lib.codingapi.player.data.GameProfileUtils;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.proxy.packets.PublishSkinPacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PublishSkinListener
implements Listener {
    public PublishSkinListener() {
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> Bukkit.getOnlinePlayers().forEach(PublishSkinListener::sync), 5L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        PublishSkinListener.sync(e.getPlayer());
    }

    private static void sync(@NotNull Player player) {
        PublishSkinListener.sync(player, 0);
    }

    private static void sync(@NotNull Player player, int tryCount) {
        if (tryCount >= 2) {
            return;
        }
        try {
            String skin = GameProfileUtils.extractSkinId(GameProfileUtils.getGameProfile(player));
            if (skin != null) {
                TradeSystem.proxyHandler().send(new PublishSkinPacket(player.getName(), skin), player);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> PublishSkinListener.sync(player, tryCount + 1), 2L);
    }
}

