/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.utils;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;

public enum Perspective {
    PRIMARY(0),
    SECONDARY(1),
    TERTIARY(-1);

    private final int id;

    private Perspective(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    @NotNull
    public Perspective flip() {
        return this == PRIMARY ? SECONDARY : PRIMARY;
    }

    public boolean isPrimary() {
        return this == PRIMARY;
    }

    public boolean isSecondary() {
        return this == SECONDARY;
    }

    public boolean isTertiary() {
        return this == TERTIARY;
    }

    public boolean isMain() {
        return this.isPrimary() || this.isSecondary();
    }

    @NotNull
    public static Perspective[] main() {
        return new Perspective[]{PRIMARY, SECONDARY};
    }
}

