/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.utils;

import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.CancelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.DecorationIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.ShowStatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.StatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlotOther;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ExpPointIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ShowExpPointIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.IconData;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ImportHelper {
    @NotNull
    public static Pattern convert(@NotNull String data) throws ParseException {
        JSONObject json = (JSONObject)new JSONParser().parse(data);
        String name = (String)json.get((Object)"Name");
        IconData[] items = new IconData[54];
        JSONArray jsonA = (JSONArray)new JSONParser().parse((String)json.get((Object)"Items"));
        for (Object o : jsonA) {
            String s = (String)o;
            ImportHelper.convertIcon(s, items);
        }
        return new Pattern(name, items);
    }

    private static void convertIcon(@NotNull String data, IconData[] items) throws ParseException {
        JSONObject json = (JSONObject)new JSONParser().parse(data);
        int slot = Integer.parseInt("" + json.get((Object)"Slot"));
        ItemStack item = json.get((Object)"Item") == null ? null : ItemBuilder.getFromJSON((String)json.get((Object)"Item")).getItem();
        Class<? extends TradeIcon> icon = ImportHelper.convertFunction((String)json.get((Object)"Function"));
        if (icon == null) {
            return;
        }
        if (item != null && item.getType() == Material.AIR) {
            item = null;
        }
        if (icon.equals(StatusIcon.CannotReadyIcon.class)) {
            if (items[slot] == null) {
                items[slot] = new IconData(StatusIcon.class, item, null, null);
            } else {
                items[slot].getItems()[0] = item;
            }
        } else if (icon.equals(StatusIcon.NotReadyIcon.class)) {
            if (items[slot] == null) {
                items[slot] = new IconData(StatusIcon.class, null, item, null);
            } else {
                items[slot].getItems()[1] = item;
            }
        } else if (icon.equals(StatusIcon.ReadyIcon.class)) {
            if (items[slot] == null) {
                items[slot] = new IconData(StatusIcon.class, null, null, item);
            } else {
                items[slot].getItems()[2] = item;
            }
        } else if (icon.equals(ShowStatusIcon.ShowNotReadyIcon.class)) {
            if (items[slot] == null) {
                items[slot] = new IconData(ShowStatusIcon.class, item, null);
            } else {
                items[slot].getItems()[0] = item;
            }
        } else if (icon.equals(ShowStatusIcon.ShowReadyIcon.class)) {
            if (items[slot] == null) {
                items[slot] = new IconData(ShowStatusIcon.class, null, item);
            } else {
                items[slot].getItems()[1] = item;
            }
        } else {
            items[slot] = item != null ? new IconData(icon, item) : new IconData(icon, new ItemStack[0]);
        }
    }

    @Nullable
    private static Class<? extends TradeIcon> convertFunction(@NotNull String function) {
        boolean usingMoney = TradeSystem.getInstance().getOldConfig().getBoolean("TradeSystem.Trade_with_money", true);
        switch (function.toUpperCase()) {
            case "DECORATION": {
                return DecorationIcon.class;
            }
            case "MONEY_REPLACEMENT": {
                if (usingMoney) {
                    return null;
                }
                return DecorationIcon.class;
            }
            case "PICK_MONEY": {
                if (usingMoney) {
                    return ExpPointIcon.class;
                }
                return null;
            }
            case "SHOW_MONEY": {
                if (usingMoney) {
                    return ShowExpPointIcon.class;
                }
                return null;
            }
            case "PICK_STATUS_NONE": {
                return StatusIcon.CannotReadyIcon.class;
            }
            case "PICK_STATUS_NOT_READY": {
                return StatusIcon.NotReadyIcon.class;
            }
            case "PICK_STATUS_READY": {
                return StatusIcon.ReadyIcon.class;
            }
            case "SHOW_STATUS_NOT_READY": {
                return ShowStatusIcon.ShowNotReadyIcon.class;
            }
            case "SHOW_STATUS_READY": {
                return ShowStatusIcon.ShowReadyIcon.class;
            }
            case "CANCEL": {
                return CancelIcon.class;
            }
            case "EMPTY_FIRST_TRADER": {
                return TradeSlot.class;
            }
            case "EMPTY_SECOND_TRADER": {
                return TradeSlotOther.class;
            }
        }
        throw new IllegalStateException("Cannot convert old function '" + function + "' into a TradeIcon.");
    }
}

