/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.utils;

import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.IconNotFoundException;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.MultiTradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;

public class IconData
implements Serializable {
    private Class<? extends TradeIcon> tradeIcon;
    private ItemStack[] items;

    public IconData(@NotNull Class<? extends TradeIcon> tradeIcon, ItemStack ... items) {
        this.tradeIcon = tradeIcon;
        this.items = (ItemStack[])Arrays.stream(items).map(ItemStack::clone).toArray(ItemStack[]::new);
    }

    public IconData() {
    }

    @Override
    public boolean read(DataMask mask) throws IconNotFoundException {
        String name = mask.getString("icon");
        this.tradeIcon = IconHandler.getIcon(name);
        JSONArray items = mask.getList("items");
        if (items != null) {
            this.items = items.toArray(new ItemStack[0]);
        }
        return true;
    }

    @Override
    public void write(DataMask mask) {
        mask.put("icon", this.tradeIcon.getSimpleName());
        if (this.items != null) {
            mask.put("items", Arrays.asList(this.items));
        }
    }

    public TradeIcon build() {
        try {
            if (MultiTradeIcon.class.isAssignableFrom(this.tradeIcon)) {
                return this.tradeIcon.getConstructor(ItemStack[].class).newInstance(new Object[]{this.items});
            }
            if (TradeSlot.class.isAssignableFrom(this.tradeIcon)) {
                return this.tradeIcon.newInstance();
            }
            return this.tradeIcon.getConstructor(ItemStack.class).newInstance(this.items[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("The TradeIcon " + this.tradeIcon.getName() + " could not be initiated.", e);
        }
    }

    public Class<? extends TradeIcon> getTradeIcon() {
        return this.tradeIcon;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IconData iconData = (IconData)o;
        return Objects.equals(this.tradeIcon, iconData.tradeIcon) && Arrays.equals(this.items, iconData.items);
    }

    public int hashCode() {
        if (this.tradeIcon == null) {
            return 0;
        }
        return this.tradeIcon.getName().hashCode();
    }
}

