/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.utils;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.TriFunction;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.entity.Player;

public class IconState {
    private boolean disabled = false;
    private TriFunction<Trade, Perspective, Player, String> onClickMessage = null;

    private void sendMessage(@NotNull Player player, @Nullable String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(Lang.getPrefix() + message);
    }

    public boolean checkState(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        if (this.disabled) {
            if (this.onClickMessage != null) {
                this.sendMessage(viewer, this.onClickMessage.apply(trade, perspective, viewer));
            }
            return false;
        }
        return true;
    }

    public void enable() {
        this.disabled = false;
        this.onClickMessage = null;
    }

    public void disable(@Nullable TriFunction<Trade, Perspective, Player, String> onClickMessage) {
        this.disabled = true;
        this.onClickMessage = onClickMessage;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

