/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.ShowEconomyIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ExpLevelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.math.BigDecimal;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShowExpLevelIcon
extends ShowEconomyIcon {
    public ShowExpLevelIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "Levels");
    }

    @Override
    @NotNull
    protected String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal value) {
        ExpLevelIcon ownOffer = (ExpLevelIcon)trade.getLayout()[perspective.id()].getIcon(this.getOriginClass());
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            throw new NullPointerException("Player is null!");
        }
        if (value != null) {
            double current = ExpLevelIcon.getTotalExp((float)player.getLevel() + player.getExp());
            double offered = ownOffer.getValue().doubleValue();
            value = ExpLevelIcon.expToLevel(current - offered, value);
        }
        return super.makeString(trade, perspective, viewer, value);
    }

    @Override
    @NotNull
    public Class<? extends TradeIcon> getOriginClass() {
        return ExpLevelIcon.class;
    }
}

