/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.extras.external.EconomySupportType;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ShowExpLevelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.math.BigDecimal;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ExpLevelIcon
extends EconomyIcon<ShowExpLevelIcon> {
    public ExpLevelIcon(@NotNull ItemStack itemStack) {
        super(itemStack, "Level", "Levels", true);
    }

    @Override
    public Class<ShowExpLevelIcon> getTargetClass() {
        return ShowExpLevelIcon.class;
    }

    @Override
    @NotNull
    protected BigDecimal getBalance(@NotNull Player player) {
        double totalExp = ExpLevelIcon.getTotalExp((float)player.getLevel() + player.getExp());
        return BigDecimal.valueOf(totalExp);
    }

    @Override
    protected void withdraw(Player player, @NotNull BigDecimal value) {
        player.giveExp(-value.intValue());
    }

    @Override
    protected void deposit(Player player, @NotNull BigDecimal value) {
        player.giveExp(value.intValue());
    }

    @Override
    @NotNull
    protected TypeCap getMaxSupportedValue() {
        return EconomySupportType.DOUBLE;
    }

    @Override
    public IconResult processInput(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal input, @NotNull String origin) {
        if (input != null) {
            input = ExpLevelIcon.levelToExp(viewer, input);
        }
        return super.processInput(trade, perspective, viewer, input, origin);
    }

    @Override
    @NotNull
    public String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal current, boolean payment) {
        if (current != null) {
            double currentExp;
            boolean negate;
            double totalExp = ExpLevelIcon.getTotalExp((float)viewer.getLevel() + viewer.getExp());
            boolean bl = negate = current.signum() < 0;
            if (payment) {
                if (negate) {
                    current = current.negate();
                }
                currentExp = totalExp - current.doubleValue();
            } else {
                currentExp = totalExp;
            }
            current = ExpLevelIcon.expToLevel(currentExp, current);
            if (negate) {
                current = current.negate();
            }
        }
        return super.makeString(trade, perspective, viewer, current, payment);
    }

    static double getTotalExp(double level) {
        boolean negative = level < 0.0;
        double out = (level = Math.abs(level)) < 17.0 ? Math.pow(level, 2.0) + 6.0 * level : (level < 32.0 ? 2.5 * Math.pow(level, 2.0) - 40.5 * level + 360.0 : 4.5 * Math.pow(level, 2.0) - 162.5 * level + 2220.0);
        if (negative) {
            out = -out;
        }
        return out;
    }

    private static double getTotalLevel(double exp) {
        boolean negative = exp < 0.0;
        double out = (exp = Math.abs(exp)) < 353.0 ? Math.sqrt(exp + 9.0) - 3.0 : (exp < 1508.0 ? 8.1 + Math.sqrt(0.4 * (exp - 195.975)) : 18.055555555555557 + Math.sqrt(0.2222222222222222 * (exp - 752.9861111111111)));
        if (negative) {
            out = -out;
        }
        return out;
    }

    @NotNull
    private static BigDecimal levelToExp(@NotNull Player player, @NotNull BigDecimal input) {
        double currentExp = ExpLevelIcon.getTotalExp((float)player.getLevel() + player.getExp());
        double targetExp = ExpLevelIcon.getTotalExp((double)((float)player.getLevel() + player.getExp()) - input.doubleValue());
        double diff = currentExp - targetExp;
        return BigDecimal.valueOf(diff);
    }

    @NotNull
    static BigDecimal expToLevel(double currentExp, @NotNull BigDecimal current) {
        double targetExp = currentExp + current.doubleValue();
        double targetLevel = ExpLevelIcon.getTotalLevel(targetExp) - ExpLevelIcon.getTotalLevel(currentExp);
        return BigDecimal.valueOf(targetLevel);
    }
}

