/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy;

import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.SimpleShowIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.math.BigDecimal;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ShowEconomyIcon
extends SimpleShowIcon<BigDecimal>
implements Transition.Consumer<BigDecimal> {
    private final String namePlural;
    private BigDecimal value = BigDecimal.ZERO;

    public ShowEconomyIcon(@NotNull ItemStack itemStack, @NotNull String namePlural) {
        super(itemStack);
        this.namePlural = namePlural;
    }

    @Override
    @NotNull
    public ItemBuilder prepareItemStack(@NotNull ItemBuilder layout, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        layout.setName("\u00a7e" + this.getName(viewer) + ": \u00a77" + this.makeString(trade, perspective, viewer, this.value));
        if (this.value.signum() > 0) {
            layout.addEnchantment(Enchantment.DAMAGE_ALL, 1).setHideEnchantments(true);
        }
        return layout;
    }

    @NotNull
    protected String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal value) {
        return EconomyIcon.makeFancyString(value, true);
    }

    @NotNull
    private String getName(@NotNull Player player) {
        try {
            return Lang.get(this.namePlural, player, new Lang.P[0]);
        }
        catch (NullPointerException ex) {
            return this.namePlural;
        }
    }

    @Override
    public void applyTransition(@NotNull BigDecimal value) {
        this.value = value;
    }

    @Override
    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }
}

