/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy;

import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeReceiveEconomyEvent;
import de.codingair.tradesystem.spigot.extras.external.TypeCap;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.InputIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.FinishResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParsePosition;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class EconomyIcon<T extends Transition.Consumer<BigDecimal> & TradeIcon>
extends InputIcon<BigDecimal>
implements Transition<T, BigDecimal> {
    private final String nameSingular;
    private final String namePlural;
    private final boolean decimal;
    private BigDecimal value = BigDecimal.ZERO;

    public EconomyIcon(@NotNull ItemStack itemStack, @NotNull String nameSingular, @NotNull String namePlural, boolean decimal) {
        super(itemStack);
        this.nameSingular = nameSingular;
        this.namePlural = namePlural;
        this.decimal = decimal;
    }

    @Override
    public boolean isClickable(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            return false;
        }
        if (this.getBalance(player).signum() <= 0) {
            Lang.send((CommandSender)player, "Balance_limit_reached", new Lang.P[0]);
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public BigDecimal convertInput(@NotNull String input) {
        if (input.isEmpty()) {
            return null;
        }
        Number n = TradeSystem.handler().getMoneyPattern().parse(input, new ParsePosition(0));
        if (n == null) {
            return null;
        }
        if (!(n instanceof BigDecimal)) {
            return null;
        }
        BigDecimal value = (BigDecimal)n;
        BigDecimal factor = TradeSystem.handler().getMoneyShortcutFactor(input);
        if (factor != null) {
            value = value.multiply(factor);
        }
        return value;
    }

    @Override
    public IconResult processInput(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal input, @NotNull String origin) {
        boolean isDecimal;
        if (input == null || input.signum() == -1) {
            Lang.send((CommandSender)viewer, "Enter_Correct_Amount", new Lang.P[0]);
            return IconResult.GUI;
        }
        input = this.getMaxSupportedValue().apply(input);
        boolean bl = isDecimal = input.remainder(BigDecimal.ONE).signum() != 0;
        if (!this.decimal && isDecimal) {
            Lang.send((CommandSender)viewer, "Enter_Correct_Amount", new Lang.P[0]);
            return IconResult.GUI;
        }
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            throw new NullPointerException("Player with perspective " + (Object)((Object)perspective) + " is null");
        }
        BigDecimal max = this.getBalance(player);
        if (input.compareTo(max) > 0) {
            Lang.send((CommandSender)viewer, "Only_X_Amount", new Lang.P("amount", this.makeString(trade, perspective, viewer, max, true)), new Lang.P("type", this.getName(viewer, max.equals(BigDecimal.ONE))));
            return IconResult.GUI;
        }
        this.value = this.checkLimit(trade, perspective, input);
        return IconResult.UPDATE;
    }

    @Override
    @NotNull
    public String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable BigDecimal current, boolean payment) {
        return EconomyIcon.makeFancyString(current, this.decimal);
    }

    @NotNull
    static String makeFancyString(@Nullable BigDecimal current, boolean decimal) {
        if (current == null) {
            return "";
        }
        Map.Entry<String, BigDecimal> shortcut = TradeSystem.handler().getApplicableMoneyShortcut(current);
        String appendix = "";
        if (shortcut != null) {
            current = current.divide(shortcut.getValue(), current.precision(), RoundingMode.FLOOR);
            appendix = shortcut.getKey().toUpperCase();
        }
        Number number = current;
        if (!decimal) {
            number = ((Number)number).intValue();
        }
        return TradeSystem.handler().getMoneyPattern().format(number) + appendix;
    }

    @Override
    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public BigDecimal getDefault() {
        return BigDecimal.ZERO;
    }

    @Override
    @NotNull
    public ItemBuilder prepareItemStack(@NotNull ItemBuilder layout, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            throw new NullPointerException("Player with perspective " + (Object)((Object)perspective) + " is null");
        }
        layout.setName("\u00a7e" + this.getName(player, false) + ": \u00a77" + this.makeString(trade, perspective, player, this.value, true));
        layout.addLore("", "\u00a77\u00bb " + Lang.get("Click_To_Change", viewer, new Lang.P[0]));
        if (this.value.signum() > 0) {
            layout.addEnchantment(Enchantment.DAMAGE_ALL, 1).setHideEnchantments(true);
        }
        return layout;
    }

    @NotNull
    public String getName(@NotNull Player player, boolean singular) {
        try {
            return Lang.get(singular ? this.nameSingular : this.namePlural, player, new Lang.P[0]);
        }
        catch (NullPointerException ex) {
            return singular ? this.nameSingular : this.namePlural;
        }
    }

    @Override
    @NotNull
    public FinishResult tryFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
        if (this.value.signum() > 0 && this.getBalance(trade, perspective).compareTo(this.value) < 0) {
            return FinishResult.ERROR_ECONOMY;
        }
        return FinishResult.PASS;
    }

    @Override
    public void onFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
        BigDecimal diff;
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            throw new NullPointerException("Player with perspective " + (Object)((Object)perspective) + " is null");
        }
        int sign = (diff = this.getOverallDifference(trade, perspective)).signum();
        String fancyDiff = this.makeString(trade, perspective, viewer, diff, sign < 0);
        if (sign < 0) {
            this.withdraw(player, diff.negate());
            this.log(trade, TradeLog.OFFERED_AMOUNT, trade.getNames()[perspective.id()], this.namePlural, fancyDiff);
        } else if (sign > 0) {
            this.deposit(player, diff);
            Player other = trade.getPlayer(perspective.flip());
            TradeReceiveEconomyEvent e = other != null ? new TradeReceiveEconomyEvent(player, other, diff, this.nameSingular, this.namePlural) : new TradeReceiveEconomyEvent(player, trade.getNames()[perspective.flip().id()], trade.getUniqueId(perspective.flip()), diff, this.nameSingular, this.namePlural);
            Bukkit.getPluginManager().callEvent((Event)e);
            this.log(trade, TradeLog.RECEIVED_AMOUNT, player.getName(), this.namePlural, fancyDiff);
        }
    }

    @NotNull
    public BigDecimal getOverallDifference(@NotNull Trade trade, @NotNull Perspective perspective) {
        Transition.Consumer show = (Transition.Consumer)trade.getLayout()[perspective.id()].getIcon(this.getTargetClass());
        return ((BigDecimal)show.getValue()).subtract(this.value);
    }

    @NotNull
    private BigDecimal checkLimit(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull BigDecimal value) {
        Player other = trade.getPlayer(perspective.flip());
        if (other == null) {
            return value;
        }
        return this.getBalanceLimit(other).map(limit -> {
            BigDecimal balance = this.getBalance(other);
            if (balance.add(value).compareTo((BigDecimal)limit) > 0) {
                return limit.subtract(balance).max(BigDecimal.ZERO);
            }
            return value;
        }).orElse(value);
    }

    @NotNull
    protected Optional<BigDecimal> getBalanceLimit(@NotNull Player player) {
        return Optional.empty();
    }

    @NotNull
    protected BigDecimal getBalance(@NotNull Trade trade, @NotNull Perspective perspective) {
        Player player = trade.getPlayer(perspective);
        if (player == null) {
            throw new NullPointerException("Player with perspective " + (Object)((Object)perspective) + " is null");
        }
        return this.getBalance(player);
    }

    @NotNull
    protected abstract BigDecimal getBalance(@NotNull Player var1);

    protected abstract void withdraw(Player var1, @NotNull BigDecimal var2);

    protected abstract void deposit(Player var1, @NotNull BigDecimal var2);

    @NotNull
    protected abstract TypeCap getMaxSupportedValue();

    @Override
    public boolean isEmpty() {
        return this.value.signum() == 0;
    }

    @Override
    public void serialize(@NotNull DataOutputStream out) throws IOException {
        out.writeUTF(this.value.toString());
    }

    @Override
    public void deserialize(@NotNull DataInputStream in) throws IOException {
        this.value = new BigDecimal(in.readUTF());
    }

    @Override
    public void inform(@NotNull T icon) {
        icon.applyTransition((BigDecimal)this.value);
    }

    public boolean isDecimal() {
        return this.decimal;
    }
}

