/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.SignButton;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Clickable;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Input;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.ItemPrepareIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.LayoutIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.StateHolder;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.IconState;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.TriFunction;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class SignGUIIcon<G>
extends LayoutIcon
implements TradeIcon,
Clickable,
StateHolder,
Input<G>,
ItemPrepareIcon {
    private final IconState state = new IconState();

    public SignGUIIcon(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    @NotNull
    public final Button getButton(final @NotNull Trade trade, final @NotNull Perspective perspective, final @NotNull Player viewer) {
        Object[] test = this.buildSignLines(trade, perspective, viewer);
        if (test != null && test.length > 4) {
            throw new IllegalStateException("Cannot open a SignGUI with more than 4 lines! Note that the first line will be used for the player input. Lines: " + Arrays.toString(test));
        }
        final Perspective viewPerspective = trade.getPerspective(viewer);
        return new SignButton(() -> {
            String[] text = this.buildSignLines(trade, perspective, viewer);
            if (text == null || text.length < 4) {
                return new String[0];
            }
            return text;
        }){

            @Override
            public boolean onSignChangeEvent(GUI gui, String[] input) {
                if (trade.isCancelling()) {
                    return true;
                }
                String origin = input[0];
                Object in = SignGUIIcon.this.convertInput(origin);
                IconResult result = SignGUIIcon.this.processInput(trade, perspective, viewer, in, origin);
                if (result == IconResult.GUI) {
                    return false;
                }
                SignGUIIcon.this.handleResult(SignGUIIcon.this, gui, result, trade, perspective, viewPerspective);
                return true;
            }

            @Override
            public ItemStack buildItem() {
                return SignGUIIcon.this.prepareItemStack(new ItemBuilder(SignGUIIcon.this.getItemStack()), trade, perspective, viewer).getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                return SignGUIIcon.this.state.checkState(trade, perspective, viewer) && SignGUIIcon.this.isClickable(trade, perspective, viewer);
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                trade.acknowledgeGuiSwitch(viewer);
            }

            @Override
            public boolean canSwitch(ClickType clickType) {
                return true;
            }
        };
    }

    protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
        trade.handleClickResult(icon, perspective, viewer, gui, result);
    }

    @Nullable
    public abstract String[] buildSignLines(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3);

    @Override
    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    @Override
    public void enable() {
        this.state.enable();
    }

    @Override
    public void disable(@Nullable TriFunction<Trade, Perspective, Player, String> onClickMessage) {
        this.state.disable(onClickMessage);
    }
}

