/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.GUISwitchButton;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Item;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Clickable;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Input;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.ItemPrepareIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.StateHolder;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.IconState;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.TriFunction;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.FloodgateUtils;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.floodgate.api.FloodgateApi;

public abstract class FloodgateGUIIcon<G>
implements TradeIcon,
Clickable,
StateHolder,
Input<G>,
ItemPrepareIcon {
    private final IconState state = new IconState();
    private final ItemStack item;

    public FloodgateGUIIcon(@NotNull ItemStack itemStack) {
        this.item = itemStack;
    }

    @Override
    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    @Override
    public void enable() {
        this.state.enable();
    }

    @Override
    public void disable(@Nullable TriFunction<Trade, Perspective, Player, String> onClickMessage) {
        this.state.disable(onClickMessage);
    }

    @Override
    @NotNull
    public Button getButton(final @NotNull Trade trade, final @NotNull Perspective perspective, final @NotNull Player viewer) {
        if (!FloodgateUtils.isBedrockPlayer(viewer)) {
            return new Item(this.prepareItemStack(new ItemBuilder(this.item), trade, perspective, viewer).getItem());
        }
        return new FloodgateButton(){

            @Override
            @Nullable
            public ItemStack buildItem() {
                return FloodgateGUIIcon.this.prepareItemStack(new ItemBuilder(FloodgateGUIIcon.this.item), trade, perspective, viewer).getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                return FloodgateGUIIcon.this.state.checkState(trade, perspective, viewer) && FloodgateGUIIcon.this.isClickable(trade, perspective, viewer);
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                trade.acknowledgeGuiSwitch(viewer);
            }

            @Override
            public boolean open(ClickType clickType, GUI gui, Call call) {
                viewer.closeInventory();
                this.open(viewer, trade, perspective, viewer, call, gui);
                return false;
            }
        };
    }

    protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
        trade.handleClickResult(icon, perspective, viewer, gui, result);
    }

    private abstract class FloodgateButton
    extends Button
    implements GUISwitchButton {
        private FloodgateButton() {
        }

        @Override
        public boolean canSwitch(ClickType clickType) {
            return true;
        }

        protected void open(Player player, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, Call call, GUI gui) {
            Perspective viewPerspective = trade.getPerspective(viewer);
            String def = FloodgateGUIIcon.this.isEmpty() ? "" : FloodgateGUIIcon.this.makeString(trade, perspective, viewer, FloodgateGUIIcon.this.getValue(), true);
            FloodgateApi.getInstance().sendForm(player.getUniqueId(), ((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title(Lang.get("GUI_Title", viewer, new Lang.P("player", trade.getNames()[perspective.isPrimary() ? 1 : 0])))).input(Lang.get("Economy_Offer_Title", viewer, new Lang.P[0]), "0", def).validResultHandler(response -> {
                String input = response.asInput();
                if (input == null) {
                    input = "";
                }
                Object processed = FloodgateGUIIcon.this.convertInput(input);
                IconResult result = FloodgateGUIIcon.this.processInput(trade, perspective, viewer, processed, input);
                this.getClickSound().play(viewer);
                if (result == IconResult.GUI) {
                    Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> this.open(player, trade, perspective, viewer, call, gui), 40L);
                } else {
                    FloodgateGUIIcon.this.handleResult(FloodgateGUIIcon.this, gui, result, trade, perspective, viewPerspective);
                    call.proceed();
                }
            })).closedOrInvalidResultHandler(() -> this.open(player, trade, perspective, viewer, call, gui)));
        }
    }
}

