/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilClickEvent;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilSlot;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.AnvilButton;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Clickable;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Input;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.ItemPrepareIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.LayoutIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.StateHolder;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.IconState;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.TriFunction;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AnvilGUIIcon<G>
extends LayoutIcon
implements TradeIcon,
Clickable,
StateHolder,
Input<G>,
ItemPrepareIcon {
    private final IconState state = new IconState();

    public AnvilGUIIcon(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    @NotNull
    public final Button getButton(final @NotNull Trade trade, final @NotNull Perspective perspective, final @NotNull Player viewer) {
        final Perspective viewPerspective = trade.getPerspective(viewer);
        return new AnvilButton(){

            @Override
            public void onAnvil(GUI fallback, AnvilClickEvent e) {
                if (!e.getSlot().equals((Object)AnvilSlot.OUTPUT)) {
                    return;
                }
                String origin = e.getInput(false);
                if (origin == null) {
                    origin = "";
                }
                Object in = AnvilGUIIcon.this.convertInput(origin);
                IconResult result = AnvilGUIIcon.this.processInput(trade, perspective, viewer, in, origin);
                this.getClickSound().play(viewer);
                if (result != IconResult.GUI) {
                    e.setClose(true);
                    AnvilGUIIcon.this.handleResult(AnvilGUIIcon.this, fallback, result, trade, perspective, viewPerspective);
                }
            }

            @Override
            public ItemStack buildAnvilItem() {
                return AnvilGUIIcon.this.buildAnvilItem(trade, perspective, viewer);
            }

            @Override
            public ItemStack buildItem() {
                return AnvilGUIIcon.this.prepareItemStack(new ItemBuilder(AnvilGUIIcon.this.getItemStack()), trade, perspective, viewer).getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                return AnvilGUIIcon.this.state.checkState(trade, perspective, viewer) && AnvilGUIIcon.this.isClickable(trade, perspective, viewer);
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                trade.acknowledgeGuiSwitch(viewer);
            }

            @Override
            public boolean canSwitch(ClickType clickType) {
                return true;
            }
        }.setTitle(Lang.get("Economy_Offer_Title", viewer, new Lang.P[0]));
    }

    protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
        trade.handleClickResult(icon, perspective, viewer, gui, result);
    }

    @NotNull
    public abstract ItemStack buildAnvilItem(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3);

    @Override
    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    @Override
    public void enable() {
        this.state.enable();
    }

    @Override
    public void disable(@Nullable TriFunction<Trade, Perspective, Player, String> onClickMessage) {
        this.state.disable(onClickMessage);
    }
}

