/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogService;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.TradingGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.FinishResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.entity.Player;

public interface TradeIcon {
    @NotNull
    public Button getButton(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3);

    public void onFinish(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3, boolean var4);

    @NotNull
    public FinishResult tryFinish(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3, boolean var4);

    public boolean isEmpty();

    public void serialize(@NotNull DataOutputStream var1) throws IOException;

    public void deserialize(@NotNull DataInputStream var1) throws IOException;

    default public void updateItem(@NotNull Trade trade, @NotNull Perspective perspective) {
        int slot = trade.getLayout()[perspective.id()].getSlotOf(this);
        TradingGUI gui = trade.getGUIs()[perspective.id()];
        Button button = gui.getActive().getButtonAt(slot);
        gui.setItem(slot, button.buildItem());
    }

    default public void updateButton(@NotNull Trade trade, @NotNull Player player) {
        Perspective perspective = trade.getPerspective(player);
        int slot = trade.getLayout()[perspective.id()].getSlotOf(this);
        TradingGUI gui = trade.getGUIs()[perspective.id()];
        Button button = this.getButton(trade, perspective, player);
        gui.getActive().addButton(slot, button);
        gui.setItem(slot, button.buildItem());
    }

    default public void log(@NotNull Trade trade, @NotNull TradeLog.Message message, Object ... vars) {
        if (trade.isInitiationServer()) {
            TradeLogService.log(trade.getNames()[0], trade.getNames()[1], message.get(vars));
        } else {
            TradeLogService.log(trade.getNames()[1], trade.getNames()[0], message.get(vars));
        }
    }
}

