/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.FinishResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import org.bukkit.entity.Player;

public abstract class MultiTradeIcon
implements TradeIcon {
    private final TradeIcon[] icons;

    public MultiTradeIcon(TradeIcon ... icons) {
        this.icons = icons;
    }

    @Override
    @NotNull
    public Button getButton(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        return this.currentTradeIcon(trade, perspective, viewer).getButton(trade, perspective, viewer);
    }

    @Override
    @NotNull
    public FinishResult tryFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
        return this.currentTradeIcon(trade, perspective, viewer).tryFinish(trade, perspective, viewer, initiationServer);
    }

    @Override
    public void onFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
        this.currentTradeIcon(trade, perspective, viewer).onFinish(trade, perspective, viewer, initiationServer);
    }

    @NotNull
    public abstract TradeIcon currentTradeIcon(@NotNull Trade var1, @NotNull Perspective var2, @NotNull Player var3);

    @NotNull
    protected TradeIcon getIcon(Class<? extends TradeIcon> c) {
        for (TradeIcon icon : this.icons) {
            if (!c.isInstance(icon)) continue;
            return icon;
        }
        throw new IllegalStateException("The TradeIcon class " + c.getName() + " was not registered in the MultiTradeIcon " + this.getClass().getName());
    }

    public TradeIcon[] getIcons() {
        return this.icons;
    }
}

