/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.types;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Clickable;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Input;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.ItemPrepareIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.LayoutIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.StateHolder;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.FinishResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.gui.FloodgateGUIIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.gui.SimpleAnvilGUIIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.gui.SimpleSignGUIIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.utils.TriFunction;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.FloodgateUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class InputIcon<G>
extends LayoutIcon
implements TradeIcon,
Clickable,
StateHolder,
Input<G>,
ItemPrepareIcon {
    private final TradeIcon icon;
    private final TradeIcon bedrockIcon;

    public InputIcon(@NotNull ItemStack itemStack) {
        super(itemStack);
        this.bedrockIcon = Bukkit.getPluginManager().isPluginEnabled("floodgate") ? new FloodgateGUIIcon<G>(itemStack){

            @Override
            @NotNull
            public ItemBuilder prepareItemStack(@NotNull ItemBuilder layout, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                return InputIcon.this.prepareItemStack(layout, trade, perspective, viewer);
            }

            @Override
            public boolean isClickable(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                return InputIcon.this.isClickable(trade, perspective, viewer);
            }

            @Override
            public void onFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                InputIcon.this.onFinish(trade, perspective, viewer, initiationServer);
            }

            @Override
            @NotNull
            public FinishResult tryFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                return InputIcon.this.tryFinish(trade, perspective, viewer, initiationServer);
            }

            @Override
            public boolean isEmpty() {
                return InputIcon.this.isEmpty();
            }

            @Override
            public void serialize(@NotNull DataOutputStream out) throws IOException {
                InputIcon.this.serialize(out);
            }

            @Override
            public void deserialize(@NotNull DataInputStream in) throws IOException {
                InputIcon.this.deserialize(in);
            }

            @Override
            @Nullable
            public G convertInput(@NotNull String input) {
                return InputIcon.this.convertInput(input);
            }

            @Override
            public IconResult processInput(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G input, @NotNull String origin) {
                return InputIcon.this.processInput(trade, perspective, viewer, input, origin);
            }

            @Override
            @NotNull
            public String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G current, boolean payment) {
                return InputIcon.this.makeString(trade, perspective, viewer, current, payment);
            }

            @Override
            @Nullable
            public G getValue() {
                return InputIcon.this.getValue();
            }

            @Override
            public void setValue(G value) {
                InputIcon.this.setValue(value);
            }

            @Override
            public G getDefault() {
                return InputIcon.this.getDefault();
            }

            @Override
            protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
                super.handleResult(InputIcon.this, gui, result, trade, perspective, viewer);
            }
        } : null;
        switch (TradeSystem.handler().getInputGUI()) {
            case SIGN: {
                this.icon = new SimpleSignGUIIcon<G>(itemStack){

                    @Override
                    @Nullable
                    public G convertInput(@NotNull String input) {
                        return InputIcon.this.convertInput(input);
                    }

                    @Override
                    public IconResult processInput(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G input, @NotNull String origin) {
                        return InputIcon.this.processInput(trade, perspective, viewer, input, origin);
                    }

                    @Override
                    protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
                        super.handleResult(InputIcon.this, gui, result, trade, perspective, viewer);
                    }

                    @Override
                    @NotNull
                    public String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G current, boolean payment) {
                        return InputIcon.this.makeString(trade, perspective, viewer, current, true);
                    }

                    @Override
                    @Nullable
                    public G getValue() {
                        return InputIcon.this.getValue();
                    }

                    @Override
                    public void setValue(G value) {
                        InputIcon.this.setValue(value);
                    }

                    @Override
                    public G getDefault() {
                        return InputIcon.this.getDefault();
                    }

                    @Override
                    @NotNull
                    public ItemBuilder prepareItemStack(@NotNull ItemBuilder layout, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                        return InputIcon.this.prepareItemStack(layout, trade, perspective, viewer);
                    }

                    @Override
                    public boolean isClickable(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                        return InputIcon.this.isClickable(trade, perspective, viewer);
                    }

                    @Override
                    public void onFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                        InputIcon.this.onFinish(trade, perspective, viewer, initiationServer);
                    }

                    @Override
                    @NotNull
                    public FinishResult tryFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                        return InputIcon.this.tryFinish(trade, perspective, viewer, initiationServer);
                    }

                    @Override
                    public boolean isEmpty() {
                        return InputIcon.this.isEmpty();
                    }

                    @Override
                    public void serialize(@NotNull DataOutputStream out) throws IOException {
                        InputIcon.this.serialize(out);
                    }

                    @Override
                    public void deserialize(@NotNull DataInputStream in) throws IOException {
                        InputIcon.this.deserialize(in);
                    }
                };
                break;
            }
            default: {
                this.icon = new SimpleAnvilGUIIcon<G>(itemStack){

                    @Override
                    @Nullable
                    public G convertInput(@NotNull String input) {
                        return InputIcon.this.convertInput(input);
                    }

                    @Override
                    public IconResult processInput(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G input, @NotNull String origin) {
                        return InputIcon.this.processInput(trade, perspective, viewer, input, origin);
                    }

                    @Override
                    protected void handleResult(@NotNull TradeIcon icon, @NotNull GUI gui, @NotNull IconResult result, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective viewer) {
                        super.handleResult(InputIcon.this, gui, result, trade, perspective, viewer);
                    }

                    @Override
                    @NotNull
                    public String makeString(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, @Nullable G current, boolean payment) {
                        return InputIcon.this.makeString(trade, perspective, viewer, current, true);
                    }

                    @Override
                    @Nullable
                    public G getValue() {
                        return InputIcon.this.getValue();
                    }

                    @Override
                    public void setValue(G value) {
                        InputIcon.this.setValue(value);
                    }

                    @Override
                    public G getDefault() {
                        return InputIcon.this.getDefault();
                    }

                    @Override
                    @NotNull
                    public ItemBuilder prepareItemStack(@NotNull ItemBuilder layout, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                        return InputIcon.this.prepareItemStack(layout, trade, perspective, viewer);
                    }

                    @Override
                    public boolean isClickable(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
                        return InputIcon.this.isClickable(trade, perspective, viewer);
                    }

                    @Override
                    public void onFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                        InputIcon.this.onFinish(trade, perspective, viewer, initiationServer);
                    }

                    @Override
                    @NotNull
                    public FinishResult tryFinish(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer, boolean initiationServer) {
                        return InputIcon.this.tryFinish(trade, perspective, viewer, initiationServer);
                    }

                    @Override
                    public boolean isEmpty() {
                        return InputIcon.this.isEmpty();
                    }

                    @Override
                    public void serialize(@NotNull DataOutputStream out) throws IOException {
                        InputIcon.this.serialize(out);
                    }

                    @Override
                    public void deserialize(@NotNull DataInputStream in) throws IOException {
                        InputIcon.this.deserialize(in);
                    }
                };
            }
        }
    }

    @Override
    @NotNull
    public final Button getButton(@NotNull Trade trade, @NotNull Perspective perspective, @NotNull Player viewer) {
        if (this.bedrockIcon != null && FloodgateUtils.isBedrockPlayer(viewer)) {
            return this.bedrockIcon.getButton(trade, perspective, viewer);
        }
        return this.icon.getButton(trade, perspective, viewer);
    }

    @Override
    public boolean isDisabled() {
        if (!(this.icon instanceof StateHolder)) {
            throw new IllegalStateException("Icon has no state: " + this.icon.getClass());
        }
        return ((StateHolder)((Object)this.icon)).isDisabled();
    }

    @Override
    public void enable() {
        if (!(this.icon instanceof StateHolder)) {
            throw new IllegalStateException("Icon has no state: " + this.icon.getClass());
        }
        ((StateHolder)((Object)this.icon)).enable();
    }

    @Override
    public void disable(@Nullable TriFunction<Trade, Perspective, Player, String> onClickMessage) {
        if (!(this.icon instanceof StateHolder)) {
            throw new IllegalStateException("Icon has no state: " + this.icon.getClass());
        }
        ((StateHolder)((Object)this.icon)).disable(onClickMessage);
    }
}

