/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.shulker;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.layout.shulker.ShulkerPage;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;

public class ShulkerPeekGUI
extends GUI {
    private final Perspective owner;

    public ShulkerPeekGUI(@NotNull Player player, @NotNull ItemStack item, @NotNull Perspective owner) {
        super(player, TradeSystem.getInstance(), 36, Lang.get("Shulker_Box", player, new Lang.P[0]), true);
        this.owner = owner;
        ShulkerBox box = this.getBoxFrom(item);
        if (box != null) {
            super.registerPage(new ShulkerPage(this, box), true);
            return;
        }
        throw new IllegalArgumentException("Not a shulker box!");
    }

    @Nullable
    private ShulkerBox getBoxFrom(@NotNull ItemStack item) {
        BlockStateMeta b;
        if (item.hasItemMeta() && item.getItemMeta() instanceof BlockStateMeta && (b = (BlockStateMeta)item.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            return (ShulkerBox)b.getBlockState();
        }
        return null;
    }

    @NotNull
    public Perspective getOwner() {
        return this.owner;
    }

    public static boolean isShulkerBox(@Nullable ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)item.getItemMeta()).getBlockState() instanceof ShulkerBox;
    }
}

