/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.registration;

import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.EditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconController;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.MultiEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.TransitionTargetEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.Type;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.IconAlreadyRegisteredException;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.IconNotFoundException;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.IncompatibleTypesException;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.NoProperConstructorException;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.RequirementNotFulfilledException;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.TradeIconException;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.MultiTradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.CancelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.DecorationIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.ShowStatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.StatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlotOther;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.cosmetics.OtherPlayerHeadIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.cosmetics.PlayerHeadIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ExpLevelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ExpPointIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ShowExpLevelIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.exp.ShowExpPointIcon;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class IconHandler {
    private static final HashMap<String, Class<? extends TradeIcon>> TRADE_ICONS = new HashMap();
    private static final LinkedHashMap<Class<? extends TradeIcon>, EditorInfo> ICON_DATA = new LinkedHashMap();

    public static void init() {
        TradeSystem.setIconController(new IconController(){

            @Override
            public void registerDefault() {
                IconHandler.registerDefault();
            }

            @Override
            public void clear() {
                TRADE_ICONS.clear();
                ICON_DATA.clear();
            }
        });
    }

    private static void registerDefault() {
        IconHandler.registerBasic();
        IconHandler.registerEconomy();
    }

    public static boolean isRegistered(@NotNull Class<? extends TradeIcon> tradeIcon) {
        return TRADE_ICONS.containsValue(tradeIcon);
    }

    public static void register(@NotNull Class<? extends TradeIcon> tradeIcon, @NotNull TransitionTargetEditorInfo info) throws TradeIconException {
        IconHandler.register(tradeIcon, (EditorInfo)info);
        IconHandler.getInfo(info.getOrigin()).setTransitionTarget(tradeIcon);
    }

    public static void register(@NotNull Class<? extends TradeIcon> tradeIcon, @NotNull EditorInfo info) throws TradeIconException {
        IconHandler.register(tradeIcon, info, false);
    }

    public static void register(@NotNull Class<? extends TradeIcon> tradeIcon, @NotNull EditorInfo data, boolean force) throws TradeIconException {
        if (TRADE_ICONS.containsKey(tradeIcon.getSimpleName())) {
            throw new IconAlreadyRegisteredException(tradeIcon);
        }
        try {
            if (!force) {
                if (!data.matchRequirements()) {
                    throw new RequirementNotFulfilledException(tradeIcon);
                }
                if (MultiTradeIcon.class.isAssignableFrom(tradeIcon)) {
                    if (Transition.class.isAssignableFrom(tradeIcon)) {
                        throw new IncompatibleTypesException(tradeIcon, MultiTradeIcon.class, Transition.class);
                    }
                    tradeIcon.getConstructor(ItemStack[].class);
                } else {
                    try {
                        tradeIcon.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        tradeIcon.getConstructor(ItemStack.class).newInstance(new ItemStack(Material.STONE));
                    }
                }
            }
            TRADE_ICONS.put(tradeIcon.getSimpleName(), tradeIcon);
            data.setTradeIcon(tradeIcon);
            ICON_DATA.put(tradeIcon, data);
        }
        catch (NoSuchMethodException e) {
            throw new NoProperConstructorException(tradeIcon);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new NoProperConstructorException(tradeIcon, (Throwable)e);
        }
    }

    private static void registerBasic() {
        try {
            IconHandler.register(DecorationIcon.class, new EditorInfo("Fill inventory", Type.BASIC, editor -> {
                if (editor.needsMoreDecorationItems()) {
                    return new ItemBuilder(XMaterial.MINECART);
                }
                return new ItemBuilder(XMaterial.CHEST_MINECART);
            }, true, new String[0]));
            IconHandler.register(StatusIcon.class, new MultiEditorInfo("Status icon", Type.BASIC, editor -> new ItemBuilder(XMaterial.LIGHT_GRAY_TERRACOTTA), true, "Cannot ready", "Not ready", "Ready"));
            IconHandler.register(ShowStatusIcon.class, new MultiEditorInfo("Status preview icon", Type.BASIC, editor -> new ItemBuilder(XMaterial.LIME_TERRACOTTA), true, "Not ready", "Ready"));
            IconHandler.register(TradeSlot.class, new EditorInfo("Own trade slots", Type.BASIC, editor -> new ItemBuilder(XMaterial.BLACK_STAINED_GLASS).setAmount(Math.max(1, IconHandler.getAmountOf(TradeSlot.class, editor.getIcons()))), true, new String[0]));
            IconHandler.register(TradeSlotOther.class, new EditorInfo("Foreign trade slots", Type.BASIC, editor -> new ItemBuilder(XMaterial.WHITE_STAINED_GLASS).setAmount(Math.max(1, IconHandler.getAmountOf(TradeSlotOther.class, editor.getIcons()))), true, new String[0]));
            IconHandler.register(CancelIcon.class, new EditorInfo("Cancel icon", Type.BASIC, editor -> new ItemBuilder(XMaterial.BARRIER), false, new String[0]));
        }
        catch (TradeIconException e) {
            e.printStackTrace();
        }
    }

    private static void registerEconomy() {
        try {
            IconHandler.registerExp();
        }
        catch (TradeIconException e) {
            e.printStackTrace();
        }
    }

    private static void registerCosmetics() {
        try {
            IconHandler.register(PlayerHeadIcon.class, new EditorInfo("Trader's head", Type.COSMETICS, editor -> new ItemBuilder(XMaterial.PLAYER_HEAD), false, new String[0]));
            IconHandler.register(OtherPlayerHeadIcon.class, new EditorInfo("Trade partner's head", Type.COSMETICS, editor -> new ItemBuilder(XMaterial.SKELETON_SKULL), false, new String[0]));
        }
        catch (TradeIconException e) {
            e.printStackTrace();
        }
    }

    private static void registerExp() throws TradeIconException {
        IconHandler.register(ExpLevelIcon.class, new EditorInfo("Exp level icon", Type.ECONOMY, editor -> new ItemBuilder(XMaterial.EXPERIENCE_BOTTLE), false, new String[0]));
        IconHandler.register(ShowExpLevelIcon.class, new TransitionTargetEditorInfo("Exp level preview icon", ExpLevelIcon.class));
        IconHandler.register(ExpPointIcon.class, new EditorInfo("Exp point icon", Type.ECONOMY, editor -> new ItemBuilder(XMaterial.EXPERIENCE_BOTTLE), false, new String[0]));
        IconHandler.register(ShowExpPointIcon.class, new TransitionTargetEditorInfo("Exp point preview icon", ExpPointIcon.class));
    }

    @NotNull
    public static EditorInfo getInfo(@NotNull Class<? extends TradeIcon> icon) {
        EditorInfo info = ICON_DATA.get(icon);
        if (info == null) {
            throw new IllegalStateException("IconInfo from " + icon.getName() + " could not be found.");
        }
        return info;
    }

    @NotNull
    public static Class<? extends TradeIcon> getIcon(@NotNull String name) throws IconNotFoundException {
        Class<? extends TradeIcon> icon = TRADE_ICONS.get(name);
        if (icon == null) {
            throw new IconNotFoundException(name);
        }
        return icon;
    }

    @NotNull
    public static Class<? extends TradeIcon> getTransitionTarget(@NotNull Class<? extends TradeIcon> icon) {
        EditorInfo info = IconHandler.getInfo(icon);
        Class<? extends TradeIcon> target = info.getTransitionTarget();
        if (target == null) {
            throw new IllegalStateException("Could not found a transition target for " + icon.getName());
        }
        return target;
    }

    public static boolean isTypeEmpty(@NotNull Type type) {
        for (EditorInfo value : ICON_DATA.values()) {
            if (!type.equals((Object)value.getType())) continue;
            return false;
        }
        return true;
    }

    public static int getAmountOf(@NotNull Class<? extends TradeIcon> icon, @NotNull Map<Integer, Class<? extends TradeIcon>> icons) {
        return (int)icons.values().stream().filter(icon::equals).count();
    }

    @NotNull
    public static List<EditorInfo> getIcons(@NotNull Type type) {
        ArrayList<EditorInfo> icons = new ArrayList<EditorInfo>();
        for (EditorInfo value : ICON_DATA.values()) {
            if (value.nameOnly() || value.getType() != type) continue;
            icons.add(value);
        }
        return icons;
    }

    public static List<EditorInfo> getNecessaryIcons() {
        ArrayList<EditorInfo> icons = new ArrayList<EditorInfo>();
        for (EditorInfo value : ICON_DATA.values()) {
            if (value.getTradeIcon().equals(DecorationIcon.class) || TradeSlot.class.isAssignableFrom(value.getTradeIcon()) || !value.isNecessary()) continue;
            icons.add(value);
        }
        return icons;
    }

    @NotNull
    public static Method findInform(@NotNull Class<? extends TradeIcon> origin, @NotNull Class<? extends TradeIcon> icon) throws NoSuchMethodException {
        try {
            return icon.getMethod("inform", IconHandler.getTransitionTarget(origin));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return icon.getMethod("inform", TradeIcon.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new NoSuchMethodException();
            }
        }
    }
}

