/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout.registration;

import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.gui.editor.Editor;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.Type;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import java.util.function.Function;
import org.bukkit.Bukkit;

public class EditorInfo {
    private final String name;
    private final Type type;
    private final Function<Editor, ItemBuilder> editorIcon;
    private final String[] requiredPlugins;
    private final boolean necessary;
    private Class<? extends TradeIcon> tradeIcon;
    private Class<? extends TradeIcon> transitionTarget;

    public EditorInfo(@NotNull String name, @NotNull Type type, @NotNull Function<Editor, ItemBuilder> editorIconSupplier, boolean necessary, String ... requiredPlugins) {
        this.name = name;
        this.type = type;
        this.editorIcon = editorIconSupplier;
        this.necessary = necessary;
        this.requiredPlugins = requiredPlugins;
    }

    EditorInfo(@NotNull String name) {
        this.name = name;
        this.type = null;
        this.editorIcon = null;
        this.necessary = false;
        this.requiredPlugins = new String[0];
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean nameOnly() {
        return this.type == null && this.editorIcon == null && !this.necessary;
    }

    @NotNull
    public Type getType() {
        if (this.type == null) {
            throw new NullPointerException(this.name + " (" + this.tradeIcon + ") has no type.");
        }
        return this.type;
    }

    @NotNull
    public ItemBuilder getEditorIcon(@NotNull Editor editor) {
        if (this.editorIcon == null) {
            throw new NullPointerException();
        }
        return this.editorIcon.apply(editor);
    }

    @NotNull
    public Class<? extends TradeIcon> getTradeIcon() {
        return this.tradeIcon;
    }

    void setTradeIcon(@NotNull Class<? extends TradeIcon> tradeIcon) {
        this.tradeIcon = tradeIcon;
    }

    public boolean isNecessary() {
        return this.necessary;
    }

    @Nullable
    public Class<? extends TradeIcon> getTransitionTarget() {
        return this.transitionTarget;
    }

    void setTransitionTarget(@NotNull Class<? extends TradeIcon> transitionTarget) {
        this.transitionTarget = transitionTarget;
    }

    @NotNull
    public @NotNull String @NotNull [] getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public boolean matchRequirements() {
        for (String plugin : this.requiredPlugins) {
            if (Bukkit.getPluginManager().isPluginEnabled(plugin)) continue;
            return false;
        }
        return true;
    }
}

