/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;

public class TradeLayout {
    private final Pattern pattern;
    private final TradeIcon[] icons;

    public TradeLayout(@NotNull Pattern pattern, @NotNull TradeIcon[] icons) {
        this.pattern = pattern;
        this.icons = icons;
    }

    public TradeLayout(@NotNull Pattern pattern, int size) {
        this(pattern, new TradeIcon[size]);
    }

    public TradeLayout(@NotNull Pattern pattern) {
        this(pattern, pattern.getSize());
    }

    public TradeIcon[] getIcons() {
        return this.icons;
    }

    public boolean canHoldPlayerItem(int slot) {
        return this.pattern.canHoldPlayerItem(slot);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @NotNull
    public <T extends TradeIcon> T getIcon(@NotNull Class<T> c) {
        for (TradeIcon icon : this.icons) {
            if (!c.isInstance(icon)) continue;
            return (T)icon;
        }
        throw new IllegalStateException("Cannot find a TradeIcon with class " + c.getName());
    }

    public int getSlotOf(@NotNull TradeIcon icon) {
        for (int i = 0; i < this.icons.length; ++i) {
            TradeIcon other = this.icons[i];
            if (!icon.equals(other)) continue;
            return i;
        }
        throw new IllegalStateException("Cannot find icon " + icon.getClass() + " in layout \"" + this.pattern.getName() + "\"");
    }

    public boolean areTradeIconsEmpty() {
        for (TradeIcon icon : this.icons) {
            if (icon == null || icon.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

