/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout;

import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.DataMask;
import de.codingair.tradesystem.lib.codingapi.tools.io.utils.Serializable;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.trade.gui.layout.TradeLayout;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.IconNotFoundException;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.IconData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Pattern
implements Serializable,
Iterable<IconData> {
    private String name;
    private IconData[] icons;
    private int size;

    public Pattern(@NotNull String name, int size, @NotNull IconData[] icons) {
        this.name = name;
        this.icons = icons;
        this.size = size;
    }

    public Pattern(@NotNull String name, @NotNull IconData[] icons) {
        this(name, 54, icons);
    }

    public Pattern() {
    }

    @Override
    public boolean read(DataMask mask) throws IconNotFoundException {
        this.name = Pattern.deserializeName(mask);
        this.size = mask.getInteger("size", 54);
        if (this.size % 9 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 9!");
        }
        if (this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Size must be between 9 and 54!");
        }
        Map icons = (Map)mask.get("icons");
        this.icons = new IconData[this.size];
        IconNotFoundException exception = null;
        for (Map.Entry e : icons.entrySet()) {
            if (!(e.getKey() instanceof Integer) || !(e.getValue() instanceof Map)) continue;
            try {
                JSON json = new JSON((Map)e.getValue());
                IconData icon = new IconData();
                icon.read(json);
                this.icons[((Integer)e.getKey()).intValue()] = icon;
            }
            catch (IconNotFoundException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return true;
    }

    public static String deserializeName(DataMask mask) {
        return mask.getString("name");
    }

    @Override
    public void write(DataMask mask) {
        HashMap<Integer, JSON> icons = new HashMap<Integer, JSON>();
        for (int slot = 0; slot < this.icons.length; ++slot) {
            IconData icon = this.icons[slot];
            if (icon == null) continue;
            JSON json = new JSON();
            icon.write(json);
            icons.put(slot, json);
        }
        mask.put("name", this.name);
        mask.put("size", this.size);
        mask.put("icons", icons);
    }

    public String getName() {
        return this.name;
    }

    public TradeLayout build() {
        TradeIcon[] icons = new TradeIcon[this.icons.length];
        for (int i = 0; i < this.icons.length; ++i) {
            IconData data = this.icons[i];
            if (data == null) continue;
            icons[i] = data.build();
        }
        return new TradeLayout(this, icons);
    }

    public int getAmountOf(@NotNull Class<? extends TradeIcon> c) {
        int i = 0;
        for (IconData icon : this.icons) {
            if (!icon.getTradeIcon().equals(c)) continue;
            ++i;
        }
        return i;
    }

    public IconData[] getIcons() {
        return this.icons;
    }

    public boolean canHoldPlayerItem(int slot) {
        IconData data = this.icons[slot];
        return TradeSlot.class.equals(data.getTradeIcon());
    }

    public int getTradeSlotCount() {
        return this.getAmountOf(TradeSlot.class);
    }

    public List<Integer> getSlotsOf(@NotNull Class<? extends TradeIcon> c) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.icons.length; ++slot) {
            IconData icon = this.icons[slot];
            if (icon == null || !c.equals(icon.getTradeIcon())) continue;
            slots.add(slot);
        }
        return slots;
    }

    @Override
    @NotNull
    public Iterator<IconData> iterator() {
        return Arrays.stream(this.icons).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        return Objects.equals(this.name, pattern.name) && Arrays.equals(this.icons, pattern.icons);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.size);
        result = 31 * result + Arrays.hashCode(this.getIcons());
        return result;
    }

    public int getSize() {
        return this.size;
    }
}

