/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.layout;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeIconInitializeEvent;
import de.codingair.tradesystem.spigot.events.TradePatternRegistrationEvent;
import de.codingair.tradesystem.spigot.extras.external.PluginDependencies;
import de.codingair.tradesystem.spigot.extras.external.essentials.EssentialsDependency;
import de.codingair.tradesystem.spigot.extras.external.vault.VaultDependency;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.patterns.DefaultExpPattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.patterns.DefaultPattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.TransitionTargetEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.exceptions.TradeIconException;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.ImportHelper;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Name;
import de.codingair.tradesystem.spigot.trade.listeners.JoinNoteListener;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.json.simple.parser.ParseException;

public class LayoutManager {
    private final HashMap<Name, Pattern> patterns = new HashMap();
    private final Map<Name, Pattern> incompletePatterns = new HashMap<Name, Pattern>();
    private final Map<Name, Map<?, ?>> crashedPatterns = new HashMap();
    private String active;

    public void load() {
        this.patterns.clear();
        TradeIconInitializeEvent event = new TradeIconInitializeEvent((icon, info) -> {
            try {
                if (info instanceof TransitionTargetEditorInfo) {
                    IconHandler.register((Class<? extends TradeIcon>)icon, (TransitionTargetEditorInfo)info);
                } else {
                    IconHandler.register((Class<? extends TradeIcon>)icon, info);
                }
            }
            catch (TradeIconException e) {
                throw new RuntimeException(e);
            }
        });
        Bukkit.getPluginManager().callEvent((Event)event);
        TradeSystem.log("  > Loading layouts");
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Layouts");
        YamlConfiguration config = file.getConfig();
        int standardLayouts = this.patterns.size();
        List dataList = config.getList("Layouts");
        this.incompletePatterns.clear();
        this.crashedPatterns.clear();
        if (dataList != null) {
            for (Object data : dataList) {
                if (data instanceof Map) {
                    JSON json = new JSON((Map)data);
                    Pattern pattern = new Pattern();
                    try {
                        pattern.read(json);
                        this.patterns.putIfAbsent(new Name(pattern.getName()), pattern);
                    }
                    catch (TradeIconException e) {
                        TradeSystem.getInstance().getLogger().log(Level.SEVERE, "A layout could not been loaded due to an error: " + e.getMessage());
                        this.incompletePatterns.put(new Name(pattern.getName()), pattern);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.crashedPatterns.put(new Name(Pattern.deserializeName(json)), json);
                    }
                    continue;
                }
                if (!(data instanceof String)) continue;
                try {
                    Pattern pattern = ImportHelper.convert((String)data);
                    this.patterns.put(new Name(pattern.getName()), pattern);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.stickDefaultPatterNote();
        }
        if (this.addDefaultPatterns()) {
            this.saveLayouts();
        }
        this.active = config.getString("Active");
        if (this.active == null || !this.patterns.containsKey(new Name(this.active))) {
            Pattern pattern = this.getBackupPattern();
            if (this.active == null) {
                TradeSystem.getInstance().getLogger().log(Level.WARNING, "No active layout found. Switching to the default layout: '" + pattern.getName() + "'");
            } else {
                TradeSystem.getInstance().getLogger().log(Level.WARNING, "The active layout " + (this.active == null ? "null" : "'" + this.active + "'") + " could not be found. Switching to the default layout: '" + pattern.getName() + "'");
            }
            this.active = pattern.getName();
            this.saveActiveLayout();
        }
        TradeSystem.log("    ...got " + (this.patterns.size() - standardLayouts) + " layout(s)");
    }

    private void stickDefaultPatterNote() {
        TextComponent message = new TextComponent(Lang.getPrefix() + "\u00a77You haven't setup a trade layout. Activate one now:");
        message.addExtra("\n\u00a78- \u00a7eNon-economy layout \u00a78[");
        TextComponent activateDef = new TextComponent("\u00a77default");
        activateDef.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent("\u00a78\u00bb \u00a7aActivate the non-economy layout \u00a78\u00ab")}));
        activateDef.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tradesystem layout activate Standard"));
        message.addExtra((BaseComponent)activateDef);
        message.addExtra("\u00a78]");
        message.addExtra("\n\u00a78- \u00a7eExp layout \u00a78[");
        TextComponent activateExp = new TextComponent("\u00a7aactivate");
        activateExp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent("\u00a78\u00bb \u00a7aActivate the Exp layout \u00a78\u00ab")}));
        activateExp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tradesystem layout activate Standard-Exp"));
        message.addExtra((BaseComponent)activateExp);
        message.addExtra("\u00a78]");
        if (PluginDependencies.isEnabled(VaultDependency.class)) {
            message.addExtra("\n\u00a78- \u00a7eVault layout \u00a78[");
            TextComponent activateVault = new TextComponent("\u00a7aactivate");
            activateVault.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent("\u00a78\u00bb \u00a7aActivate the Vault layout \u00a78\u00ab")}));
            activateVault.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tradesystem layout activate Standard-Vault"));
            message.addExtra((BaseComponent)activateVault);
            message.addExtra("\u00a78]");
        }
        if (PluginDependencies.isEnabled(EssentialsDependency.class)) {
            message.addExtra("\n\u00a78- \u00a7eEssentials layout \u00a78[\u00a7a");
            TextComponent activateEssentials = new TextComponent("\u00a7aactivate");
            activateEssentials.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent("\u00a78\u00bb \u00a7aActivate the Essentials layout \u00a78\u00ab")}));
            activateEssentials.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tradesystem layout activate Standard-Essentials"));
            message.addExtra((BaseComponent)activateEssentials);
            message.addExtra("\u00a78]");
        }
        JoinNoteListener.applyNote(message);
    }

    public void saveLayouts() {
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Layouts");
        YamlConfiguration config = file.getConfig();
        ArrayList data = new ArrayList();
        this.serializePatterns(data, this.patterns.values());
        this.serializePatterns(data, this.incompletePatterns.values());
        data.addAll(this.crashedPatterns.values());
        config.set("Layouts", data);
        file.saveConfig();
        TradeSystem.getInstance().getLogger().log(Level.INFO, "Saved " + data.size() + " layout(s).");
    }

    public void saveActiveLayout() {
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Layouts");
        YamlConfiguration config = file.getConfig();
        config.set("Active", (Object)this.active);
        file.saveConfig();
        TradeSystem.getInstance().getLogger().log(Level.INFO, "Saved '" + this.active + "' as active layout.");
    }

    private boolean addDefaultPatterns() {
        if (this.patterns.isEmpty()) {
            TradeSystem.getInstance().getLogger().log(Level.WARNING, "No trade pattern found -> create default patterns");
        }
        boolean added = this.addIfAbsentPattern(new DefaultPattern(), false);
        added |= this.addIfAbsentPattern(new DefaultExpPattern(), false);
        TradePatternRegistrationEvent event = new TradePatternRegistrationEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        for (Pattern pattern : event.getPatterns()) {
            added |= this.addIfAbsentPattern(pattern, false);
        }
        return added;
    }

    private Pattern getBackupPattern() {
        return this.patterns.getOrDefault(new Name("Standard"), this.patterns.getOrDefault(new Name("Standard-Exp"), this.patterns.getOrDefault(new Name("Standard-Vault"), this.patterns.getOrDefault(new Name("Standard-Essentials"), this.patterns.values().stream().findAny().orElse(null)))));
    }

    private void serializePatterns(List<Map<?, ?>> data, Collection<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            JSON json = new JSON();
            pattern.write(json);
            data.add(json);
        }
    }

    public Pattern getPattern(@Nullable String name) {
        return this.getPattern(name, false);
    }

    public Pattern getPattern(@Nullable String name, boolean incomplete) {
        if (name == null) {
            return null;
        }
        Pattern pattern = this.patterns.get(new Name(name));
        if (pattern == null && incomplete) {
            return this.incompletePatterns.get(new Name(name));
        }
        return pattern;
    }

    public boolean addPattern(Pattern pattern) {
        boolean created = this.patterns.put(new Name(pattern.getName()), pattern) == null;
        this.saveLayouts();
        return created;
    }

    public boolean addIfAbsentPattern(Pattern pattern, boolean save) {
        boolean created;
        boolean bl = created = this.patterns.putIfAbsent(new Name(pattern.getName()), pattern) == null;
        if (created && save) {
            this.saveLayouts();
        }
        return created;
    }

    public void delete(@NotNull Pattern pattern) {
        if (this.patterns.remove(new Name(pattern.getName())) != null) {
            if (this.patterns.isEmpty()) {
                this.addDefaultPatterns();
            }
            this.saveLayouts();
        }
    }

    @NotNull
    public Pattern getActive() {
        return this.getPattern(this.active);
    }

    public void setActive(@NotNull String name) {
        this.active = name;
        this.saveActiveLayout();
    }

    public Collection<Pattern> getPatterns() {
        return this.getPatterns(false);
    }

    public Collection<Pattern> getPatterns(boolean incomplete) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(this.patterns.values());
        if (incomplete) {
            patterns.addAll(this.incompletePatterns.values());
        }
        return patterns;
    }

    public boolean isAvailable(@Nullable String name) {
        if (name == null) {
            return true;
        }
        return this.getPattern(name) == null && !this.incompletePatterns.containsKey(new Name(name)) && !this.crashedPatterns.containsKey(new Name(name));
    }

    public Map<Name, Map<?, ?>> getCrashedPatterns() {
        return this.crashedPatterns;
    }
}

