/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.editor.utils;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.Page;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Item;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyClosedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemStackEnterGUI
extends GUI {
    private static final int INPUT_SLOT = 13;
    private static final int ACCEPT_SLOT = 16;
    private final Callback<ItemStack> callback;
    private final ItemStack previous;
    private Listener listener;
    private boolean cancelling = false;

    public ItemStackEnterGUI(Player player, String title, @Nullable ItemStack previous, @NotNull Callback<ItemStack> callback) {
        super(player, TradeSystem.getInstance(), 27, title);
        this.callback = callback;
        this.previous = previous;
        this.registerPage(new DefaultPage(this), true);
    }

    @Override
    public void open() throws AlreadyOpenedException, NoPageException, IsWaitingException {
        super.open();
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.HIGH)
            public void onClose(InventoryClickEvent e) {
                if (ItemStackEnterGUI.this.player.equals((Object)e.getWhoClicked()) && (e.getSlot() == 13 || e.getView().getBottomInventory().equals((Object)e.getClickedInventory()))) {
                    e.setCancelled(false);
                    Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> ItemStackEnterGUI.this.getActive().updateItem(16), 1L);
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)TradeSystem.getInstance());
    }

    @Override
    public void close() throws AlreadyClosedException {
        if (this.listener != null) {
            HandlerList.unregisterAll((Listener)this.listener);
            this.listener = null;
        }
        if (!this.cancelling) {
            this.callback.accept(this.getItem(13));
        }
        super.close();
    }

    private class DefaultPage
    extends Page {
        public DefaultPage(GUI gui) {
            super(gui);
        }

        @Override
        public void buildItems() {
            ItemStack blackGlass = new ItemBuilder(XMaterial.BLACK_STAINED_GLASS_PANE).setHideName(true).getItem();
            ItemStack grayGlass = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE).setHideName(true).getItem();
            this.addButton(1, 1, new Button(){

                @Override
                @Nullable
                public ItemStack buildItem() {
                    ItemBuilder builder = new ItemBuilder();
                    builder.setType(XMaterial.BARRIER);
                    builder.setName("\u00a7c" + Lang.get("Back", new Lang.P[0]));
                    return builder.getItem();
                }

                @Override
                public boolean canClick(ClickType clickType) {
                    return true;
                }

                @Override
                public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                    try {
                        ItemStackEnterGUI.this.cancelling = true;
                        ItemStackEnterGUI.this.close();
                    }
                    catch (AlreadyClosedException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.addButton(16, new Button(){

                @Override
                @Nullable
                public ItemStack buildItem() {
                    ItemBuilder builder = new ItemBuilder();
                    if (this.hasItem()) {
                        builder.setType(XMaterial.LIME_TERRACOTTA);
                        builder.setName("\u00a7a" + Lang.get("Set", new Lang.P[0]));
                    } else {
                        builder.setType(XMaterial.LIGHT_GRAY_TERRACOTTA);
                        builder.setName("\u00a77" + Lang.get("Set", new Lang.P[0]));
                    }
                    return builder.getItem();
                }

                @Override
                public boolean canClick(ClickType clickType) {
                    return this.hasItem();
                }

                private boolean hasItem() {
                    return DefaultPage.this.gui.getItem(4, 1) != null;
                }

                @Override
                public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                    try {
                        ItemStackEnterGUI.this.close();
                    }
                    catch (AlreadyClosedException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.addButton(3, 1, new Item(grayGlass));
            this.addButton(5, 1, new Item(grayGlass));
            for (int i = 0; i < 3; ++i) {
                this.addLine(0, i, 8, i, new Item(blackGlass));
            }
            this.removeButtonAt(13);
            this.gui.setItem(13, ItemStackEnterGUI.this.previous);
        }
    }
}

