/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.editor;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.Page;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Item;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyClosedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.PageAlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.editor.Editor;
import de.codingair.tradesystem.spigot.trade.gui.editor.IconPage;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.Type;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class LayoutPage
extends Page {
    private final Editor editor;

    public LayoutPage(Editor editor) {
        super(editor);
        this.editor = editor;
    }

    @Override
    public void buildItems() {
        ItemStack blackGlass = new ItemBuilder(XMaterial.BLACK_STAINED_GLASS_PANE).setHideName(true).getItem();
        ItemStack grayGlass = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE).setHideName(true).getItem();
        this.addLine(0, 0, 0, 2, new Item(blackGlass));
        this.addLine(7, 0, 7, 2, new Item(blackGlass));
        this.addLine(1, 0, 6, 0, new Item(grayGlass));
        this.addButton(8, 1, new Item(grayGlass));
        this.addButton(8, 0, new Button(){

            @Override
            @Nullable
            public ItemStack buildItem() {
                ItemBuilder builder = new ItemBuilder();
                builder.setType(XMaterial.RED_TERRACOTTA);
                builder.setName("\u00a7c" + Lang.get("Cancel", new Lang.P[0]));
                return builder.getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                return true;
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                try {
                    Sound.ENTITY_ITEM_BREAK.playSound((Entity)gui.getPlayer(), 0.7f, 1.0f);
                    gui.close();
                }
                catch (AlreadyClosedException e) {
                    e.printStackTrace();
                }
            }
        });
        this.addButton(8, 2, new Button(){

            @Override
            @Nullable
            public ItemStack buildItem() {
                ItemBuilder builder = new ItemBuilder();
                if (LayoutPage.this.editor.canFinish()) {
                    builder.setType(XMaterial.LIME_TERRACOTTA);
                    builder.setName("\u00a7a" + Lang.get("Finish", new Lang.P[0]));
                } else {
                    builder.setType(XMaterial.LIGHT_GRAY_TERRACOTTA);
                    builder.setName("\u00a77" + Lang.get("Finish", new Lang.P[0]));
                    builder.addLore("", Lang.get("Not_Ready_For_Saving", new Lang.P[0]));
                }
                return builder.getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                return LayoutPage.this.editor.canFinish();
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                try {
                    Pattern pattern = LayoutPage.this.editor.buildPattern();
                    if (TradeSystem.getInstance().getLayoutManager().addPattern(pattern)) {
                        Lang.send((CommandSender)gui.getPlayer(), "\u00a77", "Layout_Finished", new Lang.P[0]);
                    } else {
                        Lang.send((CommandSender)gui.getPlayer(), "\u00a77", "Layout_Edited", new Lang.P[0]);
                    }
                    Sound.ENTITY_PLAYER_LEVELUP.playSound((Entity)gui.getPlayer(), 0.7f, 1.0f);
                    gui.close();
                }
                catch (AlreadyClosedException e) {
                    e.printStackTrace();
                }
            }
        });
        int slot = 1;
        for (final Type value : Type.values()) {
            if (IconHandler.isTypeEmpty(value)) continue;
            this.addButton(slot, new Button(){

                @Override
                @Nullable
                public ItemStack buildItem() {
                    ItemBuilder builder = value.getItem();
                    builder.setName("\u00a76\u00a7n" + value.getName());
                    if (this.isPageActive()) {
                        builder.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                        builder.setHideEnchantments(true);
                    }
                    return builder.getItem();
                }

                private boolean isPageActive() {
                    Page p = LayoutPage.this.gui.getActive();
                    if (p instanceof IconPage) {
                        IconPage iconPage = (IconPage)p;
                        return iconPage.getType() == value;
                    }
                    return false;
                }

                @Override
                public boolean canClick(ClickType clickType) {
                    return !this.isPageActive();
                }

                @Override
                public void onClick(GUI gui, InventoryClickEvent inventoryClickEvent) {
                    try {
                        Page page = ((Editor)gui).getPage(value);
                        gui.switchTo(page);
                        page.updateItems(true);
                    }
                    catch (PageAlreadyOpenedException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (++slot == 7) break;
        }
    }
}

