/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.editor;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.Page;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.buttons.Button;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import de.codingair.tradesystem.lib.codingapi.tools.Callback;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.editor.Editor;
import de.codingair.tradesystem.spigot.trade.gui.editor.utils.InventoryEditorButton;
import de.codingair.tradesystem.spigot.trade.gui.editor.utils.ItemStackEnterGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.EditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.MultiEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.Type;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.MultiTradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.DecorationIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlotOther;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IconPage
extends Page {
    protected final List<EditorInfo> icons;
    private final Type type;
    protected Editor editor;

    public IconPage(Editor editor, Type type, Page basic) {
        super(editor, basic);
        this.editor = editor;
        this.type = type;
        this.icons = IconHandler.getIcons(this.type);
    }

    @Override
    public void buildItems() {
        int slot = 1;
        for (EditorInfo icon : this.icons) {
            this.addButton(slot, 2, this.buildButton(slot + 18, icon));
            if (++slot != 7) continue;
            break;
        }
    }

    private Button buildButton(final int slot, final EditorInfo editorInfo) {
        return new InventoryEditorButton(){
            int variantId = 0;
            boolean resetting = false;

            @Override
            @Nullable
            public ItemStack buildItem() {
                ItemStack[] variants;
                MultiEditorInfo multiEditorInfo;
                boolean alreadySet = IconPage.this.isLayoutInventoryNotEmpty() && IconPage.this.editor.getIcons().containsValue(editorInfo.getTradeIcon());
                ItemBuilder builder = editorInfo.getEditorIcon(IconPage.this.editor);
                boolean addMarker = false;
                boolean done = alreadySet;
                if (done && TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    boolean bl = done = IconPage.this.editor.getAmountOf(TradeSlot.class) == IconPage.this.editor.getAmountOf(TradeSlotOther.class);
                }
                if (editorInfo.getTradeIcon().equals(DecorationIcon.class)) {
                    if (IconPage.this.editor.needsMoreDecorationItems()) {
                        addMarker = true;
                    } else {
                        done = true;
                    }
                } else {
                    if (editorInfo.isNecessary() && !alreadySet && !IconPage.this.editor.needsMoreDecorationItems()) {
                        addMarker = true;
                    }
                    if (!addMarker && alreadySet) {
                        if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo) {
                            boolean variantsNotDone;
                            multiEditorInfo = (MultiEditorInfo)editorInfo;
                            variants = IconPage.this.editor.getVariants(editorInfo.getTradeIcon(), null);
                            int configured = 0;
                            if (variants != null) {
                                for (ItemStack i : variants) {
                                    if (i == null) continue;
                                    ++configured;
                                }
                            }
                            boolean bl = variantsNotDone = configured != multiEditorInfo.getIconName().length;
                            if (variantsNotDone) {
                                addMarker = true;
                            }
                            boolean bl2 = done = !variantsNotDone;
                        }
                        if (Transition.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo.getTransitionTarget() != null) {
                            boolean transitionTargetNotSet;
                            boolean bl = transitionTargetNotSet = !IconPage.this.editor.getIcons().containsValue(editorInfo.getTransitionTarget());
                            if (transitionTargetNotSet && !IconPage.this.editor.needsMoreDecorationItems()) {
                                addMarker = true;
                            }
                            boolean bl3 = done = !transitionTargetNotSet;
                        }
                    }
                }
                if (addMarker) {
                    builder.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                    builder.setHideEnchantments(true);
                }
                builder.setName("\u00a76\u00a7n" + editorInfo.getName() + (done ? "\u00a7r \u00a7a\u2714" : ""));
                builder.addLore("");
                if (editorInfo.getTradeIcon().equals(DecorationIcon.class)) {
                    builder.addLore("\u00a73" + Lang.get("Leftclick", new Lang.P[0]) + ": " + (alreadySet ? "\u00a77" : "\u00a7a") + Lang.get("Edit", new Lang.P[0]));
                } else if (TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    int otherTradeSlots;
                    int tradeSlots = IconPage.this.editor.getAmountOf(TradeSlot.class);
                    if (tradeSlots != (otherTradeSlots = IconPage.this.editor.getAmountOf(TradeSlotOther.class))) {
                        builder.removeLore();
                        builder.addText("\u00a77" + Lang.get("Layout_Hint_Same_Slot_Amount", IconPage.this.gui.getPlayer(), new Lang.P[0]), 150);
                        builder.addLore("");
                    }
                    builder.addLore("\u00a73" + Lang.get("Leftclick", new Lang.P[0]) + ": " + (alreadySet ? "\u00a77" : "\u00a7a") + Lang.get("Edit", new Lang.P[0]));
                } else {
                    builder.addLore("\u00a73" + Lang.get("Leftclick", new Lang.P[0]) + ": " + (alreadySet || IconPage.this.editor.hasNoUsableItems() ? "\u00a77" : "\u00a7a") + Lang.get("Select", new Lang.P[0]));
                }
                if (alreadySet) {
                    if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo) {
                        multiEditorInfo = (MultiEditorInfo)editorInfo;
                        variants = IconPage.this.editor.getVariants(editorInfo.getTradeIcon(), null);
                        boolean variantSet = variants != null && variants[this.variantId] != null;
                        int configured = 0;
                        if (variants != null) {
                            for (ItemStack i : variants) {
                                if (i == null) continue;
                                ++configured;
                            }
                        }
                        String statusColor = configured == multiEditorInfo.getIconName().length ? "\u00a7a" : "\u00a7c";
                        builder.removeLore();
                        builder.addLore("");
                        builder.addLore("\u00a73" + Lang.get("Variant", new Lang.P[0]) + ": " + (variantSet ? "\u00a7a" : "\u00a7c") + (this.variantId + 1) + ". " + multiEditorInfo.getIconName()[this.variantId] + " \u00a78(" + statusColor + configured + "\u00a78/" + statusColor + multiEditorInfo.getIconName().length + "\u00a78)");
                        builder.addLore("\u00a73" + Lang.get("Leftclick", new Lang.P[0]) + ": \u00a77" + (this.variantId == 0 ? Lang.get("Select", new Lang.P[0]) : Lang.get("Edit_Variant", new Lang.P[0])));
                        builder.addLore("\u00a78" + Lang.get("Shift_Leftclick", new Lang.P[0]) + ": \u00a78\u2192");
                    } else if (Transition.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                        boolean hasTarget = IconPage.this.editor.getIcons().containsValue(editorInfo.getTransitionTarget());
                        builder.addLore("\u00a73" + Lang.get("Rightclick", new Lang.P[0]) + ": " + (hasTarget || IconPage.this.editor.hasNoUsableItems() ? "\u00a77" : "\u00a7a") + Lang.get("Select_Foreign_Preview", new Lang.P[0]));
                    }
                    if (!TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                        builder.addLore("\u00a78" + Lang.get("Shift_Rightclick", new Lang.P[0]) + ": " + (this.resetting ? "\u00a7c" : "\u00a78") + Lang.get("Reset", new Lang.P[0]) + (this.resetting ? "?" : ""));
                    }
                }
                return builder.getItem();
            }

            @Override
            public boolean canClick(ClickType clickType) {
                boolean alreadySet;
                boolean bl = alreadySet = IconPage.this.isLayoutInventoryNotEmpty() && IconPage.this.editor.getIcons().containsValue(editorInfo.getTradeIcon());
                if (editorInfo.getTradeIcon().equals(DecorationIcon.class)) {
                    return clickType == ClickType.LEFT;
                }
                if (TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    return clickType == ClickType.LEFT;
                }
                if (alreadySet) {
                    if (clickType == ClickType.SHIFT_RIGHT) {
                        return true;
                    }
                    if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo) {
                        return clickType != ClickType.RIGHT;
                    }
                    if (Transition.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                        boolean hasTarget = IconPage.this.editor.getIcons().containsValue(editorInfo.getTransitionTarget());
                        if (clickType == ClickType.RIGHT) {
                            return !hasTarget && !IconPage.this.editor.hasNoUsableItems();
                        }
                    }
                }
                return clickType == ClickType.LEFT && !IconPage.this.editor.hasNoUsableItems();
            }

            @Override
            public void onClick(GUI gui, InventoryClickEvent e) {
                boolean alreadySet;
                boolean bl = alreadySet = IconPage.this.isLayoutInventoryNotEmpty() && IconPage.this.editor.getIcons().containsValue(editorInfo.getTradeIcon());
                if (alreadySet) {
                    if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo && e.getClick() == ClickType.SHIFT_LEFT) {
                        ++this.variantId;
                        MultiEditorInfo multiEditorInfo = (MultiEditorInfo)editorInfo;
                        if (this.variantId == multiEditorInfo.getIconName().length) {
                            this.variantId = 0;
                        }
                        IconPage.this.updateItem(slot);
                    }
                    if (e.getClick() == ClickType.SHIFT_RIGHT && !TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                        if (this.resetting) {
                            if (editorInfo.getTransitionTarget() != null) {
                                IconPage.this.editor.getIcons().entrySet().removeIf(entry -> ((Class)entry.getValue()).equals(editorInfo.getTradeIcon()) || ((Class)entry.getValue()).equals(editorInfo.getTransitionTarget()));
                            } else {
                                IconPage.this.editor.getIcons().entrySet().removeIf(entry -> ((Class)entry.getValue()).equals(editorInfo.getTradeIcon()));
                            }
                            this.variantId = 0;
                            this.resetting = false;
                            IconPage.this.updateItem(slot);
                        } else {
                            this.resetting = true;
                            IconPage.this.updateItem(slot);
                            Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> {
                                this.resetting = false;
                                IconPage.this.updateItem(slot);
                            }, 10L);
                        }
                    }
                }
            }

            @Override
            public boolean canSwitch(ClickType clickType) {
                if (editorInfo.getTradeIcon().equals(DecorationIcon.class)) {
                    return clickType == ClickType.LEFT;
                }
                if (TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    return clickType == ClickType.LEFT;
                }
                if (clickType == ClickType.SHIFT_RIGHT) {
                    return false;
                }
                if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo) {
                    return clickType == ClickType.LEFT;
                }
                return !IconPage.this.editor.hasNoUsableItems();
            }

            @Override
            public boolean open(ClickType clickType, GUI gui, Call call) {
                if (editorInfo.getTradeIcon().equals(DecorationIcon.class)) {
                    IconPage.this.editor.openLayoutInventory(null, null);
                } else if (TradeSlot.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    IconPage.this.editor.openLayoutInventory(editorInfo.getTradeIcon(), null);
                } else if (clickType == ClickType.LEFT && this.variantId == 0 || !IconPage.this.editor.getIcons().containsValue(editorInfo.getTradeIcon())) {
                    IconPage.this.editor.openLayoutInventory(editorInfo.getTradeIcon(), () -> {
                        boolean multi = MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon());
                        if (multi) {
                            this.variantId = 1;
                            IconPage.this.updateItem(slot);
                        }
                        call.proceed();
                    });
                } else if (Transition.class.isAssignableFrom(editorInfo.getTradeIcon())) {
                    IconPage.this.editor.openLayoutInventory(IconHandler.getTransitionTarget(editorInfo.getTradeIcon()), call);
                } else if (MultiTradeIcon.class.isAssignableFrom(editorInfo.getTradeIcon()) && editorInfo instanceof MultiEditorInfo) {
                    final MultiEditorInfo multiEditorInfo = (MultiEditorInfo)editorInfo;
                    try {
                        ItemStack[] variants = IconPage.this.editor.getVariants(editorInfo.getTradeIcon(), null);
                        ItemStack previous = variants == null ? null : variants[this.variantId];
                        new ItemStackEnterGUI(gui.getPlayer(), "\u00a78" + editorInfo.getName() + ": \u00a79" + multiEditorInfo.getIconName()[this.variantId], previous, new Callback<ItemStack>(){

                            @Override
                            public void accept(ItemStack itemStack) {
                                IconPage.this.editor.getVariants(editorInfo.getTradeIcon(), (Integer)Integer.valueOf((int)multiEditorInfo.getIconName().length))[variantId] = itemStack;
                                if (itemStack != null) {
                                    if (variantId == 0) {
                                        IconPage.this.editor.getLayoutInventory().setItem(IconPage.this.editor.getSlotOf(editorInfo.getTradeIcon()), itemStack);
                                    }
                                    ++variantId;
                                    if (multiEditorInfo.getIconName().length == variantId) {
                                        variantId = 0;
                                    }
                                }
                                IconPage.this.updateItem(slot);
                                IconPage.this.getBasic().updateItems();
                            }
                        }).open();
                    }
                    catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
                        e.printStackTrace();
                    }
                    return false;
                }
                return true;
            }
        };
    }

    private boolean isLayoutInventoryNotEmpty() {
        ItemStack[] contents;
        for (ItemStack content : contents = this.editor.getLayoutInventory().getContents()) {
            if (content == null || content.getType() == Material.AIR) continue;
            return true;
        }
        return false;
    }

    public Type getType() {
        return this.type;
    }
}

