/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui.editor;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.Page;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.tools.Call;
import de.codingair.tradesystem.lib.codingapi.tools.items.ItemBuilder;
import de.codingair.tradesystem.lib.codingapi.tools.items.XMaterial;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.gui.editor.IconPage;
import de.codingair.tradesystem.spigot.trade.gui.editor.LayoutPage;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.EditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.MultiEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.TransitionTargetEditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.Type;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.MultiTradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.DecorationIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlotOther;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.IconData;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Editor
extends GUI {
    public static final String ITEM_TITLE_COLOR = "\u00a76\u00a7n";
    public static final String ITEM_SUB_TITLE_COLOR = "\u00a73";
    private final String name;
    private final int tradeSize;
    private final ItemStack[] copy;
    private final Inventory layoutInventory;
    private final HashMap<Integer, Class<? extends TradeIcon>> icons = new HashMap();
    private final HashMap<Class<? extends TradeIcon>, ItemStack[]> variants = new HashMap();

    public Editor(String name, Player player) {
        this(name, 54, player);
    }

    public Editor(String name, int tradeSize, Player player) {
        this(name, tradeSize, null, player);
    }

    public Editor(Pattern pattern, Player player) {
        this(pattern.getName(), 54, pattern, player);
    }

    private Editor(@NotNull String name, int tradeSize, @Nullable Pattern pattern, Player player) {
        super(player, TradeSystem.getInstance(), 27, Lang.get("Layout_Editor", player, new Lang.P[0]));
        this.name = name;
        this.tradeSize = tradeSize;
        this.copy = new ItemStack[tradeSize];
        this.layoutInventory = Bukkit.createInventory((InventoryHolder)player, (int)tradeSize, (String)("\u00a7c" + Lang.get("Layout_Editor_Set_Items", player, new Lang.P[0])));
        if (pattern != null) {
            this.applyPattern(pattern);
        }
        LayoutPage basic = new LayoutPage(this);
        boolean first = true;
        for (Type value : Type.values()) {
            if (IconHandler.isTypeEmpty(value)) continue;
            this.registerPage(new IconPage(this, value, basic), first);
            first = false;
        }
    }

    @Override
    public void open() throws AlreadyOpenedException, NoPageException, IsWaitingException {
        super.open();
        Sound.ENTITY_EXPERIENCE_ORB_PICKUP.playSound((Entity)this.player, 0.7f, 1.0f);
    }

    @NotNull
    Page getPage(@NotNull Type type) {
        for (Page value : this.pages) {
            if (!(value instanceof IconPage) || ((IconPage)value).getType() != type) continue;
            return value;
        }
        throw new IllegalStateException("Could not found page with type " + (Object)((Object)type));
    }

    private void applyPattern(@NotNull Pattern pattern) {
        int slot = -1;
        for (IconData iconData : pattern) {
            ++slot;
            if (iconData == null) continue;
            if (TradeSlot.class.isAssignableFrom(iconData.getTradeIcon())) {
                this.icons.put(slot, iconData.getTradeIcon());
                continue;
            }
            ItemStack adding = null;
            if (iconData.getItems().length > 0) {
                adding = iconData.getItems()[0];
            }
            this.layoutInventory.setItem(slot, adding);
            if (DecorationIcon.class.isAssignableFrom(iconData.getTradeIcon())) continue;
            this.icons.put(slot, iconData.getTradeIcon());
            if (!MultiTradeIcon.class.isAssignableFrom(iconData.getTradeIcon())) continue;
            this.variants.put(iconData.getTradeIcon(), iconData.getItems());
        }
    }

    public Pattern buildPattern() {
        IconData[] data = new IconData[this.tradeSize];
        for (int slot = 0; slot < this.tradeSize; ++slot) {
            ItemStack item;
            Class<? extends TradeIcon> iconClass = this.icons.get(slot);
            IconData icon = null;
            if (iconClass != null) {
                if (MultiTradeIcon.class.isAssignableFrom(iconClass)) {
                    ItemStack[] items = this.variants.get(iconClass);
                    if (items == null) {
                        throw new IllegalStateException("Cannot create a layout pattern without enough information: missing variants for " + iconClass.getName());
                    }
                    icon = new IconData(iconClass, items);
                } else if (TradeSlot.class.isAssignableFrom(iconClass)) {
                    icon = new IconData(iconClass, new ItemStack[0]);
                } else {
                    item = this.layoutInventory.getItem(slot);
                    if (item == null) {
                        throw new IllegalStateException("Cannot create a layout pattern without enough information: missing item for " + iconClass.getName());
                    }
                    icon = new IconData(iconClass, item);
                }
            } else {
                item = this.layoutInventory.getItem(slot);
                if (item != null) {
                    icon = new IconData(DecorationIcon.class, item);
                }
            }
            data[slot] = icon;
        }
        return new Pattern(this.name, this.tradeSize, data);
    }

    public boolean canFinish() {
        for (EditorInfo editorInfo : IconHandler.getNecessaryIcons()) {
            if (this.icons.containsValue(editorInfo.getTradeIcon())) continue;
            return false;
        }
        for (Class clazz : this.icons.values()) {
            if (!MultiTradeIcon.class.isAssignableFrom(clazz)) continue;
            ItemStack[] items = this.variants.get(clazz);
            if (items == null) {
                return false;
            }
            for (ItemStack item : items) {
                if (item != null) continue;
                return false;
            }
        }
        for (Class clazz : this.icons.values()) {
            TransitionTargetEditorInfo info;
            Class<? extends TradeIcon> origin;
            Class<? extends TradeIcon> target;
            if (!(Transition.class.isAssignableFrom(clazz) ? !this.icons.containsValue(target = IconHandler.getTransitionTarget(clazz)) : Transition.Consumer.class.isAssignableFrom(clazz) && !this.icons.containsValue(origin = (info = (TransitionTargetEditorInfo)IconHandler.getInfo(clazz)).getOrigin()))) continue;
            return false;
        }
        int tradeSlots = (int)this.icons.values().stream().filter(i -> i.equals(TradeSlot.class)).count();
        int n = (int)this.icons.values().stream().filter(i -> i.equals(TradeSlotOther.class)).count();
        if (tradeSlots == 0) {
            return false;
        }
        return tradeSlots == n;
    }

    void openLayoutInventory(@Nullable Class<? extends TradeIcon> setting, @Nullable Call callback) {
        this.prepareLayout();
        Bukkit.getPluginManager().registerEvents(this.createListener(setting, callback), (Plugin)TradeSystem.getInstance());
        this.player.openInventory(this.layoutInventory);
    }

    private void prepareLayout() {
        ItemStack[] items = this.layoutInventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            this.copy[i] = item == null ? null : item.clone();
            Class<? extends TradeIcon> icon = this.icons.get(i);
            if (icon == null) continue;
            if (TradeSlot.class.isAssignableFrom(icon)) {
                this.layoutInventory.setItem(i, this.buildSlotCursor(icon, 1));
                continue;
            }
            if (item == null) continue;
            item.addUnsafeEnchantment(Enchantment.DAMAGE_ALL, 1);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            String name = IconHandler.getInfo(icon).getName();
            meta.setDisplayName("\u00a7c" + name);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
    }

    private void cleanLayout() {
        for (int i = 0; i < this.copy.length; ++i) {
            this.cleanItem(i, null);
        }
    }

    private void cleanItem(int slot, @Nullable Class<? extends TradeIcon> icon) {
        if (icon != null && TradeSlot.class.isAssignableFrom(icon)) {
            this.copy[slot] = null;
            this.layoutInventory.setItem(slot, null);
            return;
        }
        if (this.copy[slot] == null || this.layoutInventory.getItem(slot) == null) {
            return;
        }
        this.layoutInventory.setItem(slot, this.copy[slot]);
        this.copy[slot] = null;
    }

    @NotNull
    private ItemStack buildSlotCursor(Class<? extends TradeIcon> icon, int amount) {
        ItemBuilder builder = new ItemBuilder();
        if (TradeSlot.class.equals(icon)) {
            builder.setType(XMaterial.BLACK_STAINED_GLASS_PANE);
        } else {
            builder.setType(XMaterial.WHITE_STAINED_GLASS_PANE);
        }
        builder.setAmount(amount);
        builder.addEnchantment(Enchantment.DAMAGE_ALL, 1);
        builder.setHideEnchantments(true);
        EditorInfo info = IconHandler.getInfo(icon);
        builder.setName("\u00a7c" + info.getName());
        return builder.getItem();
    }

    public boolean needsMoreDecorationItems() {
        boolean needItems = false;
        for (EditorInfo e : IconHandler.getNecessaryIcons()) {
            if (this.icons.containsValue(e.getTradeIcon())) continue;
            needItems = true;
            break;
        }
        if (!needItems) {
            return false;
        }
        ItemStack[] items = this.layoutInventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            if (this.icons.containsKey(i) || items[i] == null || items[i].getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoUsableItems() {
        ItemStack[] items = this.layoutInventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            Class<? extends TradeIcon> current = this.icons.get(i);
            if (current != null && TradeSlot.class.isAssignableFrom(current) || items[i] == null || items[i].getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    private int countIcon(@NotNull Class<? extends TradeIcon> setting) {
        int count = 0;
        for (Class<? extends TradeIcon> value : this.icons.values()) {
            if (!value.equals(setting)) continue;
            ++count;
        }
        return count;
    }

    public int getSlotOf(@NotNull Class<? extends TradeIcon> icon) {
        for (Map.Entry<Integer, Class<? extends TradeIcon>> e : this.icons.entrySet()) {
            if (!icon.equals(e.getValue())) continue;
            return e.getKey();
        }
        return -1;
    }

    public Map<Integer, Class<? extends TradeIcon>> getIcons() {
        return this.icons;
    }

    public int getAmountOf(@NotNull Class<? extends TradeIcon> icon) {
        return (int)this.icons.values().stream().filter(i -> i.equals(icon)).count();
    }

    public Inventory getLayoutInventory() {
        return this.layoutInventory;
    }

    @Nullable
    public ItemStack[] getVariants(@NotNull Class<? extends TradeIcon> icon, @Nullable Integer size) {
        if (size == null) {
            return this.variants.get(icon);
        }
        return this.variants.computeIfAbsent(icon, i -> new ItemStack[size.intValue()]);
    }

    @NotNull
    private Listener createListener(final @Nullable Class<? extends TradeIcon> setting, final @Nullable Call callback) {
        return new Listener(){
            private boolean open = false;

            @EventHandler(priority=EventPriority.LOW)
            public void onClose(InventoryCloseEvent e) {
                if (!Editor.this.player.equals((Object)e.getPlayer()) || !this.open) {
                    return;
                }
                this.closing(e.getView());
            }

            @EventHandler
            public void onOpen(InventoryOpenEvent e) {
                if (!Editor.this.player.equals((Object)e.getPlayer())) {
                    return;
                }
                if (this.isSlotIcon()) {
                    assert (setting != null);
                    int amount = 26 - Editor.this.countIcon(setting);
                    Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> e.getView().setCursor(Editor.this.buildSlotCursor(setting, amount)), 1L);
                }
                this.open = true;
            }

            @EventHandler
            public void onDrop(PlayerDropItemEvent e) {
                if (!Editor.this.player.equals((Object)e.getPlayer())) {
                    return;
                }
                if (this.isSlotIcon()) {
                    e.setCancelled(true);
                }
            }

            @EventHandler
            public void onDrag(InventoryDragEvent e) {
                if (!Editor.this.player.equals((Object)e.getWhoClicked())) {
                    return;
                }
                if (this.isSlotIcon()) {
                    for (Integer rawSlot : e.getRawSlots()) {
                        if (rawSlot <= 54) continue;
                        e.setCancelled(true);
                        return;
                    }
                }
            }

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                Class icon;
                if (!Editor.this.player.equals((Object)e.getWhoClicked())) {
                    return;
                }
                if (setting != null) {
                    if (callback != null) {
                        e.setCancelled(true);
                        if (e.getView().getTopInventory().equals((Object)e.getClickedInventory()) && e.getCurrentItem() != null) {
                            Class icon2 = (Class)Editor.this.icons.get(e.getSlot());
                            if (icon2 != null && TradeSlot.class.isAssignableFrom(icon2)) {
                                return;
                            }
                            this.removeIcon(e.getSlot());
                            this.removeIcon(Editor.this.getSlotOf(setting));
                            Editor.this.icons.put(e.getSlot(), setting);
                            if (MultiTradeIcon.class.isAssignableFrom(setting)) {
                                MultiEditorInfo info = (MultiEditorInfo)IconHandler.getInfo(setting);
                                Editor.this.cleanItem(e.getSlot(), null);
                                Editor.this.getVariants((Class<? extends TradeIcon>)setting, (Integer)Integer.valueOf((int)info.getIconName().length))[0] = e.getCurrentItem().clone();
                            }
                            Sound.UI_BUTTON_CLICK.playSound((Entity)Editor.this.player, 0.7f, 1.0f);
                            this.closing(e.getView());
                            callback.proceed();
                        }
                    } else if (!e.getView().getTopInventory().equals((Object)e.getClickedInventory())) {
                        e.setCancelled(true);
                    } else {
                        Class current = (Class)Editor.this.icons.get(e.getSlot());
                        if (current != null && !setting.equals(current)) {
                            e.setCancelled(true);
                        } else if (e.getAction() == InventoryAction.HOTBAR_SWAP || e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                            e.setCancelled(true);
                        }
                    }
                } else if (e.getView().getTopInventory().equals((Object)e.getClickedInventory()) && e.getCurrentItem() != null && (icon = (Class)Editor.this.icons.remove(e.getSlot())) != null) {
                    Editor.this.cleanItem(e.getSlot(), icon);
                }
            }

            private void removeIcon(int slot) {
                Class icon = (Class)Editor.this.icons.remove(slot);
                if (icon == null) {
                    return;
                }
                if (Transition.class.isAssignableFrom(icon)) {
                    EditorInfo info = IconHandler.getInfo(icon);
                    Class<? extends TradeIcon> target = info.getTransitionTarget();
                    assert (target != null);
                    if (Editor.this.icons.containsValue(target)) {
                        this.removeIcon(Editor.this.getSlotOf(target));
                    }
                }
            }

            private boolean isSlotIcon() {
                if (setting == null) {
                    return false;
                }
                return TradeSlot.class.isAssignableFrom(setting);
            }

            private void closing(InventoryView view) {
                if (this.isSlotIcon()) {
                    ItemStack cursor = Editor.this.buildSlotCursor(setting, 1);
                    view.setCursor(null);
                    Editor.this.icons.entrySet().removeIf(e -> ((Class)e.getValue()).equals(setting) && Editor.this.layoutInventory.getItem(((Integer)e.getKey()).intValue()) == null);
                    for (int slot = 0; slot < Editor.this.layoutInventory.getContents().length; ++slot) {
                        ItemStack item = Editor.this.layoutInventory.getContents()[slot];
                        if (!cursor.isSimilar(item)) continue;
                        Editor.this.icons.putIfAbsent(slot, setting);
                        item.setAmount(1);
                    }
                }
                HandlerList.unregisterAll((Listener)this);
                Editor.this.cleanLayout();
                Editor.this.getActive().updateItems();
            }
        };
    }
}

