/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsNotWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.TradingPage;
import de.codingair.tradesystem.spigot.utils.FloodgateUtils;
import de.codingair.tradesystem.spigot.utils.Lang;
import org.bukkit.entity.Player;

public class TradingGUI
extends GUI {
    private final Trade trade;
    private final int id;

    public TradingGUI(Player player, Trade trade, int id) {
        super(player, TradeSystem.getInstance(), trade.getLayout()[id].getPattern().getSize(), Lang.get("GUI_Title", player, new Lang.P("player", trade.getOther(player.getName()))), false);
        this.trade = trade;
        this.id = id;
    }

    public void synchronizeTitle() {
        boolean isBedrockPlayer = FloodgateUtils.isBedrockPlayer(this.getPlayer());
        if (isBedrockPlayer) {
            return;
        }
        this.updateTitle(Lang.get("GUI_Title", this.getPlayer(), new Lang.P("player", this.trade.getOther(this.getPlayer().getName()))));
    }

    public void prepareStart() {
        this.registerPage(new TradingPage(this, this.trade, this.id), true);
    }

    @Override
    protected void continueGUI() throws IsNotWaitingException {
        if (this.trade.isCancelling()) {
            return;
        }
        super.continueGUI();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!this.trade.getPause()[this.id]) {
            this.trade.cancel();
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    @Override
    public void openNestedGUI(GUI gui, boolean listenOnClose, boolean clickSound) throws AlreadyOpenedException, NoPageException, IsWaitingException {
        this.trade.acknowledgeGuiSwitch(this.player);
        super.openNestedGUI(gui, listenOnClose, clickSound);
    }
}

