/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui;

import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.Actions;
import de.codingair.tradesystem.spigot.trade.gui.TradingGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.shulker.ShulkerPeekGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TradeGUIListener
implements Listener {
    @NotNull
    private Actions.Configuration getConfiguration(@NotNull Player player, @NotNull Trade trade, @NotNull Perspective perspective) {
        Actions.Configuration configuration = Actions.Configuration.DEFAULT();
        Perspective other = perspective.flip();
        configuration.targetSlots = e -> trade.getSlots();
        configuration.isItemAllowedInInventory = (items, slots) -> {
            for (ItemStack item : items) {
                if (!TradeSystem.getInstance().getTradeManager().isBlocked(trade, player, trade.getPlayer(other), trade.getNames()[other.id()], trade.getUniqueId(other), item)) continue;
                Lang.send((CommandSender)player, "Trade_Placed_Blocked_Item", new Lang.P[0]);
                TradeSystem.getInstance().getTradeManager().playBlockSound(player);
                return false;
            }
            if (!TradeSystem.getInstance().getTradeManager().isDropItems() && !trade.fitsTrade(perspective, (Collection<ItemStack>)items)) {
                Lang.send((CommandSender)player, "Trade_Partner_No_Space", new Lang.P[0]);
                TradeSystem.getInstance().getTradeManager().playBlockSound(player);
                return false;
            }
            return true;
        };
        return configuration;
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent e) {
        Trade trade = TradeSystem.handler().getTrade(e.getPlayer());
        if (trade != null && !TradeSystem.handler().isDropItems()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDrag(InventoryDragEvent e) {
        if (e.getWhoClicked() instanceof Player) {
            Player player = (Player)e.getWhoClicked();
            Trade trade = TradeSystem.handler().getTrade(player);
            if (trade != null && trade.inMainGUI(player)) {
                e.setCancelled(false);
                Perspective perspective = trade.getPerspective(player);
                boolean offerChange = Actions.projectResult(e, this.getConfiguration(player, trade, perspective));
                this.handleResult(offerChange, trade, perspective);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onClick(InventoryClickEvent e) {
        if (e.getWhoClicked() instanceof Player) {
            Player player = (Player)e.getWhoClicked();
            Trade trade = TradeSystem.handler().getTrade(player);
            if (trade != null && trade.inMainGUI(player)) {
                if (e.isCancelled()) {
                    return;
                }
                e.setCancelled(true);
                Perspective perspective = trade.getPerspective(player);
                if (this.checkForShulkerBoxes(e, trade, player, perspective)) {
                    return;
                }
                boolean offerChange = Actions.projectResult(e, this.getConfiguration(player, trade, perspective));
                this.handleResult(offerChange, trade, perspective);
            }
        }
    }

    private void handleResult(boolean offerChange, @NotNull Trade trade, @NotNull Perspective perspective) {
        boolean cannotDropItems;
        boolean bl = cannotDropItems = !TradeSystem.getInstance().getTradeManager().isDropItems();
        if (cannotDropItems) {
            trade.cancelItemOverflow(perspective.flip());
        }
        if (offerChange) {
            trade.onTradeOfferChange(false);
            trade.updateLater();
        }
        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> trade.synchronizePlayerInventory(perspective));
    }

    private boolean checkForShulkerBoxes(@NotNull InventoryClickEvent event, @NotNull Trade trade, @NotNull Player player, @NotNull Perspective perspective) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory) {
            boolean ownSlots = trade.getSlots().contains(event.getSlot());
            if (ownSlots) {
                if (event.getClick() == ClickType.RIGHT && Version.atLeast(11.0) && ShulkerPeekGUI.isShulkerBox(event.getCurrentItem())) {
                    this.openShulkerPeekingGUI(event, player, trade, perspective, perspective);
                    return true;
                }
            } else {
                boolean otherSlots = trade.getOtherSlots().contains(event.getSlot());
                if (otherSlots && Version.atLeast(11.0) && ShulkerPeekGUI.isShulkerBox(event.getCurrentItem())) {
                    this.openShulkerPeekingGUI(event, player, trade, perspective, perspective.flip());
                    return true;
                }
            }
        }
        return false;
    }

    private void openShulkerPeekingGUI(@NotNull InventoryClickEvent e, @NotNull Player player, @NotNull Trade trade, @NotNull Perspective perspective, @NotNull Perspective owner) {
        TradingGUI tradingGUI = trade.getGUIs()[perspective.id()];
        try {
            assert (e.getCurrentItem() != null);
            tradingGUI.openNestedGUI(new ShulkerPeekGUI(player, e.getCurrentItem(), owner), true, true);
        }
        catch (AlreadyOpenedException | IsWaitingException | NoPageException ex) {
            throw new RuntimeException(ex);
        }
    }
}

