/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public interface InventoryMask {
    public void setItem(int var1, @Nullable ItemStack var2);

    @Nullable
    public ItemStack getItem(int var1);

    default public void update(int slot) {
        this.setItem(slot, this.getItem(slot));
    }

    @NotNull
    public Object getHolder();

    default public boolean equals(@Nullable Inventory inventory) {
        Object holder = this.getHolder();
        if (holder instanceof Inventory) {
            return holder.equals(inventory);
        }
        return false;
    }

    @NotNull
    public static InventoryMask of(final @NotNull Inventory inventory) {
        return new InventoryMask(){

            @Override
            public void setItem(int slot, @Nullable ItemStack item) {
                inventory.setItem(slot, item);
            }

            @Override
            @Nullable
            public ItemStack getItem(int slot) {
                return inventory.getItem(slot);
            }

            @Override
            @NotNull
            public Object getHolder() {
                return inventory;
            }
        };
    }
}

