/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade.gui;

import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.utils.Value;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.gui.InventoryMask;
import de.codingair.tradesystem.spigot.utils.EntityItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Actions {
    public static boolean projectResult(@NotNull InventoryDragEvent event, @NotNull Configuration configuration) {
        int topSize = event.getView().getTopInventory().getSize();
        boolean onlyInBottom = event.getRawSlots().stream().allMatch(i -> i >= topSize);
        if (onlyInBottom) {
            return false;
        }
        List<Integer> targetSlots = configuration.targetSlots.apply((InventoryInteractEvent)event);
        boolean invalidSlot = event.getRawSlots().stream().anyMatch(i -> i < topSize && !targetSlots.contains(i));
        if (invalidSlot) {
            event.setCancelled(true);
            return false;
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry e : event.getNewItems().entrySet()) {
            if ((Integer)e.getKey() >= topSize) continue;
            slots.add((Integer)e.getKey());
            items.add((ItemStack)e.getValue());
        }
        if (!configuration.isItemAllowedInInventory.apply(items, slots).booleanValue()) {
            event.setCancelled(true);
            return false;
        }
        for (Map.Entry e : event.getNewItems().entrySet()) {
            InventoryMask inventory = configuration.inventoryMapper.apply((InventoryInteractEvent)event, (Integer)e.getKey());
            if (inventory.equals(event.getView().getTopInventory())) continue;
            inventory.setItem(configuration.slotMapper.apply((Integer)e.getKey() % topSize), (ItemStack)e.getValue());
        }
        return event.getRawSlots().stream().anyMatch(i -> i < topSize);
    }

    public static boolean projectResult(@NotNull InventoryClickEvent event, @NotNull Configuration configuration) {
        int slot = configuration.slotMapper.apply(event.getSlot());
        InventoryMask inventory = configuration.inventoryMapper.apply((InventoryInteractEvent)event, event.getSlot());
        switch (event.getAction()) {
            case NOTHING: 
            case UNKNOWN: {
                break;
            }
            case PICKUP_ONE: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case PICKUP_ALL: {
                return Actions.handlePickUp(event, inventory, slot, configuration);
            }
            case PLACE_ONE: 
            case PLACE_SOME: 
            case PLACE_ALL: {
                return Actions.handlePlace(event, inventory, slot, configuration);
            }
            case DROP_ALL_CURSOR: 
            case DROP_ONE_CURSOR: 
            case DROP_ALL_SLOT: 
            case DROP_ONE_SLOT: {
                return Actions.handleDrop(event, inventory, slot, configuration);
            }
            case COLLECT_TO_CURSOR: {
                return Actions.handleCollect(event, inventory, configuration);
            }
            case HOTBAR_MOVE_AND_READD: 
            case HOTBAR_SWAP: {
                return Actions.handleSwap(event, inventory, slot, configuration);
            }
            case MOVE_TO_OTHER_INVENTORY: {
                return Actions.handleMove(event, inventory, slot, configuration);
            }
            case CLONE_STACK: {
                Actions.handleClone(event, inventory, slot);
                break;
            }
            case SWAP_WITH_CURSOR: {
                return Actions.handleExchange(event, inventory, slot, configuration);
            }
        }
        return false;
    }

    private static boolean handlePickUp(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack currentItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        boolean changed = false;
        switch (event.getAction()) {
            case PICKUP_SOME: 
            case PICKUP_ALL: {
                if (Actions.nullOrAir(currentItem)) break;
                ItemStack cursor = event.getCursor();
                if (Actions.nullOrAir(cursor)) {
                    event.getView().setCursor(currentItem);
                    if (topInventory) {
                        inventory.setItem(slot, null);
                        changed = true;
                        break;
                    }
                    event.setCurrentItem(null);
                    break;
                }
                if (!cursor.isSimilar(currentItem) || !Actions.place(cursor, currentItem, cursor.getMaxStackSize() - cursor.getAmount()) || currentItem.getAmount() != 0) break;
                if (topInventory) {
                    inventory.setItem(slot, null);
                    changed = true;
                    break;
                }
                event.setCurrentItem(null);
                break;
            }
            case PICKUP_HALF: {
                if (Actions.nullOrAir(currentItem)) break;
                ItemStack copy = currentItem.clone();
                copy.setAmount((int)Math.ceil((float)copy.getAmount() / 2.0f));
                currentItem.setAmount(currentItem.getAmount() - copy.getAmount());
                if (currentItem.getAmount() == 0) {
                    if (topInventory) {
                        inventory.setItem(slot, null);
                    } else {
                        event.setCurrentItem(null);
                    }
                }
                event.getView().setCursor(copy);
                changed = topInventory;
                break;
            }
            case PICKUP_ONE: {
                if (Actions.nullOrAir(currentItem)) break;
                if (currentItem.getAmount() == 1) {
                    event.getView().setCursor(currentItem);
                    if (topInventory) {
                        inventory.setItem(slot, null);
                        changed = true;
                        break;
                    }
                    event.setCurrentItem(null);
                    break;
                }
                ItemStack copy = currentItem.clone();
                copy.setAmount(1);
                event.getView().setCursor(copy);
                currentItem.setAmount(currentItem.getAmount() - 1);
                changed = topInventory;
            }
        }
        if (changed) {
            inventory.update(slot);
        }
        return changed;
    }

    private static boolean handlePlace(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack currentItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        boolean changed = false;
        switch (event.getAction()) {
            case PLACE_SOME: 
            case PLACE_ALL: {
                ItemStack cursor = event.getView().getCursor();
                if (Actions.nullOrAir(cursor) || topInventory && !configuration.isItemAllowedInInventory.apply(Collections.singletonList(cursor), Collections.singletonList(event.getSlot())).booleanValue()) break;
                if (!Actions.nullOrAir(currentItem)) {
                    if (!cursor.isSimilar(currentItem) || !Actions.place(currentItem, cursor, cursor.getAmount())) break;
                    if (cursor.getAmount() == 0) {
                        event.getView().setCursor(null);
                    }
                    changed = topInventory;
                    break;
                }
                if (topInventory) {
                    inventory.setItem(slot, cursor);
                    changed = true;
                } else {
                    event.setCurrentItem(cursor);
                }
                event.getView().setCursor(null);
                break;
            }
            case PLACE_ONE: {
                ItemStack cursor = event.getView().getCursor();
                if (Actions.nullOrAir(cursor) || topInventory && !configuration.isItemAllowedInInventory.apply(Collections.singletonList(cursor), Collections.singletonList(event.getSlot())).booleanValue()) break;
                if (!Actions.nullOrAir(currentItem)) {
                    if (!cursor.isSimilar(currentItem) || !Actions.place(currentItem, cursor, 1)) break;
                    if (cursor.getAmount() == 0) {
                        event.getView().setCursor(null);
                    }
                    changed = topInventory;
                    break;
                }
                ItemStack copy = cursor.clone();
                cursor.setAmount(cursor.getAmount() - 1);
                copy.setAmount(1);
                if (cursor.getAmount() == 0) {
                    event.getView().setCursor(null);
                }
                if (topInventory) {
                    inventory.setItem(slot, copy);
                    changed = true;
                    break;
                }
                event.setCurrentItem(copy);
                break;
            }
        }
        if (changed) {
            inventory.update(slot);
        }
        return changed;
    }

    private static boolean handleDrop(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack currentItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        Value<Boolean> hasBeenDropped = new Value<Boolean>(false);
        Function<Item, Boolean> accessor = dropped -> {
            PlayerDropItemEvent dropEvent = new PlayerDropItemEvent((Player)event.getWhoClicked(), dropped);
            Bukkit.getPluginManager().callEvent((Event)dropEvent);
            if (dropEvent.isCancelled()) {
                dropped.remove();
                return false;
            }
            switch (event.getAction()) {
                case DROP_ALL_CURSOR: {
                    ItemStack item = event.getCursor();
                    if (Actions.nullOrAir(item)) break;
                    event.getView().setCursor(null);
                    break;
                }
                case DROP_ONE_CURSOR: {
                    ItemStack item = event.getCursor();
                    if (Actions.nullOrAir(item)) break;
                    ItemStack copy = item.clone();
                    copy.setAmount(1);
                    item.setAmount(item.getAmount() - 1);
                    if (item.getAmount() != 0) break;
                    event.getView().setCursor(null);
                    break;
                }
                case DROP_ALL_SLOT: {
                    if (Actions.nullOrAir(currentItem)) break;
                    if (topInventory) {
                        inventory.setItem(slot, null);
                        break;
                    }
                    event.setCurrentItem(null);
                    break;
                }
                case DROP_ONE_SLOT: {
                    if (Actions.nullOrAir(currentItem)) break;
                    ItemStack copy = currentItem.clone();
                    copy.setAmount(1);
                    currentItem.setAmount(currentItem.getAmount() - 1);
                    if (currentItem.getAmount() != 0) break;
                    if (topInventory) {
                        inventory.setItem(slot, null);
                        break;
                    }
                    event.setCurrentItem(null);
                    break;
                }
            }
            hasBeenDropped.setValue(true);
            return true;
        };
        switch (event.getAction()) {
            case DROP_ALL_CURSOR: {
                ItemStack item = event.getCursor();
                if (Actions.nullOrAir(item)) break;
                Actions.dropItem((Player)event.getWhoClicked(), item, accessor);
                break;
            }
            case DROP_ONE_CURSOR: {
                ItemStack item = event.getCursor();
                if (Actions.nullOrAir(item)) break;
                ItemStack copy = item.clone();
                copy.setAmount(1);
                Actions.dropItem((Player)event.getWhoClicked(), copy, accessor);
                break;
            }
            case DROP_ALL_SLOT: {
                if (Actions.nullOrAir(currentItem)) break;
                Actions.dropItem((Player)event.getWhoClicked(), currentItem, accessor);
                break;
            }
            case DROP_ONE_SLOT: {
                if (Actions.nullOrAir(currentItem)) break;
                ItemStack copy = currentItem.clone();
                copy.setAmount(1);
                Actions.dropItem((Player)event.getWhoClicked(), copy, accessor);
                break;
            }
            default: {
                return false;
            }
        }
        if (!hasBeenDropped.getValue().booleanValue()) {
            return false;
        }
        if (topInventory) {
            inventory.update(slot);
        }
        return topInventory;
    }

    private static boolean handleCollect(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, @NotNull Configuration configuration) {
        boolean bottomInventory;
        if (Actions.nullOrAir(event.getCursor())) {
            return false;
        }
        ItemStack cursor = event.getCursor();
        List<Integer> target = new ArrayList<Integer>();
        for (Integer slot : configuration.targetSlots.apply((InventoryInteractEvent)event)) {
            target.add(configuration.slotMapper.apply(slot));
        }
        Actions.sortByAmount(cursor, target, inventory);
        boolean changed = false;
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory || configuration.collectFromBothInventories) {
            int slot;
            Iterator iterator = target.iterator();
            while (iterator.hasNext() && !Actions.collectTo(inventory, slot = ((Integer)iterator.next()).intValue(), cursor)) {
                changed = true;
            }
        }
        if ((bottomInventory = event.getView().getBottomInventory().equals((Object)event.getClickedInventory())) || configuration.collectFromBothInventories) {
            int slot;
            Inventory bottom = event.getView().getBottomInventory();
            InventoryMask mask = InventoryMask.of(bottom);
            target = IntStream.range(0, bottom.getSize()).boxed().collect(Collectors.toList());
            Actions.sortByAmount(cursor, target, mask);
            Iterator<Integer> iterator = target.iterator();
            while (iterator.hasNext() && !Actions.collectTo(mask, slot = iterator.next().intValue(), cursor)) {
            }
        }
        if (changed) {
            target.forEach(inventory::update);
        }
        return changed;
    }

    private static void sortByAmount(@NotNull ItemStack cursor, @NotNull List<Integer> target, @NotNull InventoryMask inventory) {
        target.sort((slot1, slot2) -> {
            ItemStack item1 = inventory.getItem((int)slot1);
            ItemStack item2 = inventory.getItem((int)slot2);
            int amount1 = item1 != null && item1.isSimilar(cursor) ? item1.getAmount() : 0;
            int amount2 = item2 != null && item2.isSimilar(cursor) ? item2.getAmount() : 0;
            return Integer.compare(amount1, amount2);
        });
    }

    private static boolean handleSwap(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack currentItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        int switchTo = event.getHotbarButton();
        ItemStack switched = event.getView().getBottomInventory().getItem(switchTo);
        boolean changed = false;
        if (topInventory && switched != null && !configuration.isItemAllowedInInventory.apply(Collections.singletonList(switched), Collections.singletonList(event.getSlot())).booleanValue()) {
            return false;
        }
        if (Objects.equals(currentItem, switched)) {
            return false;
        }
        if (topInventory) {
            inventory.setItem(slot, switched);
            changed = true;
        } else {
            event.setCurrentItem(switched);
        }
        event.getView().getBottomInventory().setItem(switchTo, currentItem);
        return changed;
    }

    private static boolean handleMove(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        ItemStack clickedItem;
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack itemStack = clickedItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        if (Actions.nullOrAir(clickedItem)) {
            return false;
        }
        if (!topInventory && !configuration.isItemAllowedInInventory.apply(Collections.singletonList(clickedItem), Collections.singletonList(event.getRawSlot())).booleanValue()) {
            return false;
        }
        boolean changed = false;
        if (topInventory) {
            int amountBefore = clickedItem.getAmount();
            ItemStack left = event.getView().getBottomInventory().addItem(new ItemStack[]{clickedItem}).values().stream().findAny().orElse(null);
            if (Actions.nullOrAir(left)) {
                inventory.setItem(slot, null);
                changed = true;
            } else if (left.getAmount() != amountBefore) {
                changed = true;
            }
        } else {
            List<Integer> targetSlots = configuration.targetSlots.apply((InventoryInteractEvent)event);
            int freeSlot = -1;
            for (int currentSlot : targetSlots) {
                ItemStack current = inventory.getItem(currentSlot = configuration.slotMapper.apply(currentSlot).intValue());
                if (Actions.nullOrAir(current) && freeSlot == -1) {
                    freeSlot = currentSlot;
                }
                if (Actions.nullOrAir(current) || !current.isSimilar(clickedItem)) continue;
                changed = true;
                boolean fullyMerged = Actions.transferAmount(current, clickedItem);
                inventory.update(currentSlot);
                if (!fullyMerged) continue;
                event.setCurrentItem(null);
                return changed;
            }
            if (freeSlot >= 0) {
                inventory.setItem(freeSlot, clickedItem);
                event.setCurrentItem(null);
                changed = true;
            } else if (clickedItem.getAmount() <= 0) {
                event.setCurrentItem(null);
            }
        }
        return changed;
    }

    private static void handleClone(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot) {
        ItemStack clickedItem;
        if (event.getWhoClicked().getGameMode() != GameMode.CREATIVE && event.getWhoClicked().getGameMode() != GameMode.SPECTATOR) {
            return;
        }
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        ItemStack itemStack = clickedItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        if (Actions.nullOrAir(clickedItem)) {
            return;
        }
        ItemStack copy = clickedItem.clone();
        copy.setAmount(copy.getMaxStackSize());
        event.getView().setCursor(copy);
    }

    private static boolean handleExchange(@NotNull InventoryClickEvent event, @NotNull InventoryMask inventory, int slot, @NotNull Configuration configuration) {
        boolean topInventory = event.getView().getTopInventory().equals((Object)event.getClickedInventory());
        if (topInventory && !configuration.targetSlots.apply((InventoryInteractEvent)event).contains(event.getRawSlot())) {
            return false;
        }
        ItemStack clickedItem = topInventory ? inventory.getItem(slot) : event.getCurrentItem();
        boolean changed = false;
        ItemStack cursor = event.getCursor();
        if (topInventory && cursor != null && !configuration.isItemAllowedInInventory.apply(Collections.singletonList(cursor), Collections.singletonList(event.getSlot())).booleanValue()) {
            return false;
        }
        if (topInventory) {
            inventory.setItem(slot, cursor);
            changed = true;
        } else {
            event.setCurrentItem(cursor);
        }
        event.getView().setCursor(clickedItem);
        return changed;
    }

    private static boolean collectTo(@NotNull InventoryMask inventory, int slot, @NotNull ItemStack to) {
        ItemStack from = inventory.getItem(slot);
        if (from != null && to.isSimilar(from)) {
            int amount = to.getAmount();
            if (amount < to.getMaxStackSize()) {
                if (Actions.transferAmount(to, from)) {
                    inventory.setItem(slot, null);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static boolean transferAmount(@NotNull ItemStack to, @NotNull ItemStack from) {
        int space = to.getMaxStackSize() - to.getAmount();
        if (from.getAmount() > space) {
            from.setAmount(from.getAmount() - space);
            to.setAmount(to.getMaxStackSize());
            return false;
        }
        to.setAmount(to.getAmount() + from.getAmount());
        return true;
    }

    private static boolean place(@NotNull ItemStack to, @NotNull ItemStack from, int place) {
        int max = to.getMaxStackSize();
        int amount = to.getAmount();
        int cursorAmount = from.getAmount();
        int move = Math.min(place, cursorAmount);
        if (max == amount) {
            return false;
        }
        if (amount + move <= max) {
            to.setAmount(amount + move);
            from.setAmount(cursorAmount - move);
        } else {
            to.setAmount(max);
            from.setAmount(amount + cursorAmount - max);
        }
        return true;
    }

    private static void dropItem(@NotNull Player player, @NotNull ItemStack item, @NotNull Function<Item, Boolean> access) {
        if (Version.atLeast(17.0)) {
            player.getWorld().dropItem(player.getEyeLocation(), item, i -> {
                i.setVelocity(player.getEyeLocation().getDirection().multiply(0.3));
                i.setPickupDelay(40);
                boolean spawn = (Boolean)access.apply((Item)i);
                if (!spawn) {
                    i.remove();
                }
            });
        } else {
            Item dummy = EntityItemUtils.create(player.getEyeLocation(), item);
            boolean spawn = access.apply(dummy);
            if (spawn) {
                Item i2 = player.getWorld().dropItem(player.getEyeLocation(), item);
                i2.setVelocity(player.getEyeLocation().getDirection().multiply(0.3));
                i2.setPickupDelay(40);
            }
        }
    }

    private static boolean nullOrAir(@Nullable ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static class Configuration {
        @NotNull
        public Function<Integer, Integer> slotMapper;
        @NotNull
        public Function<InventoryInteractEvent, List<Integer>> targetSlots;
        @NotNull
        public BiFunction<InventoryInteractEvent, Integer, InventoryMask> inventoryMapper;
        public boolean collectFromBothInventories;
        @NotNull
        public BiFunction<List<ItemStack>, List<Integer>, Boolean> isItemAllowedInInventory;

        public Configuration(@NotNull Function<Integer, Integer> slotMapper, @NotNull Function<InventoryInteractEvent, List<Integer>> targetSlots, @NotNull BiFunction<InventoryInteractEvent, Integer, InventoryMask> inventoryMapper, boolean collectFromBothInventories, @NotNull BiFunction<List<ItemStack>, List<Integer>, Boolean> isItemAllowedInInventory) {
            this.slotMapper = slotMapper;
            this.targetSlots = targetSlots;
            this.inventoryMapper = inventoryMapper;
            this.collectFromBothInventories = collectFromBothInventories;
            this.isItemAllowedInInventory = isItemAllowedInInventory;
        }

        @NotNull
        public static Configuration DEFAULT() {
            return new Configuration(Function.identity(), e -> IntStream.range(0, e.getView().getTopInventory().getSize()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll), (e, slot) -> InventoryMask.of(e.getView().getTopInventory()), true, (item, slot) -> true);
        }
    }
}

