/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class TradeResult {
    protected final UUID playerId;
    protected final String playerWorld;
    protected final String playerServer;
    protected final Perspective perspective;
    protected final List<ItemStack> receivingItems = new ArrayList<ItemStack>();
    protected final List<ItemStack> sendingItems = new ArrayList<ItemStack>();
    protected final List<EconomyIcon<?>> economyIcons = new ArrayList();

    public TradeResult(@NotNull UUID playerId, @NotNull String playerWorld, @Nullable String playerServer, @NotNull Perspective perspective) {
        this.playerId = playerId;
        this.playerWorld = playerWorld;
        this.playerServer = playerServer;
        this.perspective = perspective;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getPlayerWorld() {
        return this.playerWorld;
    }

    @Nullable
    public String getPlayerServer() {
        return this.playerServer;
    }

    @NotNull
    public Perspective getPerspective() {
        return this.perspective;
    }

    @NotNull
    public List<ItemStack> getReceivingItems() {
        return this.receivingItems;
    }

    @NotNull
    public List<ItemStack> getSendingItems() {
        return this.sendingItems;
    }

    @NotNull
    public List<EconomyIcon<?>> getEconomyIcons() {
        return this.economyIcons;
    }

    void add(@Nullable ItemStack item, boolean receive) {
        if (item == null) {
            return;
        }
        if (receive) {
            this.receivingItems.add(item.clone());
        } else {
            this.sendingItems.add(item.clone());
        }
    }

    void add(@Nullable TradeIcon icon) {
        if (icon == null) {
            return;
        }
        if (icon instanceof EconomyIcon) {
            this.addEconomyIcon((EconomyIcon)icon);
        }
    }

    private void addEconomyIcon(@NotNull EconomyIcon<?> economyIcon) {
        this.economyIcons.add(economyIcon);
    }
}

