/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import de.codingair.tradesystem.lib.codingapi.server.sounds.Sound;
import de.codingair.tradesystem.lib.codingapi.server.sounds.SoundData;
import de.codingair.tradesystem.lib.codingapi.tools.io.JSON.JSON;
import de.codingair.tradesystem.lib.codingapi.tools.io.lib.JSONArray;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.proxy.packets.PlayerStatePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeOfferItemEvent;
import de.codingair.tradesystem.spigot.events.TradeToggleEvent;
import de.codingair.tradesystem.spigot.extras.blacklist.BlockedItem;
import de.codingair.tradesystem.spigot.extras.bstats.MetricsManager;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogService;
import de.codingair.tradesystem.spigot.trade.BukkitTrade;
import de.codingair.tradesystem.spigot.trade.ProxyTrade;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.managers.InvitationManager;
import de.codingair.tradesystem.spigot.transfer.utils.ItemStackUtils;
import de.codingair.tradesystem.spigot.utils.InputGUI;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.lang.reflect.MalformedParametersException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class TradeHandler {
    private final Set<String> offline = new HashSet<String>();
    private boolean tradeProxy = false;
    private final HashMap<String, Trade> trades = new HashMap();
    private final List<BlockedItem> blacklist = new ArrayList<BlockedItem>();
    private final InvitationManager invitationManager = new InvitationManager();
    private int requestExpirationTime = 60;
    private int distance = 50;
    private DecimalFormat moneyPattern;
    private final HashMap<String, BigDecimal> moneyShortcuts = new HashMap();
    private int countdownRepetitions = 0;
    private int countdownInterval = 0;
    private boolean cancelOnDamage = true;
    private boolean revokeReadyOnChange = true;
    private boolean requestOnShiftRightclick = false;
    private List<String> allowedGameModes = new ArrayList<String>();
    private List<String> blockedWorlds;
    private boolean tradeReportItems = true;
    private boolean tradeReportEconomy = true;
    private InputGUI inputGUI = InputGUI.SIGN;
    private boolean tradeBoth = true;
    private boolean dropItems = true;
    private boolean onlyDisplayNameInMessage = false;
    private SoundData soundStarted = null;
    private SoundData soundFinish = null;
    private SoundData soundCancel = null;
    private SoundData soundBlocked = null;
    private SoundData soundRequest = null;
    private SoundData soundCountdownTick = null;
    private SoundData soundCountdownStop = null;
    private SoundData soundChangeDuringShulkerPeek = null;

    public void load() {
        List data;
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
        YamlConfiguration config = file.getConfig();
        boolean save = false;
        this.tradeProxy = config.getBoolean("TradeSystem.TradeProxy", false);
        this.requestExpirationTime = config.getInt("TradeSystem.Trade_Request_Expiration_Time", 60);
        if (this.requestExpirationTime < 5) {
            this.requestExpirationTime = 5;
            config.set("TradeSystem.Trade_Request_Expiration_Time", (Object)5);
            save = true;
        }
        if (config.getBoolean("TradeSystem.Trade_Distance.enabled", true)) {
            this.distance = config.getInt("TradeSystem.Trade_Distance.distance_in_blocks", 50);
            if (this.distance < 1) {
                config.set("TradeSystem.Trade.distance_in_blocks", (Object)1);
                save = true;
            }
        } else {
            this.distance = -1;
        }
        this.cancelOnDamage = config.getBoolean("TradeSystem.Action_To_Cancel.Player_get_damaged", true);
        this.revokeReadyOnChange = config.getBoolean("TradeSystem.Revoke_Ready_State_on_Offer_Change", true);
        this.requestOnShiftRightclick = config.getBoolean("TradeSystem.Action_To_Request.Shift_Rightclick", false);
        this.tradeBoth = config.getBoolean("TradeSystem.Trade_Both", true);
        this.inputGUI = InputGUI.getByName(config.getString("TradeSystem.Input_GUI", "SIGN"));
        this.dropItems = config.getBoolean("TradeSystem.Trade_Drop_Items", true);
        this.tradeReportItems = config.getBoolean("TradeSystem.Trade_Finish_Report.Items", true);
        this.tradeReportEconomy = config.getBoolean("TradeSystem.Trade_Finish_Report.Economy", true);
        this.onlyDisplayNameInMessage = config.getBoolean("TradeSystem.Trade_Finish_Report.Display_Name_Only", false);
        if (config.getBoolean("TradeSystem.Trade_Countdown.Enabled", true)) {
            this.countdownRepetitions = config.getInt("TradeSystem.Trade_Countdown.Repetitions");
            this.countdownInterval = config.getInt("TradeSystem.Trade_Countdown.Interval");
        } else {
            this.countdownInterval = 0;
            this.countdownRepetitions = 0;
        }
        String pattern = config.getString("TradeSystem.Money.Pattern", "###,###.####");
        try {
            this.moneyPattern = new DecimalFormat(pattern);
        }
        catch (IllegalArgumentException ex) {
            TradeSystem.getInstance().getLogger().warning("The money pattern '%s' is invalid. Please check your syntax. The pattern '###,###.####' will be used instead.");
            this.moneyPattern = new DecimalFormat("###,###.####");
        }
        this.moneyPattern.setParseBigDecimal(true);
        this.moneyPattern.setRoundingMode(RoundingMode.FLOOR);
        String groupingSeparator = config.getString("TradeSystem.Money.Grouping_Separator", ",");
        String decimalSeparator = config.getString("TradeSystem.Money.Decimal_Separator", ".");
        if (groupingSeparator.length() != 1) {
            TradeSystem.getInstance().getLogger().warning("The grouping separator must be a single character. Please check your syntax. The separator ',' will be used instead.");
            groupingSeparator = ",";
        }
        if (decimalSeparator.length() != 1) {
            TradeSystem.getInstance().getLogger().warning("The decimal separator must be a single character. Please check your syntax. The separator '.' will be used instead.");
            decimalSeparator = ".";
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator.charAt(0));
        symbols.setGroupingSeparator(groupingSeparator.charAt(0));
        this.moneyPattern.setDecimalFormatSymbols(symbols);
        this.moneyShortcuts.clear();
        if (config.getBoolean("TradeSystem.Money.Easy_Selection.Enabled", true) && (data = config.getList("TradeSystem.Money.Easy_Selection.Shortcuts")) != null) {
            for (Object s : data) {
                if (!(s instanceof Map)) continue;
                try {
                    JSONArray a;
                    BigDecimal value;
                    JSON json = new JSON((Map)s);
                    Object number = json.getRaw("Value");
                    if (number == null || (value = new BigDecimal(number.toString())).signum() <= 0 || (a = json.getList("Keys")) == null) continue;
                    for (Object o : a) {
                        String key = ((String)o).trim().toLowerCase();
                        this.moneyShortcuts.put(key, value);
                    }
                }
                catch (Exception e) {
                    throw new MalformedParametersException("Malformed money selection for input: '" + s + "'");
                }
            }
        }
        TradeSystem.log("  > Loading sounds");
        this.soundStarted = this.getSound("Trade_Started", (FileConfiguration)config, "LEVEL_UP");
        if (this.soundStarted == null) {
            TradeSystem.log("    > No start sound detected (maybe a spelling mistake?)");
        }
        this.soundFinish = this.getSound("Trade_Finished", (FileConfiguration)config, "LEVEL_UP");
        if (this.soundFinish == null) {
            TradeSystem.log("    > No finish sound detected (maybe a spelling mistake?)");
        }
        this.soundBlocked = this.getSound("Trade_Blocked", (FileConfiguration)config, "NOTE_BASS");
        if (this.soundBlocked == null) {
            TradeSystem.log("    > No itemBlocked sound detected (maybe a spelling mistake?)");
        }
        this.soundCancel = this.getSound("Trade_Cancelled", (FileConfiguration)config, "ITEM_BREAK");
        if (this.soundCancel == null) {
            TradeSystem.log("    > No cancel sound detected (maybe a spelling mistake?)");
        }
        this.soundRequest = this.getSound("Trade_Request", (FileConfiguration)config, "ORB_PICKUP");
        if (this.soundRequest == null) {
            TradeSystem.log("    > No request sound detected (maybe a spelling mistake?)");
        }
        this.soundCountdownTick = this.getSound("Countdown_Tick", (FileConfiguration)config, "ORB_PICKUP");
        if (this.soundCountdownTick == null) {
            TradeSystem.log("    > No countdown tick sound detected (maybe a spelling mistake?)");
        }
        this.soundCountdownStop = this.getSound("Countdown_Stop", (FileConfiguration)config, "ITEM_BREAK");
        if (this.soundCountdownStop == null) {
            TradeSystem.log("    > No countdown stop sound detected (maybe a spelling mistake?)");
        }
        this.soundChangeDuringShulkerPeek = this.getSound("Change_during_Shulker_Peek", (FileConfiguration)config, "ITEM_BREAK");
        if (this.soundChangeDuringShulkerPeek == null) {
            TradeSystem.log("    > No change-during-shulker-peek sound detected (maybe a spelling mistake?)");
        }
        if (this.allowedGameModes != null) {
            this.allowedGameModes.clear();
        }
        this.allowedGameModes = config.getStringList("TradeSystem.Allowed_GameModes");
        if (this.blockedWorlds != null) {
            this.blockedWorlds.clear();
        }
        this.blockedWorlds = config.getStringList("TradeSystem.Blocked_Worlds");
        TradeSystem.log("  > Loading blacklist");
        List l = config.getList("TradeSystem.Blacklist");
        if (l != null) {
            for (Object o : l) {
                BlockedItem item;
                if (o instanceof Map) {
                    try {
                        item = BlockedItem.create((Map)o);
                        this.blacklist.add(item);
                    }
                    catch (Exception ex) {
                        TradeSystem.log("    ...could not deserialize blocked item: " + o + ". Skipping...");
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (o instanceof String) {
                    item = BlockedItem.fromString((String)o);
                    if (item != null) {
                        this.blacklist.add(item);
                        continue;
                    }
                    TradeSystem.log("    ...found a wrong Material-Tag (here: \"" + o + "\"). Skipping...");
                    continue;
                }
                TradeSystem.log("    ...could not deserialize blocked item: " + o + ". Skipping...");
            }
        }
        if (this.blacklist.isEmpty()) {
            this.blacklist.add(BlockedItem.create().material(Material.AIR));
            this.blacklist.add(BlockedItem.create().material(Material.AIR).displayName("&cExample"));
            this.blacklist.add(BlockedItem.create().displayName("&cExample, which blocks all items with this strange name!"));
            this.saveBlackList();
        }
        TradeSystem.log("    ...got " + this.blacklist.size() + " blocked item(s)");
        if (save) {
            file.saveConfig();
        }
        this.invitationManager.startExpirationHandler();
    }

    public void disable() {
        this.cancelAll();
        this.invitationManager.stopExpirationHandler();
    }

    private SoundData getSound(String name, FileConfiguration config, String def) {
        try {
            String sound = config.getString("TradeSystem.Sounds." + name + ".Name", def);
            assert (sound != null);
            Optional<Sound> opt = Sound.matchXSound(sound);
            return opt.map(value -> new SoundData((Sound)((Object)value), (float)config.getDouble("TradeSystem.Sounds." + name + ".Volume", 0.6), (float)config.getDouble("TradeSystem.Sounds." + name + ".Pitch", 1.0))).orElse(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void playRequestSound(Player player) {
        if (this.soundRequest != null) {
            this.soundRequest.play(player);
        }
    }

    public void playStartSound(Player player) {
        if (this.soundStarted != null) {
            this.soundStarted.play(player);
        }
    }

    public void playFinishSound(Player player) {
        if (this.soundFinish != null) {
            this.soundFinish.play(player);
        }
    }

    public void playBlockSound(Player player) {
        if (this.soundBlocked != null) {
            this.soundBlocked.play(player);
        }
    }

    public void playCancelSound(Player player) {
        if (this.soundCancel != null) {
            this.soundCancel.play(player);
        }
    }

    public void playCountdownTickSound(Player player) {
        if (this.soundCountdownTick != null) {
            this.soundCountdownTick.play(player);
        }
    }

    public void playCountdownStopSound(Player player) {
        if (this.soundCountdownStop != null) {
            this.soundCountdownStop.play(player);
        }
    }

    public void playChangeDuringShulkerPeekSound(Player player) {
        if (this.soundChangeDuringShulkerPeek != null) {
            this.soundChangeDuringShulkerPeek.play(player);
        }
    }

    public void saveBlackList() {
        ConfigFile file = TradeSystem.getInstance().getFileManager().getFile("Config");
        YamlConfiguration config = file.getConfig();
        ArrayList<JSON> l = new ArrayList<JSON>();
        for (BlockedItem block : this.blacklist) {
            JSON json = new JSON();
            block.write(json);
            l.add(json);
        }
        config.set("TradeSystem.Blacklist", l);
        file.saveConfig();
    }

    public void startTrade(@NotNull Player player, @NotNull Player other) {
        this.startTrade(player, other, other.getName(), other.getUniqueId(), other.getWorld().getName(), null, true);
    }

    public void startTrade(@NotNull Player player, @NotNull String othersName, @NotNull UUID otherId, @NotNull String otherWorld, @NotNull String otherServer, boolean initiationServer) {
        this.startTrade(player, null, othersName, otherId, otherWorld, otherServer, initiationServer);
    }

    private void startTrade(@NotNull Player player, @Nullable Player other, @NotNull String othersName, @NotNull UUID otherId, @NotNull String otherWorld, @Nullable String otherServer, boolean initiationServer) {
        if (TradeSystem.handler().isTrading(player) || TradeSystem.handler().isTrading(other)) {
            Lang.send((CommandSender)player, "Other_is_already_trading", new Lang.P[0]);
            return;
        }
        ++MetricsManager.TRADES;
        player.closeInventory();
        if (other != null) {
            other.closeInventory();
        }
        Trade trade = this.createTrade(player, other, othersName, otherId, otherWorld, otherServer, initiationServer);
        if (initiationServer) {
            TradeLogService.log(player.getName(), othersName, TradeLog.STARTED.get(new Object[0]));
        }
        this.registerTrade(trade, player.getName());
        this.registerTrade(trade, othersName);
        trade.start();
    }

    private void registerTrade(@NotNull Trade trade, @NotNull String player) {
        this.trades.put(player.toLowerCase(), trade);
    }

    public void unregisterTrade(@NotNull String player) {
        this.trades.remove(player.toLowerCase());
    }

    @NotNull
    private Trade createTrade(Player player, @Nullable Player other, @NotNull String name, @NotNull UUID otherId, @NotNull String otherWorld, @Nullable String otherServer, boolean initiationServer) {
        if (other != null) {
            return new BukkitTrade(player, other, initiationServer);
        }
        if (otherServer == null) {
            throw new IllegalArgumentException("'otherServer' cannot be null when creating a ProxyTrade");
        }
        return new ProxyTrade(player, name, otherId, initiationServer, otherWorld, otherServer);
    }

    public void quit(Player player) {
        Trade activeTrade = this.getTrade(player);
        if (activeTrade != null) {
            activeTrade.cancel();
        }
    }

    private void cancelAll() {
        TradeSystem.log("  > Cancelling all active trades");
        ArrayList<Trade> tradeList = new ArrayList<Trade>(this.trades.values());
        for (Trade trade : tradeList) {
            trade.cancel();
        }
        tradeList.clear();
        TradeSystem.invitations().clear();
    }

    public Trade getTrade(Player player) {
        return this.getTrade(player.getName());
    }

    public Trade getTrade(String player) {
        return this.trades.get(player.toLowerCase());
    }

    public boolean isTrading(Player player) {
        if (player == null) {
            return false;
        }
        return this.getTrade(player) != null;
    }

    public int getRequestExpirationTime() {
        return this.requestExpirationTime;
    }

    public int getDistance() {
        return this.distance;
    }

    public boolean isRequestOnShiftRightClick() {
        return this.requestOnShiftRightclick;
    }

    public List<String> getAllowedGameModes() {
        return this.allowedGameModes;
    }

    public boolean isCancelOnDamage() {
        return this.cancelOnDamage;
    }

    public boolean isRevokeReadyOnChange() {
        return this.revokeReadyOnChange;
    }

    public boolean isTradeBoth() {
        return this.tradeBoth;
    }

    public boolean isDropItems() {
        return this.dropItems;
    }

    public void setDropItems(boolean dropItems) {
        this.dropItems = dropItems;
    }

    public boolean isOnlyDisplayNameInMessage() {
        return this.onlyDisplayNameInMessage;
    }

    public boolean isOffline(Player player) {
        return this.offline.contains(player.getName());
    }

    public boolean toggle(Player player) {
        if (this.offline.remove(player.getName())) {
            TradeSystem.proxyHandler().send(new PlayerStatePacket(player.getUniqueId(), player.getName(), false), player);
            Bukkit.getPluginManager().callEvent((Event)new TradeToggleEvent(player.getUniqueId(), player.getName(), false));
            return false;
        }
        this.offline.add(player.getName());
        TradeSystem.proxyHandler().send(new PlayerStatePacket(player.getUniqueId(), player.getName(), true), player);
        Bukkit.getPluginManager().callEvent((Event)new TradeToggleEvent(player.getUniqueId(), player.getName(), true));
        return true;
    }

    public void setState(@NotNull UUID playerId, @NotNull String playerName, boolean online) {
        if (online) {
            if (this.offline.remove(playerName)) {
                Bukkit.getPluginManager().callEvent((Event)new TradeToggleEvent(playerId, playerName, true));
            }
        } else if (this.offline.add(playerName)) {
            Bukkit.getPluginManager().callEvent((Event)new TradeToggleEvent(playerId, playerName, false));
        }
    }

    public List<BlockedItem> getBlacklist() {
        return this.blacklist;
    }

    public boolean isBlocked(@NotNull Trade trade, @NotNull ItemStack item) {
        boolean compatible;
        boolean blacklisted = false;
        if (trade instanceof ProxyTrade && !(compatible = ItemStackUtils.isCompatible(item))) {
            return true;
        }
        for (BlockedItem blocked : this.blacklist) {
            if (!blocked.matches(item)) continue;
            blacklisted = true;
            break;
        }
        return blacklisted;
    }

    public boolean isBlocked(@NotNull Trade trade, @NotNull Player placer, @Nullable Player receivingPlayer, @NotNull String receiver, @NotNull UUID receiverId, @NotNull ItemStack item) {
        boolean blacklisted = this.isBlocked(trade, item);
        TradeOfferItemEvent event = receivingPlayer == null ? new TradeOfferItemEvent(placer, receiver, receiverId, item, blacklisted) : new TradeOfferItemEvent(placer, receivingPlayer, item, blacklisted);
        Bukkit.getPluginManager().callEvent((Event)event);
        blacklisted = event.isCancelled();
        return blacklisted;
    }

    public List<String> getBlockedWorlds() {
        return this.blockedWorlds;
    }

    public boolean isBlockedWorld(World w) {
        if (w == null) {
            return true;
        }
        for (String world : this.blockedWorlds) {
            if (!w.getName().equalsIgnoreCase(world)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BigDecimal getMoneyShortcutFactor(@NotNull String s) {
        String key = s.toLowerCase().replaceAll("[^a-z]", "");
        return this.moneyShortcuts.get(key);
    }

    @Nullable
    public Map.Entry<String, BigDecimal> getApplicableMoneyShortcut(@NotNull BigDecimal d) {
        Map.Entry<String, BigDecimal> highest = null;
        for (Map.Entry<String, BigDecimal> e : this.moneyShortcuts.entrySet()) {
            if (d.compareTo(e.getValue()) < 0 || highest != null && ((BigDecimal)highest.getValue()).compareTo(e.getValue()) >= 0) continue;
            highest = e;
        }
        return highest;
    }

    public int getCountdownRepetitions() {
        return this.countdownRepetitions;
    }

    public int getCountdownInterval() {
        return this.countdownInterval;
    }

    public InvitationManager getInvitationManager() {
        return this.invitationManager;
    }

    public InputGUI getInputGUI() {
        return this.inputGUI;
    }

    public DecimalFormat getMoneyPattern() {
        return this.moneyPattern;
    }

    public boolean isTradeReportItems() {
        return this.tradeReportItems;
    }

    public boolean isTradeReportEconomy() {
        return this.tradeReportEconomy;
    }

    public HashMap<String, Trade> getTrades() {
        return this.trades;
    }

    public boolean tradeProxy() {
        return this.tradeProxy;
    }
}

