/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.PlayerInventory;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.GUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyClosedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.events.TradeFinishEvent;
import de.codingair.tradesystem.spigot.events.TradeItemEvent;
import de.codingair.tradesystem.spigot.events.TradeReportEvent;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLog;
import de.codingair.tradesystem.spigot.extras.tradelog.TradeLogService;
import de.codingair.tradesystem.spigot.trade.PlayerTradeResult;
import de.codingair.tradesystem.spigot.trade.TradeResult;
import de.codingair.tradesystem.spigot.trade.gui.TradingGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.Pattern;
import de.codingair.tradesystem.spigot.trade.gui.layout.TradeLayout;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.EditorInfo;
import de.codingair.tradesystem.spigot.trade.gui.layout.registration.IconHandler;
import de.codingair.tradesystem.spigot.trade.gui.layout.shulker.ShulkerPeekGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.Transition;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.FinishResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.feedback.IconResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.ShowStatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.StatusIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlot;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.basic.TradeSlotOther;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.trade.subscribe.PlayerSubscriber;
import de.codingair.tradesystem.spigot.utils.FloodgateUtils;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Trade {
    protected final String[] names = new String[2];
    protected final boolean initiationServer;
    protected final TradeLayout[] layout = new TradeLayout[2];
    protected final TradingGUI[] guis = new TradingGUI[2];
    protected final List<Integer> slots = new ArrayList<Integer>();
    protected final List<Integer> otherSlots = new ArrayList<Integer>();
    private final Set<Runnable> subscribers = new HashSet<Runnable>();
    protected final boolean[] ready = new boolean[]{false, false};
    protected final boolean[] pause = new boolean[]{false, false};
    protected Pattern pattern;
    protected Listener pickupListener;
    protected BukkitRunnable countdown = null;
    protected int countdownTicks = 0;
    protected boolean cancelling = false;

    protected Trade(String player0, String player1, boolean initiationServer) {
        this.initiationServer = initiationServer;
        this.names[0] = player0;
        this.names[1] = player1;
    }

    protected abstract void initializeGUIs();

    protected abstract void createGUIs();

    protected abstract void startGUIs();

    @Nullable
    public abstract Player getPlayer(@NotNull Perspective var1);

    @NotNull
    public abstract String getWorld(@NotNull Perspective var1);

    @Nullable
    public abstract String getServer(@NotNull Perspective var1);

    @NotNull
    public abstract UUID getUniqueId(@NotNull Perspective var1);

    protected abstract void clearOpenAnvils();

    protected abstract boolean isActive();

    protected abstract boolean isPaused();

    protected abstract boolean isInitiator(@NotNull Perspective var1);

    @NotNull
    protected abstract PlayerInventory getPlayerInventory(@NotNull Perspective var1);

    public abstract void synchronizePlayerInventory(@NotNull Perspective var1);

    @Nullable
    protected abstract ItemStack removeReceivedItem(@NotNull Perspective var1, int var2);

    @NotNull
    protected abstract CompletableFuture<Boolean> canFinish();

    protected abstract void onItemPickUp(@NotNull Perspective var1);

    public abstract void updateDisplayItem(@NotNull Perspective var1, int var2, @Nullable ItemStack var3);

    @Nullable
    public abstract ItemStack getCurrentOfferedItem(@NotNull Perspective var1, int var2);

    @Nullable
    protected abstract ItemStack getCurrentDisplayedItem(@NotNull Perspective var1, int var2);

    @NotNull
    protected abstract CompletableFuture<Void> markAsInitialized();

    @NotNull
    protected abstract Stream<Player> getParticipants();

    protected abstract void onReadyStateChange(@NotNull Perspective var1, boolean var2);

    void start() {
        this.buildPattern();
        this.initializeGUIs();
        this.startListeners();
        this.createGUIs();
        this.markAsInitialized().whenComplete((v, t) -> {
            if (t != null) {
                TradeSystem.getInstance().getLogger().log(Level.SEVERE, "Failed to initialize trade", (Throwable)t);
                this.cancel();
                return;
            }
            this.synchronizePlayerInventory(Perspective.PRIMARY);
            this.synchronizePlayerInventory(Perspective.SECONDARY);
            this.startGUIs();
            this.playStartSound();
        });
    }

    protected void buildPattern() {
        this.pattern = TradeSystem.getInstance().getLayoutManager().getActive();
        this.buildSlots();
        this.layout[0] = this.pattern.build();
        this.layout[1] = this.pattern.build();
    }

    private void buildSlots() {
        this.slots.addAll(this.pattern.getSlotsOf(TradeSlot.class));
        Collections.sort(this.slots);
        this.otherSlots.addAll(this.pattern.getSlotsOf(TradeSlotOther.class));
        this.otherSlots.sort((o1, o2) -> {
            int row2;
            int row1 = o1 / 9;
            if (row1 != (row2 = o2 / 9)) {
                return Integer.compare(row1, row2);
            }
            return Integer.compare(o2, o1);
        });
    }

    private void startListeners() {
        this.pickupListener = this.getPickUpListener();
        Bukkit.getPluginManager().registerEvents(this.pickupListener, (Plugin)TradeSystem.getInstance());
    }

    @NotNull
    private Set<Perspective> updateDisplayedItems() {
        HashSet<Perspective> change = new HashSet<Perspective>();
        if (this.isActive()) {
            for (Perspective perspective : Perspective.main()) {
                if (this.guis[perspective.id()] == null) continue;
                for (int slotId = 0; slotId < this.slots.size(); ++slotId) {
                    ItemStack other;
                    ItemStack item = this.guis[perspective.id()].getItem(this.slots.get(slotId));
                    if (Objects.equals(item, other = this.getCurrentDisplayedItem(perspective.flip(), slotId))) continue;
                    change.add(perspective);
                    this.updateDisplayItem(perspective.flip(), slotId, item);
                    this.onTradeOfferChange(false);
                }
            }
            for (Perspective perspective : Perspective.main()) {
                if (this.guis[perspective.id()] == null) continue;
                this.updateStatusIcon(perspective);
            }
        }
        return change;
    }

    public void onTradeOfferChange(boolean invokeTradeUpdate) {
        if (TradeSystem.handler().isRevokeReadyOnChange()) {
            this.setReadyState(Perspective.PRIMARY, false);
            this.setReadyState(Perspective.SECONDARY, false);
        }
        if (invokeTradeUpdate) {
            this.update();
        }
    }

    protected void updateStatusIcon(@NotNull Perspective perspective) {
        Player player = this.getPlayer(perspective);
        if (player == null) {
            return;
        }
        StatusIcon icon = this.layout[perspective.id()].getIcon(StatusIcon.class);
        icon.updateButton(this, player);
        ShowStatusIcon showIcon = this.layout[perspective.id()].getIcon(ShowStatusIcon.class);
        showIcon.updateButton(this, player);
    }

    public void subscribe(@NotNull Runnable runnable) {
        this.subscribers.add(runnable);
    }

    public void unsubscribe(@NotNull Runnable runnable) {
        this.subscribers.remove(runnable);
    }

    public void update() {
        Set<Perspective> someChange = this.updateDisplayedItems();
        if (!someChange.isEmpty()) {
            this.closeShulkerPeekingGUIs(someChange);
        }
        if (this.ready[0] && this.ready[1]) {
            this.finish().whenComplete((suc, err) -> {
                if (err != null) {
                    err.printStackTrace();
                } else if (suc.booleanValue()) {
                    this.cleanUp();
                }
            });
        } else if (this.countdown != null) {
            this.playCountDownStopSound();
            this.countdown.cancel();
            this.countdownTicks = 0;
            this.countdown = null;
            this.synchronizeTitle();
        }
        this.subscribers.forEach(Runnable::run);
        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> this.getViewers().forEach(Player::updateInventory));
    }

    private boolean setReadyState(@NotNull Perspective perspective, boolean ready) {
        if (this.ready[perspective.id()] == ready) {
            return false;
        }
        this.ready[perspective.id()] = ready;
        this.onReadyStateChange(perspective, ready);
        return true;
    }

    private void updateReady(@NotNull Perspective perspective, boolean ready) {
        if (this.setReadyState(perspective, ready)) {
            this.update();
        }
    }

    public void updateLater(long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), this::update, delay);
    }

    public void updateLater() {
        this.updateLater(0L);
    }

    protected boolean tryFinish(@NotNull Perspective perspective) {
        Player player = this.getPlayer(perspective);
        if (player == null) {
            return false;
        }
        for (TradeIcon icon : this.layout[perspective.id()].getIcons()) {
            if (icon == null) continue;
            EditorInfo info = IconHandler.getInfo(icon.getClass());
            if (!info.matchRequirements()) {
                TradeSystem.getInstance().getLogger().warning("Could not finish a trade between players '" + this.getNames()[0] + "' and '" + this.getNames()[1] + "'. Reason: The requirements for icon '" + info.getName() + "' are not met. Maybe a plugin has been disabled?");
                return false;
            }
            FinishResult result = icon.tryFinish(this, perspective, player, this.initiationServer);
            switch (result) {
                case ERROR_ECONOMY: {
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private CompletableFuture<Boolean> finish() {
        if (this.countdown != null) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.isActive()) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isPaused()) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)((CompletableFuture)this.runCountdown().thenApply($ -> {
            for (Perspective perspective : Perspective.main()) {
                Player player = this.getPlayer(perspective);
                if (player == null) continue;
                if (!this.tryFinish(perspective)) {
                    return false;
                }
                this.prepareFinish(perspective);
            }
            return true;
        })).thenCompose(ready -> ready != false ? this.canFinish() : CompletableFuture.completedFuture(false))).thenApply(ready -> {
            if (!ready.booleanValue()) {
                this.callEconomyError();
                return false;
            }
            boolean logFinish = false;
            boolean[] droppedItems = new boolean[2];
            TradeResult[] results = this.createResults();
            for (Perspective perspective : Perspective.main()) {
                Player player = this.getPlayer(perspective);
                if (player == null) continue;
                boolean initiator = this.isInitiator(perspective);
                droppedItems[perspective.id()] = this.exchangeItems(perspective, initiator);
                if (!initiator) continue;
                logFinish = true;
            }
            for (Perspective perspective : Perspective.main()) {
                this.sendReport(perspective, droppedItems[perspective.id()], results[perspective.id()]);
            }
            for (Perspective perspective : Perspective.main()) {
                this.exchangeOtherGoods(perspective);
            }
            for (Perspective perspective : Perspective.main()) {
                this.postFinish(perspective);
            }
            if (logFinish) {
                TradeLogService.logLater(this.names[0], this.names[1], TradeLog.FINISHED.get(new Object[0]), 10L);
            }
            this.closeTrade(results);
            return true;
        });
    }

    @NotNull
    protected CompletableFuture<Void> runCountdown() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        int interval = TradeSystem.handler().getCountdownInterval();
        final int repetitions = TradeSystem.handler().getCountdownRepetitions();
        this.countdown = new BukkitRunnable(){

            public void run() {
                if (!Trade.this.isActive()) {
                    this.cancel();
                    Trade.this.countdownTicks = 0;
                    Trade.this.countdown = null;
                    return;
                }
                if (!Trade.this.ready[0] || !Trade.this.ready[1]) {
                    this.cancel();
                    Trade.this.getViewers().forEach(p -> TradeSystem.handler().playCountdownStopSound((Player)p));
                    Trade.this.countdownTicks = 0;
                    Trade.this.countdown = null;
                    Trade.this.subscribers.forEach(Runnable::run);
                    Trade.this.guis().forEach(TradingGUI::synchronizeTitle);
                    return;
                }
                Trade.this.subscribers.forEach(Runnable::run);
                if (Trade.this.countdownTicks == repetitions) {
                    future.complete(null);
                    this.cancel();
                    Trade.this.countdownTicks = 0;
                    Trade.this.countdown = null;
                    return;
                }
                Trade.this.guis().forEach(TradingGUI::synchronizeTitle);
                Trade.this.getViewers().forEach(p -> TradeSystem.handler().playCountdownTickSound((Player)p));
                ++Trade.this.countdownTicks;
            }
        };
        this.countdown.runTaskTimer((Plugin)TradeSystem.getInstance(), 0L, (long)interval);
        return future;
    }

    private void prepareFinish(@NotNull Perspective perspective) {
        Player player = this.getPlayer(perspective);
        if (player == null) {
            return;
        }
        this.pause[perspective.id()] = true;
        player.closeInventory();
    }

    @NotNull
    private TradeResult[] createResults() {
        return new TradeResult[]{this.createResult(Perspective.PRIMARY), this.createResult(Perspective.SECONDARY)};
    }

    @NotNull
    private TradeResult createResult(@NotNull Perspective perspective) {
        if (perspective.isTertiary()) {
            throw new IllegalArgumentException("Perspective cannot be tertiary.");
        }
        Player player = this.getPlayer(perspective);
        UUID id = this.getUniqueId(perspective);
        TradeResult result = player == null ? new TradeResult(id, this.getWorld(perspective), this.getServer(perspective), perspective) : new PlayerTradeResult(this, player, perspective);
        for (int i = 0; i < this.slots.size(); ++i) {
            result.add(this.getCurrentOfferedItem(perspective, i), false);
            result.add(this.getCurrentDisplayedItem(perspective, i), true);
        }
        for (TradeIcon icon : this.layout[perspective.id()].getIcons()) {
            if (icon == null) continue;
            result.add(icon);
        }
        return result;
    }

    protected boolean exchangeItems(@NotNull Perspective perspective, boolean initiator) {
        Player player = this.getPlayer(perspective);
        if (player == null) {
            throw new IllegalStateException("Player cannot be null!");
        }
        Player other = this.getPlayer(perspective.flip());
        boolean droppedItems = false;
        for (int slotId = 0; slotId < this.slots.size(); ++slotId) {
            ItemStack item = this.removeReceivedItem(perspective, slotId);
            if (item != null && item.getType() != Material.AIR) {
                TradeLog.logItemReceive(player, initiator, this.names[perspective.flip().id()], this.getUniqueId(perspective.flip()), item);
            }
            if ((item = this.callTradeItemEvent(player, other, this.names[perspective.flip().id()], item)) == null || item.getType() == Material.AIR) continue;
            int rest = Trade.checkItemFit(player, item);
            if (rest <= 0) {
                player.getInventory().addItem(new ItemStack[]{item});
                continue;
            }
            ItemStack toDrop = item.clone();
            toDrop.setAmount(rest);
            item.setAmount(item.getAmount() - rest);
            if (item.getAmount() > 0) {
                player.getInventory().addItem(new ItemStack[]{item});
            }
            droppedItems |= this.dropItem(player, toDrop);
        }
        return droppedItems;
    }

    protected void exchangeOtherGoods(@NotNull Perspective perspective) {
        Player player = this.getPlayer(perspective);
        if (player == null) {
            return;
        }
        for (TradeIcon icon : this.layout[perspective.id()].getIcons()) {
            if (icon == null) continue;
            icon.onFinish(this, perspective, player, this.initiationServer);
        }
    }

    public void cancel() {
        this.cancel(null);
    }

    private void callEconomyError() {
        this.cancel(Lang.getPrefix() + Lang.get("Economy_Error", new Lang.P[0]));
    }

    protected void cancelling(@Nullable String message) {
    }

    public void cancel(@Nullable String message) {
        this.cancel(message, false);
    }

    public synchronized void cancel(@Nullable String message, boolean alreadyCalled) {
        boolean alreadyClosed;
        if (this.cancelling) {
            return;
        }
        TradeResult[] results = this.createResults();
        this.cancelling = true;
        boolean[] droppedItems = this.returnItemsToOwner();
        boolean bl = alreadyClosed = droppedItems == null;
        if (alreadyClosed) {
            return;
        }
        this.cleanUp();
        this.clearOpenAnvils();
        this.playCancelSound();
        this.closeInventories();
        this.guis[0] = null;
        this.guis[1] = null;
        TradeSystem.handler().unregisterTrade(this.names[0]);
        TradeSystem.handler().unregisterTrade(this.names[1]);
        if (!alreadyCalled) {
            this.cancelling(message);
        }
        if (message != null) {
            if (this.initiationServer) {
                TradeLogService.log(this.names[0], this.names[1], TradeLog.CANCELLED_WITH_REASON.get(message));
            }
            this.sendMessage(message);
        } else {
            if (this.initiationServer) {
                TradeLogService.log(this.names[0], this.names[1], TradeLog.CANCELLED.get(new Object[0]));
            }
            this.getViewers().forEach(player -> {
                Perspective perspective = this.getPerspective((Player)player);
                if (perspective.isMain()) {
                    String m = Lang.getPrefix() + this.getPlaceholderMessage(perspective, "Trade_Was_Cancelled");
                    this.sendMessage(perspective, m);
                } else {
                    Lang.send((CommandSender)player, "Trade_Was_Cancelled", new Lang.P[0]);
                }
            });
        }
        for (Perspective perspective : Perspective.main()) {
            if (!droppedItems[perspective.id()]) continue;
            this.sendMessage(perspective, Lang.getPrefix() + this.getPlaceholderMessage(perspective, "Items_Dropped"));
        }
        this.closeTrade(results);
    }

    private void sendReport(@NotNull Perspective perspective, boolean droppedItems, @NotNull TradeResult result) {
        PlayerTradeResult playerResult;
        Player player = this.getPlayer(perspective);
        PlayerTradeResult playerTradeResult = playerResult = result instanceof PlayerTradeResult ? (PlayerTradeResult)result : null;
        if (player != null && playerResult != null) {
            TradeReportEvent e = this.getPlayerOpt(perspective.flip()).map(other -> new TradeReportEvent(player, (Player)other, playerResult)).orElseGet(() -> new TradeReportEvent(player, this.names[perspective.flip().id()], this.getUniqueId(perspective.flip()), playerResult));
            Bukkit.getPluginManager().callEvent((Event)e);
            if (!e.isCancelled()) {
                player.sendMessage(this.buildFinishMessages(player, perspective, droppedItems, playerResult, e));
            }
            if (e.isPlayFinishSound()) {
                TradeSystem.handler().playFinishSound(player);
            }
        }
    }

    private void postFinish(@NotNull Perspective perspective) {
        if (this.guis[perspective.id()] != null) {
            this.guis[perspective.id()].clear();
        }
        TradeSystem.handler().unregisterTrade(this.names[perspective.id()]);
    }

    private void closeTrade(@NotNull @NotNull TradeResult @NotNull [] results) {
        this.callFinishEvent(results);
    }

    private void callFinishEvent(@NotNull @NotNull TradeResult @NotNull [] results) {
        TradeFinishEvent e;
        Player player = this.getPlayer(Perspective.PRIMARY);
        assert (player != null);
        if (this.isInitiator(Perspective.PRIMARY)) {
            e = this.getPlayerOpt(Perspective.SECONDARY).map(other -> new TradeFinishEvent(player, (Player)other, !this.cancelling, results)).orElseGet(() -> new TradeFinishEvent(player, this.names[Perspective.SECONDARY.id()], this.getUniqueId(Perspective.SECONDARY), !this.cancelling, results));
        } else {
            TradeResult[] swapped = new TradeResult[]{results[1], results[0]};
            e = this.getPlayerOpt(Perspective.SECONDARY).map(other -> new TradeFinishEvent((Player)other, player, !this.cancelling, swapped)).orElseGet(() -> new TradeFinishEvent(this.names[Perspective.SECONDARY.id()], this.getUniqueId(Perspective.SECONDARY), player, !this.cancelling, swapped));
        }
        Bukkit.getPluginManager().callEvent((Event)e);
    }

    @NotNull
    private @NotNull String @NotNull [] buildFinishMessages(@NotNull Player viewer, @NotNull Perspective perspective, boolean droppedItems, @NotNull PlayerTradeResult result, @NotNull TradeReportEvent event) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(Lang.getPrefix() + this.getPlaceholderMessage(perspective, "Trade_Was_Finished"));
        ArrayList<String> list = new ArrayList<String>();
        if (TradeSystem.handler().isTradeReportEconomy()) {
            if (event.getEconomyReport() != null) {
                list.addAll(event.getEconomyReport());
            } else {
                list.addAll(result.buildEconomyReport());
            }
        }
        if (TradeSystem.handler().isTradeReportItems()) {
            if (event.getItemReport() != null) {
                list.addAll(event.getItemReport());
            } else {
                list.addAll(result.buildItemReport());
            }
        }
        list.sort((o1, o2) -> {
            o1 = ChatColor.stripColor(o1).replaceFirst("\\d+(x)?", "");
            o2 = ChatColor.stripColor(o2).replaceFirst("\\d+(x)?", "");
            return o1.compareTo((String)o2);
        });
        messages.addAll(list);
        if (droppedItems) {
            messages.add("");
            messages.add(Lang.getPrefix() + Lang.get("Items_Dropped", viewer, new Lang.P[0]));
        }
        return messages.toArray(new String[0]);
    }

    private void cleanUp() {
        this.stopListeners();
    }

    @Nullable
    protected ItemStack callTradeItemEvent(@NotNull Player receiver, @Nullable Player sender, @NotNull String senderName, @Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        TradeItemEvent event = sender == null ? new TradeItemEvent(receiver, senderName, this.getUniqueId(senderName), item) : new TradeItemEvent(receiver, sender, item);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getItem();
    }

    private void closeShulkerPeekingGUIs(@NotNull Set<Perspective> invokedBy) {
        this.getViewers().forEach(player -> {
            ShulkerPeekGUI shulkerPeek = API.getRemovable(player, ShulkerPeekGUI.class);
            if (shulkerPeek == null) {
                return;
            }
            if (invokedBy.contains((Object)shulkerPeek.getOwner())) {
                try {
                    TradeSystem.handler().playChangeDuringShulkerPeekSound((Player)player);
                    shulkerPeek.close();
                }
                catch (AlreadyClosedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected final boolean[] returnItemsToOwner() {
        if (!this.isActive()) {
            return null;
        }
        boolean[] droppedItems = new boolean[]{false, false};
        for (Integer slot : this.slots) {
            for (int id = 0; id < 2; ++id) {
                if (this.guis[id] == null) continue;
                Player player = this.guis[id].getPlayer();
                if (this.guis[id].getItem(slot) == null || this.guis[id].getItem(slot).getType() == Material.AIR) continue;
                ItemStack item = this.guis[id].getItem(slot);
                int n = id;
                droppedItems[n] = droppedItems[n] | this.addOrDropItem(player, item);
            }
        }
        for (int id = 0; id < 2; ++id) {
            if (this.guis[id] == null) continue;
            Player player = this.guis[id].getPlayer();
            int n = id;
            droppedItems[n] = droppedItems[n] | this.moveCursorItemToInventory(player);
        }
        this.getViewers().filter(this.nonTrader()).forEach(this::moveCursorItemToInventory);
        return droppedItems;
    }

    private boolean moveCursorItemToInventory(@NotNull Player player) {
        ItemStack item = player.getOpenInventory().getCursor();
        if (item != null && item.getType() != Material.AIR) {
            boolean dropped = this.addOrDropItem(player, item);
            player.getOpenInventory().setCursor(null);
            return dropped;
        }
        return false;
    }

    protected boolean canPickup(Player player, ItemStack item) {
        PlayerInventory inv = new PlayerInventory(player, false);
        Perspective perspective = this.getPerspective(player);
        for (Integer slot : this.slots) {
            ItemStack back = this.guis[perspective.id()].getItem(slot);
            if (back == null || back.getType() == Material.AIR) continue;
            inv.addItem(back);
        }
        ItemStack cursor = player.getOpenInventory().getCursor();
        if (cursor != null && !inv.addItem(cursor, false)) {
            return false;
        }
        return inv.addItem(item);
    }

    @NotNull
    private Listener getPickUpListener() {
        return new Listener(){

            @EventHandler
            public void onPickup(PlayerPickupItemEvent e) {
                for (int i = 0; i < 2; ++i) {
                    if (Trade.this.guis[i] == null || !e.getPlayer().getName().equals(Trade.this.names[i])) continue;
                    if (!Trade.this.canPickup(e.getPlayer(), e.getItem().getItemStack())) {
                        e.setCancelled(true);
                        continue;
                    }
                    Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> Trade.this.onItemPickUp(Trade.this.getPerspective(e.getPlayer())), 1L);
                }
            }
        };
    }

    public void cancelItemOverflow(@NotNull Perspective perspective) {
        if (!this.isActive()) {
            return;
        }
        Player player = this.getPlayer(perspective);
        if (player == null) {
            return;
        }
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        for (Integer slot : this.slots) {
            ItemStack item = this.guis[perspective.id()].getItem(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            items.put(slot, item);
        }
        if (items.isEmpty()) {
            return;
        }
        HashMap<Integer, ItemStack> sorted = new HashMap<Integer, ItemStack>();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            int slot = 0;
            ItemStack item = null;
            Iterator<Object> iterator = items.keySet().iterator();
            while (iterator.hasNext()) {
                int nextSlot = (Integer)iterator.next();
                ItemStack next = (ItemStack)items.get(nextSlot);
                if (item != null && item.getAmount() <= next.getAmount()) continue;
                item = next;
                slot = nextSlot;
            }
            if (item == null) continue;
            sorted.put(slot, item);
            items.remove(slot);
        }
        items.clear();
        items.putAll(sorted);
        sorted.clear();
        PlayerInventory inv = this.getPlayerInventory(perspective.flip());
        HashMap<Integer, Integer> toRemove = new HashMap<Integer, Integer>();
        ArrayList slots = new ArrayList(items.keySet());
        slots.sort(Comparator.naturalOrder());
        for (Integer slot : slots) {
            ItemStack item = (ItemStack)items.get(slot);
            int amount = inv.addUntilPossible(item, true);
            if (amount <= 0) continue;
            toRemove.put(slot, amount);
        }
        items.clear();
        slots.clear();
        slots.addAll(toRemove.keySet());
        slots.sort(Comparator.reverseOrder());
        TradingGUI gui = this.guis[perspective.id()];
        for (Integer slot : slots) {
            ItemStack item = gui.getItem(slot).clone();
            item.setAmount(item.getAmount() - (Integer)toRemove.get(slot));
            ItemStack transport = gui.getItem(slot).clone();
            transport.setAmount(((Integer)toRemove.get(slot)).intValue());
            player.getInventory().addItem(new ItemStack[]{transport});
            gui.setItem(slot, item.getAmount() <= 0 ? new ItemStack(Material.AIR) : item);
        }
        this.update();
    }

    public boolean fitsTrade(@NotNull Perspective perspective, @NotNull List<Integer> avoid, @NotNull Collection<ItemStack> items) {
        ArrayList<ItemStack> currentlyAddingItems = new ArrayList<ItemStack>(items);
        TradingGUI gui = this.guis[perspective.id()];
        for (Integer slot : this.slots) {
            ItemStack item;
            if (avoid.contains(slot) || (item = gui.getItem(slot)) == null || item.getType() == Material.AIR) continue;
            currentlyAddingItems.add(item);
        }
        PlayerInventory inv = this.getPlayerInventory(perspective.flip());
        boolean fits = true;
        for (ItemStack item : currentlyAddingItems) {
            if (inv.addItem(item)) continue;
            fits = false;
            break;
        }
        currentlyAddingItems.clear();
        avoid.clear();
        return fits;
    }

    protected final void sendMessage(@NotNull String message) {
        this.getViewers().forEach(player -> player.sendMessage(message));
    }

    public boolean dropItem(Player player, ItemStack itemStack) {
        if (player == null || itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        player.getWorld().dropItem(player.getLocation().add(0.0, 0.1, 0.0), itemStack);
        return true;
    }

    private void stopListeners() {
        if (this.pickupListener != null) {
            HandlerList.unregisterAll((Listener)this.pickupListener);
            this.pickupListener = null;
        }
    }

    @NotNull
    public Perspective getPerspective(@NotNull Player player) {
        return this.getPerspective(player.getName());
    }

    @NotNull
    public Perspective getPerspective(@NotNull String player) {
        if (player.equalsIgnoreCase(this.names[0])) {
            return Perspective.PRIMARY;
        }
        if (player.equalsIgnoreCase(this.names[1])) {
            return Perspective.SECONDARY;
        }
        return Perspective.TERTIARY;
    }

    @NotNull
    public UUID getUniqueId(@NotNull String player) {
        return this.getUniqueId(this.getPerspective(player));
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public List<Integer> getOtherSlots() {
        return this.otherSlots;
    }

    public boolean doesNotFit(@NotNull Perspective from, @NotNull ItemStack item) {
        return this.doesNotFit(from, new ArrayList<Integer>(), item);
    }

    public boolean doesNotFit(@NotNull Perspective from, @NotNull List<Integer> avoid, final @NotNull ItemStack item) {
        return !this.fitsTrade(from, avoid, (Collection<ItemStack>)new ArrayList<ItemStack>(){
            {
                this.add(item);
            }
        });
    }

    public boolean fitsTrade(@NotNull Perspective from, @NotNull Collection<ItemStack> items) {
        return this.fitsTrade(from, new ArrayList<Integer>(), items);
    }

    public static int checkItemFit(@NotNull Player player, @NotNull ItemStack item) {
        int amount = item.getAmount();
        for (int i = 0; i < 36; ++i) {
            ItemStack itemStack = player.getInventory().getContents()[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                return 0;
            }
            if (itemStack.isSimilar(item) && itemStack.getAmount() < itemStack.getMaxStackSize()) {
                amount -= itemStack.getMaxStackSize() - itemStack.getAmount();
            }
            if (amount > 0) continue;
            return 0;
        }
        return amount;
    }

    private boolean addOrDropItem(@NotNull Player player, @NotNull ItemStack item) {
        int fit = Trade.checkItemFit(player, item);
        if (item.getAmount() > fit) {
            item.setAmount(item.getAmount() - fit);
            player.getInventory().addItem(new ItemStack[]{item});
        }
        if (fit > 0) {
            item.setAmount(fit);
            return this.dropItem(player, item);
        }
        return false;
    }

    public void synchronizeTradeIcon(@NotNull Perspective from, @NotNull TradeIcon icon, boolean updateIcon) {
        if (icon instanceof Transition) {
            this.informTransition(icon, from.flip());
        }
        if (updateIcon) {
            icon.updateItem(this, from);
            if (icon instanceof Transition) {
                this.getLayout()[from.id()].getIcon(((Transition)((Object)icon)).getTargetClass()).updateItem(this, from);
            }
        }
    }

    protected void informTransition(@NotNull TradeIcon from, @NotNull Perspective to) {
        try {
            Method method = IconHandler.findInform(from.getClass(), from.getClass());
            TradeIcon consumer = this.getLayout()[to.id()].getIcon(IconHandler.getTransitionTarget(from.getClass()));
            method.invoke((Object)from, consumer);
            consumer.updateItem(this, to);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException("Cannot execute method inform(TradeIcon) of " + from.getClass().getName(), ex);
        }
    }

    public void handleClickResult(@NotNull TradeIcon tradeIcon, @NotNull Perspective perspective, @NotNull Perspective viewer, @NotNull GUI gui, @NotNull IconResult result) {
        switch (result) {
            case PASS: {
                return;
            }
            case UPDATE: {
                this.onTradeOfferChange(true);
                this.synchronizeTradeIcon(perspective, tradeIcon, true);
                this.closeShulkerPeekingGUIs(Collections.singleton(viewer));
                this.updateStatusIcon(perspective);
                break;
            }
            case GUI: {
                try {
                    gui.open();
                    break;
                }
                catch (AlreadyOpenedException alreadyOpenedException) {
                    break;
                }
                catch (IsWaitingException | NoPageException e) {
                    throw new RuntimeException("Error while opening GUI.", e);
                }
            }
            case READY: {
                this.updateReady(perspective, true);
                break;
            }
            case NOT_READY: {
                this.updateReady(perspective, false);
                break;
            }
            case CANCEL: {
                this.cancel();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)result));
            }
        }
    }

    protected final void synchronizeTitle() {
        this.guis().forEach(TradingGUI::synchronizeTitle);
    }

    protected final void closeInventories() {
        this.getViewers().forEach(p -> {
            p.closeInventory();
            p.updateInventory();
        });
        this.guis().forEach(TradingGUI::destroy);
        Bukkit.getScheduler().runTask((Plugin)TradeSystem.getInstance(), () -> this.getViewers().filter(FloodgateUtils::isNonBedrockPlayer).forEach(p -> {
            p.closeInventory();
            p.updateInventory();
        }));
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> this.getViewers().filter(FloodgateUtils::isBedrockPlayer).forEach(p -> {
            p.closeInventory();
            p.updateInventory();
        }), 30L);
    }

    public BukkitRunnable getCountdown() {
        return this.countdown;
    }

    public int getCountdownTicks() {
        return this.countdownTicks;
    }

    public String getOther(String p) {
        if (this.names[0] == null || this.names[1] == null) {
            return null;
        }
        if (this.names[0].equals(p)) {
            return this.names[1];
        }
        return this.names[0];
    }

    public TradeLayout[] getLayout() {
        return this.layout;
    }

    public boolean[] getPause() {
        return this.pause;
    }

    @NotNull
    private Stream<TradingGUI> guis() {
        return Arrays.stream(this.guis).filter(Objects::nonNull);
    }

    public TradingGUI[] getGUIs() {
        return this.guis;
    }

    public boolean inMainGUI(Player player) {
        Perspective perspective = this.getPerspective(player);
        if (perspective.isTertiary()) {
            return false;
        }
        TradingGUI gui = this.guis[perspective.id()];
        return gui.isOpen() && !gui.isWaiting();
    }

    public void acknowledgeGuiSwitch(@NotNull Player player) {
        this.updateReady(this.getPerspective(player), false);
    }

    protected final void playCountDownStopSound() {
        this.getViewers().forEach(p -> TradeSystem.handler().playCountdownStopSound((Player)p));
    }

    protected final void playStartSound() {
        this.getViewers().forEach(p -> TradeSystem.handler().playStartSound((Player)p));
    }

    protected final void playCancelSound() {
        this.getViewers().forEach(p -> TradeSystem.handler().playCancelSound((Player)p));
    }

    public boolean isInitiationServer() {
        return this.initiationServer;
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public boolean[] getReady() {
        return this.ready;
    }

    @NotNull
    private Predicate<Player> nonTrader() {
        return player -> this.getPerspective((Player)player).isTertiary();
    }

    @NotNull
    public final Stream<Player> getViewers() {
        return Stream.concat(this.getParticipants(), this.subscribers.stream().filter(s -> s instanceof PlayerSubscriber).map(s -> ((PlayerSubscriber)s).getPlayer()));
    }

    @NotNull
    protected Optional<Player> getPlayerOpt(@NotNull Perspective perspective) {
        return Optional.ofNullable(this.getPlayer(perspective));
    }

    protected void sendMessage(@NotNull Perspective perspective, @NotNull String message) {
        this.getPlayerOpt(perspective).ifPresent(p -> p.sendMessage(message));
    }

    @NotNull
    protected String getPlaceholderMessage(@NotNull Perspective perspective, @NotNull String message) {
        return Lang.get(message, this.getPlayerOpt(perspective).orElse(this.getPlayer(Perspective.PRIMARY)), new Lang.P[0]);
    }
}

