/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.PlayerInventory;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.lib.packetmanagement.packets.impl.BooleanPacket;
import de.codingair.tradesystem.proxy.packets.PlayerInventoryPacket;
import de.codingair.tradesystem.proxy.packets.TradeCheckFinishPacket;
import de.codingair.tradesystem.proxy.packets.TradeIconUpdatePacket;
import de.codingair.tradesystem.proxy.packets.TradeInitializedPacket;
import de.codingair.tradesystem.proxy.packets.TradeItemUpdatePacket;
import de.codingair.tradesystem.proxy.packets.TradeStateUpdatePacket;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.TradingGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.TradeIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.transfer.utils.ItemStackUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ProxyTrade
extends Trade {
    private final Player player;
    private final String other;
    private final CompletableFuture<Void> packetInitialization = new CompletableFuture();
    private final UUID otherId;
    private final String otherWorld;
    private final String otherServer;
    private ItemStack[] sent;
    private ItemStack[] received;
    private final ItemStack[] otherInventory = new ItemStack[36];
    private final CompletableFuture<Boolean> finishCheck = new CompletableFuture();

    public ProxyTrade(@NotNull Player player, @NotNull String other, @NotNull UUID otherId, boolean initiationServer, @NotNull String otherWorld, @NotNull String otherServer) {
        super(player.getName(), other, initiationServer);
        this.player = player;
        this.other = other;
        this.otherId = otherId;
        this.otherWorld = otherWorld;
        this.otherServer = otherServer;
    }

    @Override
    protected void buildPattern() {
        super.buildPattern();
        this.sent = new ItemStack[this.getSlots().size()];
        this.received = new ItemStack[this.getSlots().size()];
    }

    public void receiveItemData(int slotId, @Nullable ItemStack item) {
        boolean ownItem;
        boolean bl = ownItem = slotId >= this.otherSlots.size();
        if (ownItem) {
            this.sent[slotId %= this.otherSlots.size()] = item;
            this.guis[0].setItem((Integer)this.slots.get(slotId), item);
            this.onTradeOfferChange(false);
        } else {
            this.received[slotId] = item;
            this.guis[0].setItem((Integer)this.otherSlots.get(slotId), item);
        }
        this.update();
    }

    public boolean receiveFinishCheck() {
        boolean success = this.tryFinish(Perspective.PRIMARY);
        this.finishCheck.complete(success);
        return success;
    }

    public void receiveState(@NotNull TradeStateUpdatePacket.State state, @Nullable String extra) {
        switch (state) {
            case READY: {
                this.ready[1] = true;
                this.update();
                break;
            }
            case NOT_READY: {
                this.ready[1] = false;
                this.update();
                break;
            }
            case CANCELLED: {
                this.cancel(extra, true);
            }
        }
    }

    public void receiveTradeIconUpdate(@NotNull TradeIcon icon) {
        this.onTradeOfferChange(true);
        super.synchronizeTradeIcon(Perspective.SECONDARY, icon, false);
    }

    @Override
    public void synchronizeTradeIcon(@NotNull Perspective from, @NotNull TradeIcon icon, boolean updateIcon) {
        super.synchronizeTradeIcon(from, icon, updateIcon);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            icon.serialize(out);
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred while serializing " + icon.getClass().getName(), e);
        }
        int slot = this.layout[from.id()].getSlotOf(icon);
        TradeIconUpdatePacket packet = new TradeIconUpdatePacket(this.player.getName(), this.other, slot, baos.toByteArray());
        TradeSystem.proxyHandler().send(packet, this.player);
    }

    public void synchronizeState(@NotNull TradeStateUpdatePacket.State state, @Nullable String extra) {
        TradeStateUpdatePacket packet = new TradeStateUpdatePacket(this.player.getName(), this.other, state, extra);
        TradeSystem.proxyHandler().send(packet, this.player);
    }

    @NotNull
    private ItemStack getItemPlaceholder(int slot) {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("TRADE PLACEHOLDER ITEM " + slot);
        item.setItemMeta(meta);
        return item;
    }

    private void synchronizeItem(int slotId, @Nullable ItemStack item) {
        try {
            TradeItemUpdatePacket packet = new TradeItemUpdatePacket(this.player.getName(), this.other, ItemStackUtils.serialize(item), (byte)slotId);
            TradeSystem.proxyHandler().send(packet, this.player);
            if (slotId < this.slots.size()) {
                this.sent[slotId] = item == null ? null : item.clone();
            } else {
                this.received[slotId %= this.slots.size()] = item == null ? null : item.clone();
                this.guis[0].setItem((Integer)this.otherSlots.get(slotId), item);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private ItemStack getSent(int slotId) {
        return this.sent[slotId];
    }

    @Nullable
    private ItemStack getReceived(int slotId) {
        return this.received[slotId];
    }

    @Override
    @Nullable
    protected ItemStack removeReceivedItem(@NotNull Perspective perspective, int slotId) {
        ItemStack item = this.received[slotId];
        this.received[slotId] = null;
        return item;
    }

    @Override
    public void updateDisplayItem(@NotNull Perspective perspective, int slotId, @Nullable ItemStack item) {
        if (perspective == Perspective.PRIMARY) {
            this.synchronizeItem(slotId += this.slots.size(), item);
            this.update();
        } else {
            this.synchronizeItem(slotId, item);
        }
    }

    @Override
    @Nullable
    public ItemStack getCurrentOfferedItem(@NotNull Perspective perspective, int slotId) {
        if (perspective.isSecondary()) {
            return this.getReceived(slotId);
        }
        return this.guis[0].getItem((Integer)this.slots.get(slotId));
    }

    @Override
    @Nullable
    protected ItemStack getCurrentDisplayedItem(@NotNull Perspective perspective, int slotId) {
        if (perspective.isSecondary()) {
            return this.getSent(slotId);
        }
        return this.getReceived(slotId);
    }

    @Override
    @NotNull
    protected CompletableFuture<Void> markAsInitialized() {
        TradeSystem.proxyHandler().send(new TradeInitializedPacket(this.other), this.player);
        Bukkit.getScheduler().runTaskLater((Plugin)TradeSystem.getInstance(), () -> this.packetInitialization.completeExceptionally(new IllegalStateException("Other player did not respond.")), 20L);
        return this.packetInitialization;
    }

    public void receiveFirstPacket() {
        this.packetInitialization.complete(null);
    }

    @Override
    protected void initializeGUIs() {
        this.guis[0] = new TradingGUI(this.player, this, 0);
    }

    @Override
    protected void createGUIs() {
        this.guis[0].prepareStart();
    }

    @Override
    protected void startGUIs() {
        try {
            this.guis[0].open();
        }
        catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Player getPlayer(@NotNull Perspective perspective) {
        if (perspective == Perspective.PRIMARY) {
            return this.player;
        }
        return null;
    }

    @Override
    @NotNull
    public String getWorld(@NotNull Perspective perspective) {
        if (perspective == Perspective.PRIMARY) {
            return this.player.getWorld().getName();
        }
        if (perspective == Perspective.SECONDARY) {
            return this.otherWorld;
        }
        throw new IllegalArgumentException("Unknown perspective: " + (Object)((Object)perspective));
    }

    @Override
    @Nullable
    public String getServer(@NotNull Perspective perspective) {
        if (perspective == Perspective.SECONDARY) {
            return this.otherServer;
        }
        return TradeSystem.proxy().getServerName();
    }

    @Override
    @NotNull
    public UUID getUniqueId(@NotNull Perspective perspective) {
        if (perspective.isPrimary()) {
            return this.player.getUniqueId();
        }
        return this.otherId;
    }

    @Override
    protected void onReadyStateChange(@NotNull Perspective perspective, boolean ready) {
        if (!perspective.isPrimary()) {
            return;
        }
        if (ready) {
            this.synchronizeState(TradeStateUpdatePacket.State.READY, null);
        } else {
            this.synchronizeState(TradeStateUpdatePacket.State.NOT_READY, null);
        }
    }

    @Override
    protected void onItemPickUp(@NotNull Perspective perspective) {
        this.synchronizePlayerInventory(perspective);
    }

    @Override
    protected void cancelling(@Nullable String message) {
        this.synchronizeState(TradeStateUpdatePacket.State.CANCELLED, message);
    }

    @Override
    protected void clearOpenAnvils() {
        for (AnvilGUI gui : API.getRemovables(this.player, AnvilGUI.class)) {
            gui.clearInventory();
        }
    }

    @Override
    @NotNull
    protected CompletableFuture<Boolean> canFinish() {
        return ((CompletableFuture)TradeSystem.proxyHandler().send(new TradeCheckFinishPacket(this.player.getName(), this.other), this.player).thenApply(BooleanPacket::getBoolean)).thenCompose(ready -> ready != false ? this.finishCheck : CompletableFuture.completedFuture(false));
    }

    @Override
    @NotNull
    protected Stream<Player> getParticipants() {
        return Stream.of(this.player);
    }

    @Override
    @NotNull
    protected PlayerInventory getPlayerInventory(@NotNull Perspective perspective) {
        if (perspective.isPrimary()) {
            ItemStack item;
            PlayerInventory inventory = new PlayerInventory(this.player, false);
            if (inventory.getPlayer() != null && (item = inventory.getPlayer().getOpenInventory().getCursor()) != null && item.getType() != Material.AIR) {
                inventory.addItem(item);
            }
            return inventory;
        }
        ItemStack[] otherInventory = new ItemStack[this.otherInventory.length];
        for (int i = 0; i < otherInventory.length; ++i) {
            otherInventory[i] = this.otherInventory[i] == null ? null : this.otherInventory[i].clone();
        }
        return new PlayerInventory(otherInventory);
    }

    @Override
    public void synchronizePlayerInventory(@NotNull Perspective perspective) {
        if (!perspective.isPrimary()) {
            return;
        }
        if (this.guis[0] == null) {
            return;
        }
        ItemStack[] contents = this.player.getInventory().getContents();
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack item = contents[slot];
            byte[] data = item == null || item.getType() == Material.AIR ? null : (ItemStackUtils.isCompatible(item) ? ItemStackUtils.serialize(item) : ItemStackUtils.serialize(this.getItemPlaceholder(slot)));
            try {
                PlayerInventoryPacket packet = new PlayerInventoryPacket(this.player.getName(), this.other, data, slot);
                TradeSystem.proxyHandler().send(packet, this.player);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setOtherInventory(int slot, @Nullable ItemStack item) {
        boolean cannotDropItems;
        this.otherInventory[slot] = item;
        boolean bl = cannotDropItems = !TradeSystem.getInstance().getTradeManager().isDropItems();
        if (cannotDropItems) {
            this.cancelItemOverflow(Perspective.PRIMARY);
        }
    }

    @Override
    protected void informTransition(@NotNull TradeIcon from, @NotNull Perspective to) {
        if (to == Perspective.SECONDARY) {
            return;
        }
        super.informTransition(from, to);
    }

    @Override
    protected boolean isActive() {
        return this.guis[0] != null;
    }

    @Override
    protected boolean isPaused() {
        return this.pause[0];
    }

    @Override
    protected boolean isInitiator(@NotNull Perspective perspective) {
        return perspective.isPrimary() && this.initiationServer;
    }
}

