/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.codingapi.utils.ChatColor;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.TradeResult;
import de.codingair.tradesystem.spigot.trade.gui.layout.types.impl.economy.EconomyIcon;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import de.codingair.tradesystem.spigot.utils.Lang;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerTradeResult
extends TradeResult {
    private final Trade trade;
    private final Player player;

    public PlayerTradeResult(@NotNull Trade trade, @NotNull Player player, @NotNull Perspective perspective) {
        super(player.getUniqueId(), player.getWorld().getName(), TradeSystem.proxy().getServerName(), perspective);
        this.trade = trade;
        this.player = player;
    }

    @NotNull
    List<String> buildItemReport() {
        return this.buildItemReport(PlayerTradeResult.itemToNameMapper());
    }

    @NotNull
    public static Function<ItemStack, String> itemToNameMapper() {
        return item -> {
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                assert (meta != null);
                if (meta.hasDisplayName()) {
                    return TradeSystem.handler().isOnlyDisplayNameInMessage() ? meta.getDisplayName() : PlayerTradeResult.formatName(item.getType().name()) + " (" + ChatColor.stripColor(meta.getDisplayName()) + ")";
                }
            }
            return PlayerTradeResult.formatName(item.getType().name());
        };
    }

    @NotNull
    public List<String> buildItemReport(Function<ItemStack, String> mapper) {
        int amount2;
        ArrayList<String> lines = new ArrayList<String>();
        HashMap<ItemStack, Integer> receiving = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> sending = new HashMap<ItemStack, Integer>();
        for (ItemStack item2 : this.sendingItems) {
            amount2 = item2.getAmount();
            item2.setAmount(1);
            sending.merge(item2, amount2, Integer::sum);
        }
        for (ItemStack item2 : this.receivingItems) {
            amount2 = item2.getAmount();
            item2.setAmount(1);
            receiving.merge(item2, amount2, Integer::sum);
        }
        receiving.forEach((item, amount) -> {
            item.setAmount(amount.intValue());
            String itemName = Lang.get("Trade_Finish_Report_Object_Item", this.player, new Lang.P("amount", String.valueOf(amount)), new Lang.P("item", (String)mapper.apply((ItemStack)item)));
            Lang.P info = new Lang.P("object", itemName);
            lines.add(Lang.get("Trade_Finish_Report_Receive", this.player, info));
        });
        sending.forEach((item, amount) -> {
            item.setAmount(amount.intValue());
            String itemName = Lang.get("Trade_Finish_Report_Object_Item", this.player, new Lang.P("amount", String.valueOf(amount)), new Lang.P("item", (String)mapper.apply((ItemStack)item)));
            Lang.P info = new Lang.P("object", itemName);
            lines.add(Lang.get("Trade_Finish_Report_Give", this.player, info));
        });
        return lines;
    }

    @NotNull
    List<String> buildEconomyReport() {
        ArrayList<String> lines = new ArrayList<String>();
        for (EconomyIcon icon : this.economyIcons) {
            Lang.P info;
            BigDecimal diff = icon.getOverallDifference(this.trade, this.perspective);
            if (diff.signum() == 0) continue;
            boolean receive = diff.signum() > 0;
            boolean singular = diff.equals(BigDecimal.ONE);
            if (receive) {
                info = new Lang.P("object", icon.makeString(this.trade, this.perspective, this.player, diff, false) + " " + icon.getName(this.player, singular));
                lines.add(Lang.get("Trade_Finish_Report_Receive", this.player, info));
                continue;
            }
            info = new Lang.P("object", icon.makeString(this.trade, this.perspective, this.player, diff.negate(), true) + " " + icon.getName(this.player, singular));
            lines.add(Lang.get("Trade_Finish_Report_Give", this.player, info));
        }
        return lines;
    }

    @NotNull
    public static String formatName(@NotNull String name) {
        if (name.isEmpty()) {
            return name;
        }
        StringBuilder b = new StringBuilder(name.toLowerCase());
        int i = 0;
        do {
            b.replace(i, i + 1, b.substring(i, i + 1).toUpperCase());
            i = b.indexOf("_", i);
            if (i < 0) continue;
            b.replace(i, i + 1, " ");
        } while (++i > 0 && i < b.length());
        return b.toString().trim();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Trade getTrade() {
        return this.trade;
    }
}

