/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.spigot.trade;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.PlayerInventory;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.AlreadyOpenedException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.IsWaitingException;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.v2.exceptions.NoPageException;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import de.codingair.tradesystem.spigot.TradeSystem;
import de.codingair.tradesystem.spigot.trade.Trade;
import de.codingair.tradesystem.spigot.trade.gui.TradingGUI;
import de.codingair.tradesystem.spigot.trade.gui.layout.utils.Perspective;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitTrade
extends Trade {
    private final Player[] players = new Player[2];

    BukkitTrade(Player p0, Player p1, boolean initiationServer) {
        super(p0.getName(), p1.getName(), initiationServer);
        this.players[0] = p0;
        this.players[1] = p1;
    }

    @Override
    protected void initializeGUIs() {
        this.guis[0] = new TradingGUI(this.players[0], this, 0);
        this.guis[1] = new TradingGUI(this.players[1], this, 1);
    }

    @Override
    protected void createGUIs() {
        this.guis[0].prepareStart();
        this.guis[1].prepareStart();
    }

    @Override
    protected void startGUIs() {
        try {
            this.guis[0].open();
            this.guis[1].open();
        }
        catch (AlreadyOpenedException | IsWaitingException | NoPageException e) {
            throw new RuntimeException("Cannot open trading GUI.", e);
        }
    }

    @Override
    public void updateDisplayItem(@NotNull Perspective perspective, int slotId, @Nullable ItemStack item) {
        this.guis[perspective.id()].setItem((Integer)this.otherSlots.get(slotId), item);
    }

    @Override
    @Nullable
    public ItemStack getCurrentOfferedItem(@NotNull Perspective perspective, int slotId) {
        return this.guis[perspective.id()].getItem((Integer)this.slots.get(slotId));
    }

    @Override
    @Nullable
    protected ItemStack getCurrentDisplayedItem(@NotNull Perspective perspective, int slotId) {
        return this.guis[perspective.id()].getItem((Integer)this.otherSlots.get(slotId));
    }

    @Override
    @NotNull
    protected CompletableFuture<Void> markAsInitialized() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected void clearOpenAnvils() {
        for (Player player : this.players) {
            for (AnvilGUI gui : API.getRemovables(player, AnvilGUI.class)) {
                gui.clearInventory();
            }
        }
    }

    @Override
    @Nullable
    public Player getPlayer(@NotNull Perspective perspective) {
        return this.players[perspective.id()];
    }

    @Override
    @NotNull
    public String getWorld(@NotNull Perspective perspective) {
        return this.players[perspective.id()].getWorld().getName();
    }

    @Override
    @Nullable
    public String getServer(@NotNull Perspective perspective) {
        return TradeSystem.proxy().getServerName();
    }

    @Override
    @NotNull
    public UUID getUniqueId(@NotNull Perspective perspective) {
        return this.players[perspective.id()].getUniqueId();
    }

    @Override
    protected void onItemPickUp(@NotNull Perspective perspective) {
        this.cancelItemOverflow(perspective.flip());
    }

    @Override
    protected boolean isActive() {
        return this.guis[0] != null && this.guis[1] != null;
    }

    @Override
    protected boolean isPaused() {
        return this.pause[0] && this.pause[1];
    }

    @Override
    protected boolean isInitiator(@NotNull Perspective perspective) {
        return perspective.isPrimary();
    }

    @Override
    @NotNull
    protected PlayerInventory getPlayerInventory(@NotNull Perspective perspective) {
        ItemStack item;
        PlayerInventory inventory = new PlayerInventory(this.players[perspective.id()], true);
        if (inventory.getPlayer() != null && (item = inventory.getPlayer().getOpenInventory().getCursor()) != null && item.getType() != Material.AIR) {
            inventory.addItem(item);
        }
        return inventory;
    }

    @Override
    public void synchronizePlayerInventory(@NotNull Perspective perspective) {
    }

    @Override
    @Nullable
    protected ItemStack removeReceivedItem(@NotNull Perspective perspective, int slotId) {
        int slot = (Integer)this.slots.get(slotId);
        ItemStack item = this.guis[perspective.flip().id()].getItem(slot);
        this.guis[perspective.flip().id()].setItem(slot, null);
        return item;
    }

    @Override
    @NotNull
    protected CompletableFuture<Boolean> canFinish() {
        return CompletableFuture.completedFuture(this.ready[0] && this.ready[1]);
    }

    @Override
    @NotNull
    protected Stream<Player> getParticipants() {
        return Arrays.stream(this.players);
    }

    @Override
    protected void onReadyStateChange(@NotNull Perspective perspective, boolean ready) {
    }
}

